/*
 * Decompiled with CFR 0.152.
 */
package org.python.sizeof;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.Locale;
import java.util.Map;
import org.python.sizeof.Constants;
import org.python.sizeof.IdentityHashSet;

public final class RamUsageEstimator {
    public static final String JVM_INFO_STRING;
    public static final long ONE_KB = 1024L;
    public static final long ONE_MB = 0x100000L;
    public static final long ONE_GB = 0x40000000L;
    public static final int NUM_BYTES_BOOLEAN = 1;
    public static final int NUM_BYTES_BYTE = 1;
    public static final int NUM_BYTES_CHAR = 2;
    public static final int NUM_BYTES_SHORT = 2;
    public static final int NUM_BYTES_INT = 4;
    public static final int NUM_BYTES_FLOAT = 4;
    public static final int NUM_BYTES_LONG = 8;
    public static final int NUM_BYTES_DOUBLE = 8;
    public static final int NUM_BYTES_OBJECT_REF;
    public static final int NUM_BYTES_OBJECT_HEADER;
    public static final int NUM_BYTES_ARRAY_HEADER;
    public static final int NUM_BYTES_OBJECT_ALIGNMENT;
    private static final Map<Class<?>, Integer> primitiveSizes;
    private static final Object theUnsafe;
    private static final Method objectFieldOffsetMethod;
    private static final EnumSet<JvmFeature> supportedFeatures;

    private RamUsageEstimator() {
    }

    public static boolean isSupportedJVM() {
        return supportedFeatures.size() == JvmFeature.values().length;
    }

    public static long alignObjectSize(long size) {
        return (size += (long)NUM_BYTES_OBJECT_ALIGNMENT - 1L) - size % (long)NUM_BYTES_OBJECT_ALIGNMENT;
    }

    public static long sizeOf(byte[] arr) {
        return RamUsageEstimator.alignObjectSize((long)NUM_BYTES_ARRAY_HEADER + (long)arr.length);
    }

    public static long sizeOf(boolean[] arr) {
        return RamUsageEstimator.alignObjectSize((long)NUM_BYTES_ARRAY_HEADER + (long)arr.length);
    }

    public static long sizeOf(char[] arr) {
        return RamUsageEstimator.alignObjectSize((long)NUM_BYTES_ARRAY_HEADER + 2L * (long)arr.length);
    }

    public static long sizeOf(short[] arr) {
        return RamUsageEstimator.alignObjectSize((long)NUM_BYTES_ARRAY_HEADER + 2L * (long)arr.length);
    }

    public static long sizeOf(int[] arr) {
        return RamUsageEstimator.alignObjectSize((long)NUM_BYTES_ARRAY_HEADER + 4L * (long)arr.length);
    }

    public static long sizeOf(float[] arr) {
        return RamUsageEstimator.alignObjectSize((long)NUM_BYTES_ARRAY_HEADER + 4L * (long)arr.length);
    }

    public static long sizeOf(long[] arr) {
        return RamUsageEstimator.alignObjectSize((long)NUM_BYTES_ARRAY_HEADER + 8L * (long)arr.length);
    }

    public static long sizeOf(double[] arr) {
        return RamUsageEstimator.alignObjectSize((long)NUM_BYTES_ARRAY_HEADER + 8L * (long)arr.length);
    }

    public static long sizeOf(Object obj) {
        ArrayList<Object> stack = new ArrayList<Object>();
        stack.add(obj);
        return RamUsageEstimator.measureSizeOf(stack);
    }

    public static long sizeOfAll(Object ... objects) {
        return RamUsageEstimator.sizeOfAll(Arrays.asList(objects));
    }

    public static long sizeOfAll(Iterable<Object> objects) {
        ArrayList<Object> stack = objects instanceof Collection ? new ArrayList(((Collection)objects).size()) : new ArrayList<Object>();
        for (Object o2 : objects) {
            stack.add(o2);
        }
        return RamUsageEstimator.measureSizeOf(stack);
    }

    public static long shallowSizeOf(Object obj) {
        if (obj == null) {
            return 0L;
        }
        Class<?> clz = obj.getClass();
        if (clz.isArray()) {
            return RamUsageEstimator.shallowSizeOfArray(obj);
        }
        return RamUsageEstimator.shallowSizeOfInstance(clz);
    }

    public static long shallowSizeOfAll(Object ... objects) {
        return RamUsageEstimator.shallowSizeOfAll(Arrays.asList(objects));
    }

    public static long shallowSizeOfAll(Iterable<Object> objects) {
        long sum = 0L;
        for (Object o2 : objects) {
            sum += RamUsageEstimator.shallowSizeOf(o2);
        }
        return sum;
    }

    public static long shallowSizeOfInstance(Class<?> clazz) {
        if (clazz.isArray()) {
            throw new IllegalArgumentException("This method does not work with array classes.");
        }
        if (clazz.isPrimitive()) {
            return primitiveSizes.get(clazz).intValue();
        }
        long size = NUM_BYTES_OBJECT_HEADER;
        while (clazz != null) {
            Field[] fields;
            for (Field f2 : fields = clazz.getDeclaredFields()) {
                if (Modifier.isStatic(f2.getModifiers())) continue;
                size = RamUsageEstimator.adjustForField(size, f2);
            }
            clazz = clazz.getSuperclass();
        }
        return RamUsageEstimator.alignObjectSize(size);
    }

    public static EnumSet<JvmFeature> getUnsupportedFeatures() {
        EnumSet<JvmFeature> unsupported = EnumSet.allOf(JvmFeature.class);
        unsupported.removeAll(supportedFeatures);
        return unsupported;
    }

    public static EnumSet<JvmFeature> getSupportedFeatures() {
        return EnumSet.copyOf(supportedFeatures);
    }

    private static long shallowSizeOfArray(Object array) {
        long size = NUM_BYTES_ARRAY_HEADER;
        int len = Array.getLength(array);
        if (len > 0) {
            Class<?> arrayElementClazz = array.getClass().getComponentType();
            size = arrayElementClazz.isPrimitive() ? (size += (long)len * (long)primitiveSizes.get(arrayElementClazz).intValue()) : (size += (long)NUM_BYTES_OBJECT_REF * (long)len);
        }
        return RamUsageEstimator.alignObjectSize(size);
    }

    private static long measureSizeOf(ArrayList<Object> stack) {
        IdentityHashSet<Object> seen = new IdentityHashSet<Object>();
        IdentityHashMap classCache = new IdentityHashMap();
        long totalSize = 0L;
        while (!stack.isEmpty()) {
            Object o2;
            Object ob = stack.remove(stack.size() - 1);
            if (ob == null || seen.contains(ob)) continue;
            seen.add(ob);
            Class<?> obClazz = ob.getClass();
            if (obClazz.isArray()) {
                long size = NUM_BYTES_ARRAY_HEADER;
                int len = Array.getLength(ob);
                if (len > 0) {
                    Class<?> componentClazz = obClazz.getComponentType();
                    if (componentClazz.isPrimitive()) {
                        size += (long)len * (long)primitiveSizes.get(componentClazz).intValue();
                    } else {
                        size += (long)NUM_BYTES_OBJECT_REF * (long)len;
                        int i2 = len;
                        while (--i2 >= 0) {
                            o2 = Array.get(ob, i2);
                            if (o2 == null || seen.contains(o2)) continue;
                            stack.add(o2);
                        }
                    }
                }
                totalSize += RamUsageEstimator.alignObjectSize(size);
                continue;
            }
            try {
                ClassCache cachedInfo = (ClassCache)classCache.get(obClazz);
                if (cachedInfo == null) {
                    cachedInfo = RamUsageEstimator.createCacheEntry(obClazz);
                    classCache.put(obClazz, cachedInfo);
                }
                for (Field f2 : cachedInfo.referenceFields) {
                    o2 = f2.get(ob);
                    if (o2 == null || seen.contains(o2)) continue;
                    stack.add(o2);
                }
                totalSize += cachedInfo.alignedShallowInstanceSize;
            }
            catch (IllegalAccessException e2) {
                throw new RuntimeException("Reflective field access failed?", e2);
            }
        }
        seen.clear();
        stack.clear();
        classCache.clear();
        return totalSize;
    }

    private static ClassCache createCacheEntry(Class<?> clazz) {
        long shallowInstanceSize = NUM_BYTES_OBJECT_HEADER;
        ArrayList<Field> referenceFields = new ArrayList<Field>(32);
        for (Class<?> c2 = clazz; c2 != null; c2 = c2.getSuperclass()) {
            Field[] fields;
            if (c2 == Class.class) continue;
            for (Field f2 : fields = c2.getDeclaredFields()) {
                if (Modifier.isStatic(f2.getModifiers())) continue;
                shallowInstanceSize = RamUsageEstimator.adjustForField(shallowInstanceSize, f2);
                if (f2.getType().isPrimitive()) continue;
                f2.setAccessible(true);
                referenceFields.add(f2);
            }
        }
        ClassCache cachedInfo = new ClassCache(RamUsageEstimator.alignObjectSize(shallowInstanceSize), referenceFields.toArray(new Field[referenceFields.size()]));
        return cachedInfo;
    }

    private static long adjustForField(long sizeSoFar, Field f2) {
        int fsize;
        Class<?> type = f2.getType();
        int n2 = fsize = type.isPrimitive() ? primitiveSizes.get(type) : NUM_BYTES_OBJECT_REF;
        if (objectFieldOffsetMethod != null) {
            try {
                long offsetPlusSize = ((Number)objectFieldOffsetMethod.invoke(theUnsafe, f2)).longValue() + (long)fsize;
                return Math.max(sizeSoFar, offsetPlusSize);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException("Access problem with sun.misc.Unsafe", ex);
            }
            catch (InvocationTargetException ite) {
                Throwable cause = ite.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                throw new RuntimeException("Call to Unsafe's objectFieldOffset() throwed checked Exception when accessing field " + f2.getDeclaringClass().getName() + "#" + f2.getName(), cause);
            }
        }
        return sizeSoFar + (long)fsize;
    }

    public static String humanReadableUnits(long bytes) {
        return RamUsageEstimator.humanReadableUnits(bytes, new DecimalFormat("0.#", DecimalFormatSymbols.getInstance(Locale.ENGLISH)));
    }

    public static String humanReadableUnits(long bytes, DecimalFormat df) {
        if (bytes / 0x40000000L > 0L) {
            return df.format((float)bytes / 1.0737418E9f) + " GB";
        }
        if (bytes / 0x100000L > 0L) {
            return df.format((float)bytes / 1048576.0f) + " MB";
        }
        if (bytes / 1024L > 0L) {
            return df.format((float)bytes / 1024.0f) + " KB";
        }
        return bytes + " bytes";
    }

    public static String humanSizeOf(Object object) {
        return RamUsageEstimator.humanReadableUnits(RamUsageEstimator.sizeOf(object));
    }

    static {
        primitiveSizes = new IdentityHashMap();
        primitiveSizes.put(Boolean.TYPE, 1);
        primitiveSizes.put(Byte.TYPE, 1);
        primitiveSizes.put(Character.TYPE, 2);
        primitiveSizes.put(Short.TYPE, 2);
        primitiveSizes.put(Integer.TYPE, 4);
        primitiveSizes.put(Float.TYPE, 4);
        primitiveSizes.put(Double.TYPE, 8);
        primitiveSizes.put(Long.TYPE, 8);
        int referenceSize = Constants.JRE_IS_64BIT ? 8 : 4;
        int objectHeader = Constants.JRE_IS_64BIT ? 16 : 8;
        int arrayHeader = Constants.JRE_IS_64BIT ? 24 : 12;
        supportedFeatures = EnumSet.noneOf(JvmFeature.class);
        Class<?> unsafeClass = null;
        Object tempTheUnsafe = null;
        try {
            unsafeClass = Class.forName("sun.misc.Unsafe");
            Field unsafeField = unsafeClass.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            tempTheUnsafe = unsafeField.get(null);
        }
        catch (Exception e2) {
            // empty catch block
        }
        theUnsafe = tempTheUnsafe;
        try {
            Method arrayIndexScaleM = unsafeClass.getMethod("arrayIndexScale", Class.class);
            referenceSize = ((Number)arrayIndexScaleM.invoke(theUnsafe, Object[].class)).intValue();
            supportedFeatures.add(JvmFeature.OBJECT_REFERENCE_SIZE);
        }
        catch (Exception e3) {
            // empty catch block
        }
        objectHeader = Constants.JRE_IS_64BIT ? 8 + referenceSize : 8;
        arrayHeader = Constants.JRE_IS_64BIT ? 8 + 2 * referenceSize : 12;
        Method tempObjectFieldOffsetMethod = null;
        try {
            Method objectFieldOffsetM = unsafeClass.getMethod("objectFieldOffset", Field.class);
            Field dummy1Field = DummyTwoLongObject.class.getDeclaredField("dummy1");
            int ofs1 = ((Number)objectFieldOffsetM.invoke(theUnsafe, dummy1Field)).intValue();
            Field dummy2Field = DummyTwoLongObject.class.getDeclaredField("dummy2");
            int ofs2 = ((Number)objectFieldOffsetM.invoke(theUnsafe, dummy2Field)).intValue();
            if (Math.abs(ofs2 - ofs1) == 8) {
                Field baseField = DummyOneFieldObject.class.getDeclaredField("base");
                objectHeader = ((Number)objectFieldOffsetM.invoke(theUnsafe, baseField)).intValue();
                supportedFeatures.add(JvmFeature.FIELD_OFFSETS);
                tempObjectFieldOffsetMethod = objectFieldOffsetM;
            }
        }
        catch (Exception e4) {
            // empty catch block
        }
        objectFieldOffsetMethod = tempObjectFieldOffsetMethod;
        try {
            Method arrayBaseOffsetM = unsafeClass.getMethod("arrayBaseOffset", Class.class);
            arrayHeader = ((Number)arrayBaseOffsetM.invoke(theUnsafe, byte[].class)).intValue();
            supportedFeatures.add(JvmFeature.ARRAY_HEADER_SIZE);
        }
        catch (Exception e5) {
            // empty catch block
        }
        NUM_BYTES_OBJECT_REF = referenceSize;
        NUM_BYTES_OBJECT_HEADER = objectHeader;
        NUM_BYTES_ARRAY_HEADER = arrayHeader;
        int objectAlignment = 8;
        try {
            Object hotSpotBean;
            Class<?> beanClazz = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
            try {
                hotSpotBean = ManagementFactory.class.getMethod("getPlatformMXBean", Class.class).invoke(null, beanClazz);
            }
            catch (Exception e1) {
                try {
                    Class<?> sunMF = Class.forName("sun.management.ManagementFactory");
                    hotSpotBean = sunMF.getMethod("getDiagnosticMXBean", new Class[0]).invoke(null, new Object[0]);
                }
                catch (Exception e2) {
                    hotSpotBean = ManagementFactory.newPlatformMXBeanProxy(ManagementFactory.getPlatformMBeanServer(), "com.sun.management:type=HotSpotDiagnostic", beanClazz);
                }
            }
            if (hotSpotBean != null) {
                Method getVMOptionMethod = beanClazz.getMethod("getVMOption", String.class);
                Object vmOption = getVMOptionMethod.invoke(hotSpotBean, "ObjectAlignmentInBytes");
                objectAlignment = Integer.parseInt(vmOption.getClass().getMethod("getValue", new Class[0]).invoke(vmOption, new Object[0]).toString());
                supportedFeatures.add(JvmFeature.OBJECT_ALIGNMENT);
            }
        }
        catch (Exception e6) {
            // empty catch block
        }
        NUM_BYTES_OBJECT_ALIGNMENT = objectAlignment;
        JVM_INFO_STRING = "[JVM: " + Constants.JVM_NAME + ", " + Constants.JVM_VERSION + ", " + Constants.JVM_VENDOR + ", " + Constants.JAVA_VENDOR + ", " + Constants.JAVA_VERSION + "]";
    }

    private static final class DummyTwoLongObject {
        public long dummy1;
        public long dummy2;

        private DummyTwoLongObject() {
        }
    }

    private static final class DummyOneFieldObject {
        public byte base;

        private DummyOneFieldObject() {
        }
    }

    private static final class ClassCache {
        public final long alignedShallowInstanceSize;
        public final Field[] referenceFields;

        public ClassCache(long alignedShallowInstanceSize, Field[] referenceFields) {
            this.alignedShallowInstanceSize = alignedShallowInstanceSize;
            this.referenceFields = referenceFields;
        }
    }

    public static enum JvmFeature {
        OBJECT_REFERENCE_SIZE("Object reference size estimated using array index scale."),
        ARRAY_HEADER_SIZE("Array header size estimated using array based offset."),
        FIELD_OFFSETS("Shallow instance size based on field offsets."),
        OBJECT_ALIGNMENT("Object alignment retrieved from HotSpotDiagnostic MX bean.");

        public final String description;

        private JvmFeature(String description) {
            this.description = description;
        }

        public String toString() {
            return super.name() + " (" + this.description + ")";
        }
    }
}

