/*
 * Decompiled with CFR 0.152.
 */
package org.python.tests;

import junit.framework.TestCase;
import org.python.core.Py;
import org.python.util.PythonInterpreter;

public class ExceptionTest
extends TestCase {
    protected Thrower t;

    public void setUp() {
        String raiser = "from java.lang import Throwable\nfrom org.python.tests.ExceptionTest import Checked, Thrower\nclass Raiser(Thrower):\n    def checked(self):\n         raise Checked()\n    def checkedOrRuntime(self, checked):\n         if checked:\n             raise Checked()\n         else:\n             raise Throwable()\nr = Raiser()";
        PythonInterpreter interp = new PythonInterpreter();
        interp.exec(raiser);
        this.t = Py.tojava(interp.get("r"), Thrower.class);
    }

    public void testRaisingCheckedException() {
        try {
            this.t.checked();
            ExceptionTest.fail((String)"Calling checked should raise Checked!");
        }
        catch (Checked c2) {
            // empty catch block
        }
        try {
            this.t.checkedOrRuntime(true);
            ExceptionTest.fail((String)"Calling checkedOrRuntime(true) should raise Checked!");
        }
        catch (Checked checked) {
            // empty catch block
        }
    }

    public void testRaisingRuntimeException() {
        try {
            this.t.checkedOrRuntime(false);
            ExceptionTest.fail((String)"Calling checkedOrRuntime(false) should raise Throwable!");
        }
        catch (Checked c2) {
            ExceptionTest.fail((String)"Calling checkedOrRuntime(false) should raise Throwable!");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static interface Thrower {
        public void checked() throws Checked;

        public void checkedOrRuntime(boolean var1) throws Checked;
    }

    public static class Checked
    extends Exception {
    }
}

