/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.bp.jdk8;

public final class Jdk8Methods {
    private Jdk8Methods() {
    }

    public static <T> T requireNonNull(T value) {
        if (value == null) {
            throw new NullPointerException("Value must not be null");
        }
        return value;
    }

    public static <T> T requireNonNull(T value, String parameterName) {
        if (value == null) {
            throw new NullPointerException(parameterName + " must not be null");
        }
        return value;
    }

    public static boolean equals(Object a2, Object b2) {
        if (a2 == null) {
            return b2 == null;
        }
        if (b2 == null) {
            return false;
        }
        return a2.equals(b2);
    }

    public static int compareInts(int a2, int b2) {
        if (a2 < b2) {
            return -1;
        }
        if (a2 > b2) {
            return 1;
        }
        return 0;
    }

    public static int compareLongs(long a2, long b2) {
        if (a2 < b2) {
            return -1;
        }
        if (a2 > b2) {
            return 1;
        }
        return 0;
    }

    public static int safeAdd(int a2, int b2) {
        int sum = a2 + b2;
        if ((a2 ^ sum) < 0 && (a2 ^ b2) >= 0) {
            throw new ArithmeticException("Addition overflows an int: " + a2 + " + " + b2);
        }
        return sum;
    }

    public static long safeAdd(long a2, long b2) {
        long sum = a2 + b2;
        if ((a2 ^ sum) < 0L && (a2 ^ b2) >= 0L) {
            throw new ArithmeticException("Addition overflows a long: " + a2 + " + " + b2);
        }
        return sum;
    }

    public static int safeSubtract(int a2, int b2) {
        int result = a2 - b2;
        if ((a2 ^ result) < 0 && (a2 ^ b2) < 0) {
            throw new ArithmeticException("Subtraction overflows an int: " + a2 + " - " + b2);
        }
        return result;
    }

    public static long safeSubtract(long a2, long b2) {
        long result = a2 - b2;
        if ((a2 ^ result) < 0L && (a2 ^ b2) < 0L) {
            throw new ArithmeticException("Subtraction overflows a long: " + a2 + " - " + b2);
        }
        return result;
    }

    public static int safeMultiply(int a2, int b2) {
        long total = (long)a2 * (long)b2;
        if (total < Integer.MIN_VALUE || total > Integer.MAX_VALUE) {
            throw new ArithmeticException("Multiplication overflows an int: " + a2 + " * " + b2);
        }
        return (int)total;
    }

    public static long safeMultiply(long a2, int b2) {
        switch (b2) {
            case -1: {
                if (a2 == Long.MIN_VALUE) {
                    throw new ArithmeticException("Multiplication overflows a long: " + a2 + " * " + b2);
                }
                return -a2;
            }
            case 0: {
                return 0L;
            }
            case 1: {
                return a2;
            }
        }
        long total = a2 * (long)b2;
        if (total / (long)b2 != a2) {
            throw new ArithmeticException("Multiplication overflows a long: " + a2 + " * " + b2);
        }
        return total;
    }

    public static long safeMultiply(long a2, long b2) {
        if (b2 == 1L) {
            return a2;
        }
        if (a2 == 1L) {
            return b2;
        }
        if (a2 == 0L || b2 == 0L) {
            return 0L;
        }
        long total = a2 * b2;
        if (total / b2 != a2 || a2 == Long.MIN_VALUE && b2 == -1L || b2 == Long.MIN_VALUE && a2 == -1L) {
            throw new ArithmeticException("Multiplication overflows a long: " + a2 + " * " + b2);
        }
        return total;
    }

    public static int safeToInt(long value) {
        if (value > Integer.MAX_VALUE || value < Integer.MIN_VALUE) {
            throw new ArithmeticException("Calculation overflows an int: " + value);
        }
        return (int)value;
    }

    public static long floorDiv(long a2, long b2) {
        return a2 >= 0L ? a2 / b2 : (a2 + 1L) / b2 - 1L;
    }

    public static long floorMod(long a2, long b2) {
        return (a2 % b2 + b2) % b2;
    }

    public static int floorMod(long a2, int b2) {
        return (int)((a2 % (long)b2 + (long)b2) % (long)b2);
    }

    public static int floorDiv(int a2, int b2) {
        return a2 >= 0 ? a2 / b2 : (a2 + 1) / b2 - 1;
    }

    public static int floorMod(int a2, int b2) {
        return (a2 % b2 + b2) % b2;
    }
}

