/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.snappy;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.xerial.snappy.Snappy;
import org.xerial.snappy.SnappyFramed;

public final class SnappyFramedOutputStream
extends OutputStream
implements WritableByteChannel {
    public static final int MAX_BLOCK_SIZE = 65536;
    public static final int DEFAULT_BLOCK_SIZE = 65536;
    public static final double DEFAULT_MIN_COMPRESSION_RATIO = 0.85;
    private final ByteBuffer headerBuffer = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);
    private final ByteBuffer buffer;
    private final ByteBuffer directInputBuffer;
    private final ByteBuffer outputBuffer;
    private final double minCompressionRatio;
    private final WritableByteChannel out;
    private boolean closed;

    public SnappyFramedOutputStream(OutputStream outputStream) throws IOException {
        this(outputStream, 65536, 0.85);
    }

    public SnappyFramedOutputStream(OutputStream outputStream, int n2, double d2) throws IOException {
        this(Channels.newChannel(outputStream), n2, d2);
    }

    public SnappyFramedOutputStream(WritableByteChannel writableByteChannel) throws IOException {
        this(writableByteChannel, 65536, 0.85);
    }

    public SnappyFramedOutputStream(WritableByteChannel writableByteChannel, int n2, double d2) throws IOException {
        if (writableByteChannel == null) {
            throw new NullPointerException();
        }
        if (d2 <= 0.0 || d2 > 1.0) {
            throw new IllegalArgumentException("minCompressionRatio " + d2 + " must be in (0,1.0]");
        }
        if (n2 <= 0 || n2 > 65536) {
            throw new IllegalArgumentException("block size " + n2 + " must be in (0, 65536]");
        }
        this.out = writableByteChannel;
        this.minCompressionRatio = d2;
        this.buffer = ByteBuffer.allocate(n2);
        this.directInputBuffer = ByteBuffer.allocateDirect(n2);
        this.outputBuffer = ByteBuffer.allocateDirect(Snappy.maxCompressedLength(n2));
        this.writeHeader(writableByteChannel);
    }

    private void writeHeader(WritableByteChannel writableByteChannel) throws IOException {
        writableByteChannel.write(ByteBuffer.wrap(SnappyFramed.HEADER_BYTES));
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public void write(int n2) throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        if (this.buffer.remaining() <= 0) {
            this.flushBuffer();
        }
        this.buffer.put((byte)n2);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n2 < 0 || n2 > byArray.length || n3 < 0 || n2 + n3 > byArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        while (n3 > 0) {
            if (this.buffer.remaining() <= 0) {
                this.flushBuffer();
            }
            int n4 = Math.min(n3, this.buffer.remaining());
            this.buffer.put(byArray, n2, n4);
            n2 += n4;
            n3 -= n4;
        }
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        if (this.closed) {
            throw new ClosedChannelException();
        }
        if (this.buffer.remaining() <= 0) {
            this.flushBuffer();
        }
        int n2 = byteBuffer.remaining();
        if (this.buffer.remaining() >= byteBuffer.remaining()) {
            this.buffer.put(byteBuffer);
            return n2;
        }
        int n3 = byteBuffer.position() + byteBuffer.remaining();
        while (byteBuffer.position() + this.buffer.remaining() <= n3) {
            byteBuffer.limit(byteBuffer.position() + this.buffer.remaining());
            this.buffer.put(byteBuffer);
            this.flushBuffer();
        }
        byteBuffer.limit(n3);
        this.buffer.put(byteBuffer);
        return n2;
    }

    public long transferFrom(InputStream inputStream) throws IOException {
        int n2;
        if (this.closed) {
            throw new ClosedChannelException();
        }
        if (inputStream == null) {
            throw new NullPointerException();
        }
        if (this.buffer.remaining() == 0) {
            this.flushBuffer();
        }
        assert (this.buffer.hasArray());
        byte[] byArray = this.buffer.array();
        int n3 = this.buffer.arrayOffset();
        long l2 = 0L;
        while ((n2 = inputStream.read(byArray, n3 + this.buffer.position(), this.buffer.remaining())) != -1) {
            this.buffer.position(this.buffer.position() + n2);
            if (this.buffer.remaining() == 0) {
                this.flushBuffer();
            }
            l2 += (long)n2;
        }
        return l2;
    }

    public long transferFrom(ReadableByteChannel readableByteChannel) throws IOException {
        int n2;
        if (this.closed) {
            throw new ClosedChannelException();
        }
        if (readableByteChannel == null) {
            throw new NullPointerException();
        }
        if (this.buffer.remaining() == 0) {
            this.flushBuffer();
        }
        long l2 = 0L;
        while ((n2 = readableByteChannel.read(this.buffer)) != -1) {
            if (this.buffer.remaining() == 0) {
                this.flushBuffer();
            }
            l2 += (long)n2;
        }
        return l2;
    }

    @Override
    public final void flush() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        this.flushBuffer();
    }

    @Override
    public final void close() throws IOException {
        if (this.closed) {
            return;
        }
        try {
            this.flush();
            this.out.close();
        }
        finally {
            this.closed = true;
            SnappyFramed.releaseDirectByteBuffer(this.directInputBuffer);
            SnappyFramed.releaseDirectByteBuffer(this.outputBuffer);
        }
    }

    private void flushBuffer() throws IOException {
        if (this.buffer.position() > 0) {
            this.buffer.flip();
            this.writeCompressed(this.buffer);
            this.buffer.clear();
        }
    }

    private void writeCompressed(ByteBuffer byteBuffer) throws IOException {
        byte[] byArray = byteBuffer.array();
        int n2 = byteBuffer.remaining();
        int n3 = SnappyFramed.maskedCrc32c(byArray, 0, n2);
        this.directInputBuffer.clear();
        this.directInputBuffer.put(byteBuffer);
        this.directInputBuffer.flip();
        this.outputBuffer.clear();
        Snappy.compress(this.directInputBuffer, this.outputBuffer);
        int n4 = this.outputBuffer.remaining();
        if ((double)n4 / (double)n2 <= this.minCompressionRatio) {
            this.writeBlock(this.out, this.outputBuffer, true, n3);
        } else {
            byteBuffer.flip();
            this.writeBlock(this.out, byteBuffer, false, n3);
        }
    }

    private void writeBlock(WritableByteChannel writableByteChannel, ByteBuffer byteBuffer, boolean bl, int n2) throws IOException {
        this.headerBuffer.clear();
        this.headerBuffer.put((byte)(!bl ? 1 : 0));
        int n3 = byteBuffer.remaining() + 4;
        this.headerBuffer.put((byte)n3);
        this.headerBuffer.put((byte)(n3 >>> 8));
        this.headerBuffer.put((byte)(n3 >>> 16));
        this.headerBuffer.putInt(n2);
        this.headerBuffer.flip();
        writableByteChannel.write(this.headerBuffer);
        writableByteChannel.write(byteBuffer);
    }
}

