/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.snappy;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.xerial.snappy.Snappy;
import org.xerial.snappy.SnappyCodec;
import org.xerial.snappy.SnappyErrorCode;
import org.xerial.snappy.SnappyIOException;
import org.xerial.snappy.SnappyOutputStream;

public class SnappyInputStream
extends InputStream {
    private boolean finishedReading = false;
    protected final InputStream in;
    private byte[] compressed;
    private byte[] uncompressed;
    private int uncompressedCursor = 0;
    private int uncompressedLimit = 0;
    private byte[] header = new byte[SnappyCodec.headerSize()];

    public SnappyInputStream(InputStream inputStream) throws IOException {
        this.in = inputStream;
        this.readHeader();
    }

    @Override
    public void close() throws IOException {
        this.compressed = null;
        this.uncompressed = null;
        if (this.in != null) {
            this.in.close();
        }
    }

    protected void readHeader() throws IOException {
        int n2;
        int n3;
        for (n2 = 0; n2 < this.header.length && (n3 = this.in.read(this.header, n2, this.header.length - n2)) != -1; n2 += n3) {
        }
        if (n2 == 0) {
            throw new SnappyIOException(SnappyErrorCode.EMPTY_INPUT, "Cannot decompress empty stream");
        }
        if (n2 < this.header.length || !SnappyCodec.hasMagicHeaderPrefix(this.header)) {
            this.readFully(this.header, n2);
            return;
        }
    }

    private static boolean isValidHeader(byte[] byArray) throws IOException {
        SnappyCodec snappyCodec = SnappyCodec.readHeader(new ByteArrayInputStream(byArray));
        if (snappyCodec.isValidMagicHeader()) {
            if (snappyCodec.version < 1) {
                throw new SnappyIOException(SnappyErrorCode.INCOMPATIBLE_VERSION, String.format("Compressed with an incompatible codec version %d. At least version %d is required", snappyCodec.version, 1));
            }
            return true;
        }
        return false;
    }

    protected void readFully(byte[] byArray, int n2) throws IOException {
        if (n2 == 0) {
            this.finishedReading = true;
            return;
        }
        this.compressed = new byte[Math.max(8192, n2)];
        System.arraycopy(byArray, 0, this.compressed, 0, n2);
        int n3 = n2;
        int n4 = 0;
        while ((n4 = this.in.read(this.compressed, n3, this.compressed.length - n3)) != -1) {
            if ((n3 += n4) < this.compressed.length) continue;
            byte[] byArray2 = new byte[this.compressed.length * 2];
            System.arraycopy(this.compressed, 0, byArray2, 0, this.compressed.length);
            this.compressed = byArray2;
        }
        this.finishedReading = true;
        n4 = Snappy.uncompressedLength(this.compressed, 0, n3);
        this.uncompressed = new byte[n4];
        Snappy.uncompress(this.compressed, 0, n3, this.uncompressed, 0);
        this.uncompressedCursor = 0;
        this.uncompressedLimit = n4;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = 0;
        while (n4 < n3) {
            if (this.uncompressedCursor >= this.uncompressedLimit) {
                if (this.hasNextChunk()) continue;
                return n4 == 0 ? -1 : n4;
            }
            int n5 = Math.min(this.uncompressedLimit - this.uncompressedCursor, n3 - n4);
            System.arraycopy(this.uncompressed, this.uncompressedCursor, byArray, n2 + n4, n5);
            n4 += n5;
            this.uncompressedCursor += n5;
        }
        return n4;
    }

    public int rawRead(Object object, int n2, int n3) throws IOException {
        int n4 = 0;
        while (n4 < n3) {
            if (this.uncompressedCursor >= this.uncompressedLimit) {
                if (this.hasNextChunk()) continue;
                return n4 == 0 ? -1 : n4;
            }
            int n5 = Math.min(this.uncompressedLimit - this.uncompressedCursor, n3 - n4);
            Snappy.arrayCopy(this.uncompressed, this.uncompressedCursor, n5, object, n2 + n4);
            n4 += n5;
            this.uncompressedCursor += n5;
        }
        return n4;
    }

    public int read(long[] lArray, int n2, int n3) throws IOException {
        return this.rawRead(lArray, n2 * 8, n3 * 8);
    }

    public int read(long[] lArray) throws IOException {
        return this.read(lArray, 0, lArray.length);
    }

    public int read(double[] dArray, int n2, int n3) throws IOException {
        return this.rawRead(dArray, n2 * 8, n3 * 8);
    }

    public int read(double[] dArray) throws IOException {
        return this.read(dArray, 0, dArray.length);
    }

    public int read(int[] nArray) throws IOException {
        return this.read(nArray, 0, nArray.length);
    }

    public int read(int[] nArray, int n2, int n3) throws IOException {
        return this.rawRead(nArray, n2 * 4, n3 * 4);
    }

    public int read(float[] fArray, int n2, int n3) throws IOException {
        return this.rawRead(fArray, n2 * 4, n3 * 4);
    }

    public int read(float[] fArray) throws IOException {
        return this.read(fArray, 0, fArray.length);
    }

    public int read(short[] sArray, int n2, int n3) throws IOException {
        return this.rawRead(sArray, n2 * 2, n3 * 2);
    }

    public int read(short[] sArray) throws IOException {
        return this.read(sArray, 0, sArray.length);
    }

    private int readNext(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        int n5;
        for (n4 = 0; n4 < n3; n4 += n5) {
            n5 = this.in.read(byArray, n4 + n2, n3 - n4);
            if (n5 != -1) continue;
            this.finishedReading = true;
            return n4;
        }
        return n4;
    }

    protected boolean hasNextChunk() throws IOException {
        int n2;
        int n3;
        if (this.finishedReading) {
            return false;
        }
        this.uncompressedCursor = 0;
        this.uncompressedLimit = 0;
        int n4 = this.readNext(this.header, 0, 4);
        if (n4 < 4) {
            return false;
        }
        int n5 = SnappyOutputStream.readInt(this.header, 0);
        if (n5 == SnappyCodec.MAGIC_HEADER_HEAD) {
            int n6 = SnappyCodec.headerSize() - 4;
            n4 = this.readNext(this.header, 4, n6);
            if (n4 < n6) {
                throw new SnappyIOException(SnappyErrorCode.FAILED_TO_UNCOMPRESS, String.format("Insufficient header size in a concatenated block", new Object[0]));
            }
            if (SnappyInputStream.isValidHeader(this.header)) {
                return this.hasNextChunk();
            }
            return false;
        }
        if (this.compressed == null || n5 > this.compressed.length) {
            this.compressed = new byte[n5];
        }
        for (n4 = 0; n4 < n5 && (n3 = this.in.read(this.compressed, n4, n5 - n4)) != -1; n4 += n3) {
        }
        if (n4 < n5) {
            throw new IOException("failed to read chunk");
        }
        n3 = Snappy.uncompressedLength(this.compressed, 0, n5);
        if (this.uncompressed == null || n3 > this.uncompressed.length) {
            this.uncompressed = new byte[n3];
        }
        if (n3 != (n2 = Snappy.uncompress(this.compressed, 0, n5, this.uncompressed, 0))) {
            throw new SnappyIOException(SnappyErrorCode.INVALID_CHUNK_SIZE, String.format("expected %,d bytes, but decompressed chunk has %,d bytes", n3, n2));
        }
        this.uncompressedLimit = n2;
        return true;
    }

    @Override
    public int read() throws IOException {
        if (this.uncompressedCursor < this.uncompressedLimit) {
            return this.uncompressed[this.uncompressedCursor++] & 0xFF;
        }
        if (this.hasNextChunk()) {
            return this.read();
        }
        return -1;
    }

    @Override
    public int available() throws IOException {
        if (this.uncompressedCursor < this.uncompressedLimit) {
            return this.uncompressedLimit - this.uncompressedCursor;
        }
        if (this.hasNextChunk()) {
            return this.uncompressedLimit - this.uncompressedCursor;
        }
        return 0;
    }
}

