/*
 * Decompiled with CFR 0.152.
 */
package oshi.driver.linux.proc;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.util.FileUtil;
import oshi.util.ParseUtil;
import oshi.util.platform.linux.ProcPath;

@ThreadSafe
public final class DiskStats {
    private DiskStats() {
    }

    public static Map<String, Map<IoStat, Long>> getDiskStats() {
        HashMap<String, Map<IoStat, Long>> diskStatMap = new HashMap<String, Map<IoStat, Long>>();
        IoStat[] enumArray = (IoStat[])IoStat.class.getEnumConstants();
        List<String> diskStats = FileUtil.readFile(ProcPath.DISKSTATS);
        for (String stat : diskStats) {
            String[] split2 = ParseUtil.whitespaces.split(stat.trim());
            EnumMap<IoStat, Long> statMap = new EnumMap<IoStat, Long>(IoStat.class);
            String name = null;
            for (int i2 = 0; i2 < enumArray.length && i2 < split2.length; ++i2) {
                if (enumArray[i2] == IoStat.NAME) {
                    name = split2[i2];
                    continue;
                }
                statMap.put(enumArray[i2], ParseUtil.parseLongOrDefault(split2[i2], 0L));
            }
            if (name == null) continue;
            diskStatMap.put(name, statMap);
        }
        return diskStatMap;
    }

    public static enum IoStat {
        MAJOR,
        MINOR,
        NAME,
        READS,
        READS_MERGED,
        READS_SECTOR,
        READS_MS,
        WRITES,
        WRITES_MERGED,
        WRITES_SECTOR,
        WRITES_MS,
        IO_QUEUE_LENGTH,
        IO_MS,
        IO_MS_WEIGHTED,
        DISCARDS,
        DISCARDS_MERGED,
        DISCARDS_SECTOR,
        DISCARDS_MS,
        FLUSHES,
        FLUSHES_MS;

    }
}

