/*
 * Decompiled with CFR 0.152.
 */
package oshi.driver.windows;

import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.WinNT;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.hardware.CentralProcessor;

@ThreadSafe
public final class LogicalProcessorInformation {
    private LogicalProcessorInformation() {
    }

    public static List<CentralProcessor.LogicalProcessor> getLogicalProcessorInformationEx() {
        WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION_EX[] procInfo = Kernel32Util.getLogicalProcessorInformationEx(65535);
        ArrayList<WinNT.GROUP_AFFINITY[]> packages = new ArrayList<WinNT.GROUP_AFFINITY[]>();
        ArrayList<WinNT.GROUP_AFFINITY> cores = new ArrayList<WinNT.GROUP_AFFINITY>();
        ArrayList<WinNT.NUMA_NODE_RELATIONSHIP> numaNodes = new ArrayList<WinNT.NUMA_NODE_RELATIONSHIP>();
        block5: for (int i2 = 0; i2 < procInfo.length; ++i2) {
            switch (procInfo[i2].relationship) {
                case 3: {
                    packages.add(((WinNT.PROCESSOR_RELATIONSHIP)procInfo[i2]).groupMask);
                    continue block5;
                }
                case 0: {
                    cores.add(((WinNT.PROCESSOR_RELATIONSHIP)procInfo[i2]).groupMask[0]);
                    continue block5;
                }
                case 1: {
                    numaNodes.add((WinNT.NUMA_NODE_RELATIONSHIP)procInfo[i2]);
                    continue block5;
                }
            }
        }
        cores.sort(Comparator.comparing(c2 -> (long)c2.group * 64L + c2.mask.longValue()));
        packages.sort(Comparator.comparing(p2 -> (long)p2[0].group * 64L + p2[0].mask.longValue()));
        numaNodes.sort(Comparator.comparing(n2 -> n2.nodeNumber));
        ArrayList<CentralProcessor.LogicalProcessor> logProcs = new ArrayList<CentralProcessor.LogicalProcessor>();
        for (WinNT.NUMA_NODE_RELATIONSHIP node : numaNodes) {
            int nodeNum = node.nodeNumber;
            short group2 = node.groupMask.group;
            long mask = node.groupMask.mask.longValue();
            int lowBit = Long.numberOfTrailingZeros(mask);
            int hiBit = 63 - Long.numberOfLeadingZeros(mask);
            for (int lp = lowBit; lp <= hiBit; ++lp) {
                if ((mask & 1L << lp) == 0L) continue;
                CentralProcessor.LogicalProcessor logProc = new CentralProcessor.LogicalProcessor(lp, LogicalProcessorInformation.getMatchingCore(cores, group2, lp), LogicalProcessorInformation.getMatchingPackage(packages, group2, lp), nodeNum, group2);
                logProcs.add(logProc);
            }
        }
        return logProcs;
    }

    private static int getMatchingPackage(List<WinNT.GROUP_AFFINITY[]> packages, int g2, int lp) {
        for (int i2 = 0; i2 < packages.size(); ++i2) {
            for (int j2 = 0; j2 < packages.get(i2).length; ++j2) {
                if ((packages.get((int)i2)[j2].mask.longValue() & 1L << lp) == 0L || packages.get((int)i2)[j2].group != g2) continue;
                return i2;
            }
        }
        return 0;
    }

    private static int getMatchingCore(List<WinNT.GROUP_AFFINITY> cores, int g2, int lp) {
        for (int j2 = 0; j2 < cores.size(); ++j2) {
            if ((cores.get((int)j2).mask.longValue() & 1L << lp) == 0L || cores.get((int)j2).group != g2) continue;
            return j2;
        }
        return 0;
    }

    public static List<CentralProcessor.LogicalProcessor> getLogicalProcessorInformation() {
        WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION[] processors;
        ArrayList<Long> packageMaskList = new ArrayList<Long>();
        ArrayList<Long> coreMaskList = new ArrayList<Long>();
        for (WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION proc : processors = Kernel32Util.getLogicalProcessorInformation()) {
            if (proc.relationship == 3) {
                packageMaskList.add(proc.processorMask.longValue());
                continue;
            }
            if (proc.relationship != 0) continue;
            coreMaskList.add(proc.processorMask.longValue());
        }
        coreMaskList.sort(null);
        packageMaskList.sort(null);
        ArrayList<CentralProcessor.LogicalProcessor> logProcs = new ArrayList<CentralProcessor.LogicalProcessor>();
        for (int core = 0; core < coreMaskList.size(); ++core) {
            long coreMask = (Long)coreMaskList.get(core);
            int lowBit = Long.numberOfTrailingZeros(coreMask);
            int hiBit = 63 - Long.numberOfLeadingZeros(coreMask);
            for (int i2 = lowBit; i2 <= hiBit; ++i2) {
                if ((coreMask & 1L << i2) == 0L) continue;
                CentralProcessor.LogicalProcessor logProc = new CentralProcessor.LogicalProcessor(i2, core, LogicalProcessorInformation.getBitMatchingPackageNumber(packageMaskList, i2));
                logProcs.add(logProc);
            }
        }
        return logProcs;
    }

    private static int getBitMatchingPackageNumber(List<Long> packageMaskList, int logProc) {
        for (int i2 = 0; i2 < packageMaskList.size(); ++i2) {
            if ((packageMaskList.get(i2) & 1L << logProc) == 0L) continue;
            return i2;
        }
        return 0;
    }
}

