/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.aix;

import com.sun.jna.Native;
import com.sun.jna.platform.unix.aix.Perfstat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.driver.unix.aix.Lssrad;
import oshi.driver.unix.aix.perfstat.PerfstatConfig;
import oshi.driver.unix.aix.perfstat.PerfstatCpu;
import oshi.hardware.CentralProcessor;
import oshi.hardware.common.AbstractCentralProcessor;
import oshi.util.ExecutingCommand;
import oshi.util.FileUtil;
import oshi.util.Memoizer;
import oshi.util.ParseUtil;
import oshi.util.tuples.Pair;

@ThreadSafe
final class AixCentralProcessor
extends AbstractCentralProcessor {
    private final Supplier<Perfstat.perfstat_cpu_total_t> cpuTotal = Memoizer.memoize(PerfstatCpu::queryCpuTotal, Memoizer.defaultExpiration());
    private final Supplier<Perfstat.perfstat_cpu_t[]> cpuProc = Memoizer.memoize(PerfstatCpu::queryCpu, Memoizer.defaultExpiration());
    private static final int SBITS = AixCentralProcessor.querySbits();
    private Perfstat.perfstat_partition_config_t config;
    private static final long USER_HZ = ParseUtil.parseLongOrDefault(ExecutingCommand.getFirstAnswer("getconf CLK_TCK"), 100L);

    AixCentralProcessor() {
    }

    @Override
    protected CentralProcessor.ProcessorIdentifier queryProcessorId() {
        String cpuVendor = "unknown";
        String cpuName = "";
        String cpuFamily = "";
        boolean cpu64bit = false;
        String nameMarker = "Processor Type:";
        String familyMarker = "Processor Version:";
        String bitnessMarker = "CPU Type:";
        for (String checkLine : ExecutingCommand.runNative("prtconf")) {
            if (checkLine.startsWith("Processor Type:")) {
                cpuName = checkLine.split("Processor Type:")[1].trim();
                if (cpuName.startsWith("P")) {
                    cpuVendor = "IBM";
                    continue;
                }
                if (!cpuName.startsWith("I")) continue;
                cpuVendor = "Intel";
                continue;
            }
            if (checkLine.startsWith("Processor Version:")) {
                cpuFamily = checkLine.split("Processor Version:")[1].trim();
                continue;
            }
            if (!checkLine.startsWith("CPU Type:")) continue;
            cpu64bit = checkLine.split("CPU Type:")[1].contains("64");
        }
        String cpuModel = "";
        String cpuStepping = "";
        String machineId = Native.toString(this.config.machineID);
        if (machineId.isEmpty()) {
            machineId = ExecutingCommand.getFirstAnswer("uname -m");
        }
        if (machineId.length() > 10) {
            int m4 = machineId.length() - 4;
            int s2 = machineId.length() - 2;
            cpuModel = machineId.substring(m4, s2);
            cpuStepping = machineId.substring(s2);
        }
        return new CentralProcessor.ProcessorIdentifier(cpuVendor, cpuName, cpuFamily, cpuModel, cpuStepping, machineId, cpu64bit, (long)(this.config.processorMHz * 1000000.0));
    }

    @Override
    protected List<CentralProcessor.LogicalProcessor> initProcessorCounts() {
        int lcpus;
        this.config = PerfstatConfig.queryConfig();
        int physProcs = (int)this.config.numProcessors.max;
        if (physProcs < 1) {
            physProcs = 1;
        }
        if ((lcpus = this.config.lcpus) < 1) {
            lcpus = 1;
        }
        Map<Integer, Pair<Integer, Integer>> nodePkgMap = Lssrad.queryNodesPackages();
        ArrayList<CentralProcessor.LogicalProcessor> logProcs = new ArrayList<CentralProcessor.LogicalProcessor>();
        for (int proc = 0; proc < lcpus; ++proc) {
            Pair<Integer, Integer> nodePkg = nodePkgMap.get(proc);
            logProcs.add(new CentralProcessor.LogicalProcessor(proc, proc / physProcs, nodePkg == null ? 0 : nodePkg.getB(), nodePkg == null ? 0 : nodePkg.getA()));
        }
        return logProcs;
    }

    @Override
    public long[] querySystemCpuLoadTicks() {
        Perfstat.perfstat_cpu_total_t perfstat = this.cpuTotal.get();
        long[] ticks = new long[CentralProcessor.TickType.values().length];
        ticks[CentralProcessor.TickType.USER.ordinal()] = perfstat.user * 1000L / USER_HZ;
        ticks[CentralProcessor.TickType.SYSTEM.ordinal()] = perfstat.sys * 1000L / USER_HZ;
        ticks[CentralProcessor.TickType.IDLE.ordinal()] = perfstat.idle * 1000L / USER_HZ;
        ticks[CentralProcessor.TickType.IOWAIT.ordinal()] = perfstat.wait * 1000L / USER_HZ;
        ticks[CentralProcessor.TickType.IRQ.ordinal()] = perfstat.devintrs * 1000L / USER_HZ;
        ticks[CentralProcessor.TickType.SOFTIRQ.ordinal()] = perfstat.softintrs * 1000L / USER_HZ;
        ticks[CentralProcessor.TickType.STEAL.ordinal()] = (perfstat.idle_stolen_purr + perfstat.busy_stolen_purr) * 1000L / USER_HZ;
        return ticks;
    }

    @Override
    public long[] queryCurrentFreq() {
        long[] freqs = new long[this.getLogicalProcessorCount()];
        Arrays.fill(freqs, -1L);
        String freqMarker = "runs at";
        int idx = 0;
        for (String checkLine : ExecutingCommand.runNative("pmcycles -m")) {
            if (!checkLine.contains(freqMarker)) continue;
            freqs[idx++] = ParseUtil.parseHertz(checkLine.split(freqMarker)[1].trim());
            if (idx < freqs.length) continue;
            break;
        }
        return freqs;
    }

    @Override
    protected long queryMaxFreq() {
        Perfstat.perfstat_cpu_total_t perfstat = this.cpuTotal.get();
        return perfstat.processorHZ;
    }

    @Override
    public double[] getSystemLoadAverage(int nelem) {
        if (nelem < 1 || nelem > 3) {
            throw new IllegalArgumentException("Must include from one to three elements.");
        }
        double[] average = new double[nelem];
        long[] loadavg = this.cpuTotal.get().loadavg;
        for (int i2 = 0; i2 < nelem; ++i2) {
            average[i2] = (double)loadavg[i2] / (double)(1L << SBITS);
        }
        return average;
    }

    @Override
    public long[][] queryProcessorCpuLoadTicks() {
        Perfstat.perfstat_cpu_t[] cpu = this.cpuProc.get();
        long[][] ticks = new long[cpu.length][CentralProcessor.TickType.values().length];
        for (int i2 = 0; i2 < cpu.length; ++i2) {
            ticks[i2] = new long[CentralProcessor.TickType.values().length];
            ticks[i2][CentralProcessor.TickType.USER.ordinal()] = cpu[i2].user * 1000L / USER_HZ;
            ticks[i2][CentralProcessor.TickType.SYSTEM.ordinal()] = cpu[i2].sys * 1000L / USER_HZ;
            ticks[i2][CentralProcessor.TickType.IDLE.ordinal()] = cpu[i2].idle * 1000L / USER_HZ;
            ticks[i2][CentralProcessor.TickType.IOWAIT.ordinal()] = cpu[i2].wait * 1000L / USER_HZ;
            ticks[i2][CentralProcessor.TickType.IRQ.ordinal()] = cpu[i2].devintrs * 1000L / USER_HZ;
            ticks[i2][CentralProcessor.TickType.SOFTIRQ.ordinal()] = cpu[i2].softintrs * 1000L / USER_HZ;
            ticks[i2][CentralProcessor.TickType.STEAL.ordinal()] = (cpu[i2].idle_stolen_purr + cpu[i2].busy_stolen_purr) * 1000L / USER_HZ;
        }
        return ticks;
    }

    @Override
    public long queryContextSwitches() {
        return this.cpuTotal.get().pswitch;
    }

    @Override
    public long queryInterrupts() {
        Perfstat.perfstat_cpu_total_t cpu = this.cpuTotal.get();
        return cpu.devintrs + cpu.softintrs;
    }

    private static int querySbits() {
        for (String s2 : FileUtil.readFile("/usr/include/sys/proc.h")) {
            if (!s2.contains("SBITS") || !s2.contains("#define")) continue;
            return ParseUtil.parseLastInt(s2, 16);
        }
        return 16;
    }
}

