/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import com.sun.jna.platform.win32.COM.COMException;
import com.sun.jna.platform.win32.COM.WbemcliUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.driver.windows.wmi.MSAcpiThermalZoneTemperature;
import oshi.driver.windows.wmi.OhmHardware;
import oshi.driver.windows.wmi.OhmSensor;
import oshi.driver.windows.wmi.Win32Fan;
import oshi.driver.windows.wmi.Win32Processor;
import oshi.hardware.common.AbstractSensors;
import oshi.util.platform.windows.WmiQueryHandler;
import oshi.util.platform.windows.WmiUtil;

@ThreadSafe
final class WindowsSensors
extends AbstractSensors {
    private static final Logger LOG = LoggerFactory.getLogger(WindowsSensors.class);
    private static final String COM_EXCEPTION_MSG = "COM exception: {}";

    WindowsSensors() {
    }

    @Override
    public double queryCpuTemperature() {
        double tempC = WindowsSensors.getTempFromOHM();
        if (tempC > 0.0) {
            return tempC;
        }
        tempC = WindowsSensors.getTempFromWMI();
        return tempC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static double getTempFromOHM() {
        WmiQueryHandler h2 = WmiQueryHandler.createInstance();
        boolean comInit = false;
        try {
            comInit = h2.initCOM();
            WbemcliUtil.WmiResult<OhmHardware.IdentifierProperty> ohmHardware = OhmHardware.queryHwIdentifier(h2, "Hardware", "CPU");
            if (ohmHardware.getResultCount() > 0) {
                WbemcliUtil.WmiResult<OhmSensor.ValueProperty> ohmSensors;
                LOG.debug("Found Temperature data in Open Hardware Monitor");
                String cpuIdentifier = WmiUtil.getString(ohmHardware, OhmHardware.IdentifierProperty.IDENTIFIER, 0);
                if (cpuIdentifier.length() > 0 && (ohmSensors = OhmSensor.querySensorValue(h2, cpuIdentifier, "Temperature")).getResultCount() > 0) {
                    double sum = 0.0;
                    for (int i2 = 0; i2 < ohmSensors.getResultCount(); ++i2) {
                        sum += (double)WmiUtil.getFloat(ohmSensors, OhmSensor.ValueProperty.VALUE, i2);
                    }
                    double d2 = sum / (double)ohmSensors.getResultCount();
                    return d2;
                }
            }
        }
        catch (COMException e2) {
            LOG.warn(COM_EXCEPTION_MSG, (Object)e2.getMessage());
        }
        finally {
            if (comInit) {
                h2.unInitCOM();
            }
        }
        return 0.0;
    }

    private static double getTempFromWMI() {
        double tempC = 0.0;
        long tempK = 0L;
        WbemcliUtil.WmiResult<MSAcpiThermalZoneTemperature.TemperatureProperty> result = MSAcpiThermalZoneTemperature.queryCurrentTemperature();
        if (result.getResultCount() > 0) {
            LOG.debug("Found Temperature data in WMI");
            tempK = WmiUtil.getUint32asLong(result, MSAcpiThermalZoneTemperature.TemperatureProperty.CURRENTTEMPERATURE, 0);
        }
        if (tempK > 2732L) {
            tempC = (double)tempK / 10.0 - 273.15;
        } else if (tempK > 274L) {
            tempC = (double)tempK - 273.0;
        }
        return tempC < 0.0 ? 0.0 : tempC;
    }

    @Override
    public int[] queryFanSpeeds() {
        int[] fanSpeeds = WindowsSensors.getFansFromOHM();
        if (fanSpeeds.length > 0) {
            return fanSpeeds;
        }
        fanSpeeds = WindowsSensors.getFansFromWMI();
        if (fanSpeeds.length > 0) {
            return fanSpeeds;
        }
        return new int[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int[] getFansFromOHM() {
        WmiQueryHandler h2 = WmiQueryHandler.createInstance();
        boolean comInit = false;
        try {
            comInit = h2.initCOM();
            WbemcliUtil.WmiResult<OhmHardware.IdentifierProperty> ohmHardware = OhmHardware.queryHwIdentifier(h2, "Hardware", "CPU");
            if (ohmHardware.getResultCount() > 0) {
                WbemcliUtil.WmiResult<OhmSensor.ValueProperty> ohmSensors;
                LOG.debug("Found Fan data in Open Hardware Monitor");
                String cpuIdentifier = WmiUtil.getString(ohmHardware, OhmHardware.IdentifierProperty.IDENTIFIER, 0);
                if (cpuIdentifier.length() > 0 && (ohmSensors = OhmSensor.querySensorValue(h2, cpuIdentifier, "Fan")).getResultCount() > 0) {
                    int[] fanSpeeds = new int[ohmSensors.getResultCount()];
                    for (int i2 = 0; i2 < ohmSensors.getResultCount(); ++i2) {
                        fanSpeeds[i2] = (int)WmiUtil.getFloat(ohmSensors, OhmSensor.ValueProperty.VALUE, i2);
                    }
                    int[] nArray = fanSpeeds;
                    return nArray;
                }
            }
        }
        catch (COMException e2) {
            LOG.warn(COM_EXCEPTION_MSG, (Object)e2.getMessage());
        }
        finally {
            if (comInit) {
                h2.unInitCOM();
            }
        }
        return new int[0];
    }

    private static int[] getFansFromWMI() {
        WbemcliUtil.WmiResult<Win32Fan.SpeedProperty> fan = Win32Fan.querySpeed();
        if (fan.getResultCount() > 1) {
            LOG.debug("Found Fan data in WMI");
            int[] fanSpeeds = new int[fan.getResultCount()];
            for (int i2 = 0; i2 < fan.getResultCount(); ++i2) {
                fanSpeeds[i2] = (int)WmiUtil.getUint64(fan, Win32Fan.SpeedProperty.DESIREDSPEED, i2);
            }
            return fanSpeeds;
        }
        return new int[0];
    }

    @Override
    public double queryCpuVoltage() {
        double volts = WindowsSensors.getVoltsFromOHM();
        if (volts > 0.0) {
            return volts;
        }
        volts = WindowsSensors.getVoltsFromWMI();
        return volts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static double getVoltsFromOHM() {
        WmiQueryHandler h2 = WmiQueryHandler.createInstance();
        boolean comInit = false;
        try {
            comInit = h2.initCOM();
            WbemcliUtil.WmiResult<OhmHardware.IdentifierProperty> ohmHardware = OhmHardware.queryHwIdentifier(h2, "Sensor", "Voltage");
            if (ohmHardware.getResultCount() > 0) {
                WbemcliUtil.WmiResult<OhmSensor.ValueProperty> ohmSensors;
                LOG.debug("Found Voltage data in Open Hardware Monitor");
                String cpuIdentifier = null;
                for (int i2 = 0; i2 < ohmHardware.getResultCount(); ++i2) {
                    String id = WmiUtil.getString(ohmHardware, OhmHardware.IdentifierProperty.IDENTIFIER, i2);
                    if (!id.toLowerCase().contains("cpu")) continue;
                    cpuIdentifier = id;
                    break;
                }
                if (cpuIdentifier == null) {
                    cpuIdentifier = WmiUtil.getString(ohmHardware, OhmHardware.IdentifierProperty.IDENTIFIER, 0);
                }
                if ((ohmSensors = OhmSensor.querySensorValue(h2, cpuIdentifier, "Voltage")).getResultCount() > 0) {
                    double d2 = WmiUtil.getFloat(ohmSensors, OhmSensor.ValueProperty.VALUE, 0);
                    return d2;
                }
            }
        }
        catch (COMException e2) {
            LOG.warn(COM_EXCEPTION_MSG, (Object)e2.getMessage());
        }
        finally {
            if (comInit) {
                h2.unInitCOM();
            }
        }
        return 0.0;
    }

    private static double getVoltsFromWMI() {
        WbemcliUtil.WmiResult<Win32Processor.VoltProperty> voltage = Win32Processor.queryVoltage();
        if (voltage.getResultCount() > 1) {
            LOG.debug("Found Voltage data in WMI");
            int decivolts = WmiUtil.getUint16(voltage, Win32Processor.VoltProperty.CURRENTVOLTAGE, 0);
            if (decivolts > 0) {
                if ((decivolts & 0x80) == 0) {
                    decivolts = WmiUtil.getUint32(voltage, Win32Processor.VoltProperty.VOLTAGECAPS, 0);
                    if ((decivolts & 1) > 0) {
                        return 5.0;
                    }
                    if ((decivolts & 2) > 0) {
                        return 3.3;
                    }
                    if ((decivolts & 4) > 0) {
                        return 2.9;
                    }
                } else {
                    return (double)(decivolts & 0x7F) / 10.0;
                }
            }
        }
        return 0.0;
    }
}

