/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.unix.aix;

import java.util.List;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.software.common.AbstractOSThread;
import oshi.software.os.OSProcess;
import oshi.software.os.unix.aix.AixOSProcess;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;

@ThreadSafe
public class AixOSThread
extends AbstractOSThread {
    private int threadId;
    private OSProcess.State state = OSProcess.State.INVALID;
    private long contextSwitches;
    private long kernelTime;
    private long userTime;
    private long startTime;
    private long upTime;
    private int priority;

    public AixOSThread(int pid, String[] split2) {
        super(pid);
        this.updateAttributes(split2);
    }

    @Override
    public int getThreadId() {
        return this.threadId;
    }

    @Override
    public OSProcess.State getState() {
        return this.state;
    }

    @Override
    public long getContextSwitches() {
        return this.contextSwitches;
    }

    @Override
    public long getKernelTime() {
        return this.kernelTime;
    }

    @Override
    public long getUserTime() {
        return this.userTime;
    }

    @Override
    public long getUpTime() {
        return this.upTime;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public boolean updateAttributes() {
        List<String> threadListInfoPs = ExecutingCommand.runNative("ps -m -o THREAD -p " + this.getOwningProcessId());
        if (threadListInfoPs.size() > 2) {
            threadListInfoPs.remove(0);
            threadListInfoPs.remove(0);
            for (String threadInfo : threadListInfoPs) {
                String[] threadInfoSplit = ParseUtil.whitespaces.split(threadInfo.trim());
                if (threadInfoSplit.length != 13 || !threadInfoSplit[3].equals(String.valueOf(this.getThreadId()))) continue;
                String[] split2 = new String[]{threadInfoSplit[3], threadInfoSplit[4], threadInfoSplit[6]};
                this.updateAttributes(split2);
            }
        }
        this.state = OSProcess.State.INVALID;
        return false;
    }

    private boolean updateAttributes(String[] split2) {
        this.threadId = ParseUtil.parseIntOrDefault(split2[0], 0);
        this.state = AixOSProcess.getStateFromOutput(split2[1].charAt(0));
        this.priority = ParseUtil.parseIntOrDefault(split2[2], 0);
        return true;
    }
}

