/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.unix.solaris;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.software.common.AbstractOSThread;
import oshi.software.os.OSProcess;
import oshi.software.os.unix.solaris.SolarisOSProcess;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;

@ThreadSafe
public class SolarisOSThread
extends AbstractOSThread {
    private int threadId;
    private OSProcess.State state = OSProcess.State.INVALID;
    private long startMemoryAddress;
    private long contextSwitches;
    private long kernelTime;
    private long userTime;
    private long startTime;
    private long upTime;
    private int priority;

    public SolarisOSThread(int pid, String[] split2) {
        super(pid);
        this.updateAttributes(split2);
    }

    @Override
    public int getThreadId() {
        return this.threadId;
    }

    @Override
    public OSProcess.State getState() {
        return this.state;
    }

    @Override
    public long getStartMemoryAddress() {
        return this.startMemoryAddress;
    }

    @Override
    public long getContextSwitches() {
        return this.contextSwitches;
    }

    @Override
    public long getKernelTime() {
        return this.kernelTime;
    }

    @Override
    public long getUserTime() {
        return this.userTime;
    }

    @Override
    public long getUpTime() {
        return this.upTime;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public boolean updateAttributes() {
        Optional<String[]> split2;
        List<String> threadListInfo2;
        List<String> threadListInfo1 = ExecutingCommand.runNative("ps -o lwp,s,etime,stime,time,addr,pri -p " + this.getOwningProcessId());
        Map<Integer, String[]> threadMap = SolarisOSProcess.parseAndMergePSandPrstatInfo(threadListInfo1, 0, 7, threadListInfo2 = ExecutingCommand.runNative("prstat -L -v -p " + this.getOwningProcessId() + " 1 1"), true);
        if (threadMap.keySet().size() > 1 && (split2 = threadMap.entrySet().stream().filter(entry -> ((Integer)entry.getKey()).intValue() == this.getThreadId()).map(Map.Entry::getValue).findFirst()).isPresent()) {
            return this.updateAttributes(split2.get());
        }
        this.state = OSProcess.State.INVALID;
        return false;
    }

    private boolean updateAttributes(String[] split2) {
        this.threadId = ParseUtil.parseIntOrDefault(split2[0], 0);
        this.state = SolarisOSProcess.getStateFromOutput(split2[1].charAt(0));
        long elapsedTime = ParseUtil.parseDHMSOrDefault(split2[2], 0L);
        this.upTime = elapsedTime < 1L ? 1L : elapsedTime;
        long now = System.currentTimeMillis();
        this.startTime = now - this.upTime;
        this.kernelTime = ParseUtil.parseDHMSOrDefault(split2[3], 0L);
        this.userTime = ParseUtil.parseDHMSOrDefault(split2[4], 0L) - this.kernelTime;
        this.startMemoryAddress = ParseUtil.hexStringToLong(split2[5], 0L);
        this.priority = ParseUtil.parseIntOrDefault(split2[6], 0);
        long nonVoluntaryContextSwitches = ParseUtil.parseLongOrDefault(split2[7], 0L);
        long voluntaryContextSwitches = ParseUtil.parseLongOrDefault(split2[8], 0L);
        this.contextSwitches = voluntaryContextSwitches + nonVoluntaryContextSwitches;
        return true;
    }
}

