/*
 * Decompiled with CFR 0.152.
 */
package oshi.util.platform.unix.openbsd;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.platform.unix.LibCAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.jna.platform.unix.NativeSizeTByReference;
import oshi.jna.platform.unix.openbsd.OpenBsdLibc;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;

@ThreadSafe
public final class OpenBsdSysctlUtil {
    private static final String SYSCTL_N = "sysctl -n ";
    private static final Logger LOG = LoggerFactory.getLogger(OpenBsdSysctlUtil.class);
    private static final String SYSCTL_FAIL = "Failed sysctl call: {}, Error code: {}";

    private OpenBsdSysctlUtil() {
    }

    public static int sysctl(int[] name, int def) {
        NativeSizeTByReference size = new NativeSizeTByReference(new LibCAPI.size_t((long)OpenBsdLibc.INT_SIZE));
        Memory p2 = new Memory(size.getValue().longValue());
        if (0 != OpenBsdLibc.INSTANCE.sysctl(name, name.length, p2, size, null, LibCAPI.size_t.ZERO)) {
            LOG.error(SYSCTL_FAIL, (Object)name, (Object)Native.getLastError());
            return def;
        }
        return ((Pointer)p2).getInt(0L);
    }

    public static long sysctl(int[] name, long def) {
        NativeSizeTByReference size = new NativeSizeTByReference(new LibCAPI.size_t((long)OpenBsdLibc.UINT64_SIZE));
        Memory p2 = new Memory(size.getValue().longValue());
        if (0 != OpenBsdLibc.INSTANCE.sysctl(name, name.length, p2, size, null, LibCAPI.size_t.ZERO)) {
            LOG.warn(SYSCTL_FAIL, (Object)name, (Object)Native.getLastError());
            return def;
        }
        return ((Pointer)p2).getLong(0L);
    }

    public static String sysctl(int[] name, String def) {
        NativeSizeTByReference size = new NativeSizeTByReference();
        if (0 != OpenBsdLibc.INSTANCE.sysctl(name, name.length, null, size, null, LibCAPI.size_t.ZERO)) {
            LOG.warn(SYSCTL_FAIL, (Object)name, (Object)Native.getLastError());
            return def;
        }
        Memory p2 = new Memory(size.getValue().longValue() + 1L);
        if (0 != OpenBsdLibc.INSTANCE.sysctl(name, name.length, p2, size, null, LibCAPI.size_t.ZERO)) {
            LOG.warn(SYSCTL_FAIL, (Object)name, (Object)Native.getLastError());
            return def;
        }
        return p2.getString(0L);
    }

    public static boolean sysctl(int[] name, Structure struct2) {
        if (0 != OpenBsdLibc.INSTANCE.sysctl(name, name.length, struct2.getPointer(), new NativeSizeTByReference(new LibCAPI.size_t((long)struct2.size())), null, LibCAPI.size_t.ZERO)) {
            LOG.error(SYSCTL_FAIL, (Object)name, (Object)Native.getLastError());
            return false;
        }
        struct2.read();
        return true;
    }

    public static Memory sysctl(int[] name) {
        NativeSizeTByReference size = new NativeSizeTByReference();
        if (0 != OpenBsdLibc.INSTANCE.sysctl(name, name.length, null, size, null, LibCAPI.size_t.ZERO)) {
            LOG.error(SYSCTL_FAIL, (Object)name, (Object)Native.getLastError());
            return null;
        }
        Memory m4 = new Memory(size.getValue().longValue());
        if (0 != OpenBsdLibc.INSTANCE.sysctl(name, name.length, m4, size, null, LibCAPI.size_t.ZERO)) {
            LOG.error(SYSCTL_FAIL, (Object)name, (Object)Native.getLastError());
            return null;
        }
        return m4;
    }

    public static int sysctl(String name, int def) {
        return ParseUtil.parseIntOrDefault(ExecutingCommand.getFirstAnswer(SYSCTL_N + name), def);
    }

    public static long sysctl(String name, long def) {
        return ParseUtil.parseLongOrDefault(ExecutingCommand.getFirstAnswer(SYSCTL_N + name), def);
    }

    public static String sysctl(String name, String def) {
        String v2 = ExecutingCommand.getFirstAnswer(SYSCTL_N + name);
        if (null == v2 || v2.isEmpty()) {
            return def;
        }
        return v2;
    }
}

