/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.jlargearrays;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.math3.util.FastMath;
import pl.edu.icm.jlargearrays.ConcurrencyUtils;
import pl.edu.icm.jlargearrays.LargeArray;
import pl.edu.icm.jlargearrays.LargeArrayType;

public class LargeArrayStatistics {
    private LargeArrayStatistics() {
    }

    public static double min(final LargeArray a2) {
        if (a2 == null || !a2.isNumeric() || a2.getType() == LargeArrayType.COMPLEX_FLOAT || a2.getType() == LargeArrayType.COMPLEX_DOUBLE) {
            throw new IllegalArgumentException("a == null || !a.isNumeric() || a.getType() == LargeArrayType.COMPLEX_FLOAT || a.getType() == LargeArrayType.COMPLEX_DOUBLE");
        }
        if (a2.isConstant()) {
            return a2.getDouble(0L);
        }
        double min2 = a2.getDouble(0L);
        long length = a2.length();
        int nthreads = (int)FastMath.min((long)length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long i2 = 1L; i2 < length; ++i2) {
                double elem = a2.getDouble(i2);
                if (!(elem < min2)) continue;
                min2 = elem;
            }
        } else {
            int j2;
            long k2 = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (j2 = 0; j2 < nthreads; ++j2) {
                final long firstIdx = (long)j2 * k2;
                final long lastIdx = j2 == nthreads - 1 ? length : firstIdx + k2;
                threads[j2] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() {
                        double min2 = a2.getDouble(firstIdx);
                        for (long k2 = firstIdx + 1L; k2 < lastIdx; ++k2) {
                            double elem = a2.getDouble(k2);
                            if (!(elem < min2)) continue;
                            min2 = elem;
                        }
                        return min2;
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
                for (j2 = 0; j2 < nthreads; ++j2) {
                    double res = (Double)threads[j2].get();
                    if (!(res < min2)) continue;
                    min2 = res;
                }
            }
            catch (InterruptedException | ExecutionException ex) {
                for (long i3 = 1L; i3 < length; ++i3) {
                    double elem = a2.getDouble(i3);
                    if (!(elem < min2)) continue;
                    min2 = elem;
                }
            }
        }
        return min2;
    }

    public static double max(final LargeArray a2) {
        if (a2 == null || !a2.isNumeric() || a2.getType() == LargeArrayType.COMPLEX_FLOAT || a2.getType() == LargeArrayType.COMPLEX_DOUBLE) {
            throw new IllegalArgumentException("a == null || !a.isNumeric() || a.getType() == LargeArrayType.COMPLEX_FLOAT || a.getType() == LargeArrayType.COMPLEX_DOUBLE");
        }
        if (a2.isConstant()) {
            return a2.getDouble(0L);
        }
        double max = a2.getDouble(0L);
        long length = a2.length();
        int nthreads = (int)FastMath.min((long)length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long i2 = 1L; i2 < length; ++i2) {
                double elem = a2.getDouble(i2);
                if (!(elem > max)) continue;
                max = elem;
            }
        } else {
            int j2;
            long k2 = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (j2 = 0; j2 < nthreads; ++j2) {
                final long firstIdx = (long)j2 * k2;
                final long lastIdx = j2 == nthreads - 1 ? length : firstIdx + k2;
                threads[j2] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() {
                        double max = a2.getDouble(firstIdx);
                        for (long k2 = firstIdx + 1L; k2 < lastIdx; ++k2) {
                            double elem = a2.getDouble(k2);
                            if (!(elem > max)) continue;
                            max = elem;
                        }
                        return max;
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
                for (j2 = 0; j2 < nthreads; ++j2) {
                    double res = (Double)threads[j2].get();
                    if (!(res > max)) continue;
                    max = res;
                }
            }
            catch (InterruptedException | ExecutionException ex) {
                for (long i3 = 1L; i3 < length; ++i3) {
                    double elem = a2.getDouble(i3);
                    if (!(elem > max)) continue;
                    max = elem;
                }
            }
        }
        return max;
    }

    public static double sum(final LargeArray a2) {
        if (a2 == null || !a2.isNumeric() || a2.getType() == LargeArrayType.COMPLEX_FLOAT || a2.getType() == LargeArrayType.COMPLEX_DOUBLE) {
            throw new IllegalArgumentException("a == null || !a.isNumeric() || a.getType() == LargeArrayType.COMPLEX_FLOAT || a.getType() == LargeArrayType.COMPLEX_DOUBLE");
        }
        if (a2.isConstant()) {
            return (double)a2.length() * a2.getDouble(0L);
        }
        double sum = 0.0;
        long length = a2.length();
        int nthreads = (int)FastMath.min((long)length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long i2 = 0L; i2 < length; ++i2) {
                sum += a2.getDouble(i2);
            }
        } else {
            int j2;
            long k2 = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (j2 = 0; j2 < nthreads; ++j2) {
                final long firstIdx = (long)j2 * k2;
                final long lastIdx = j2 == nthreads - 1 ? length : firstIdx + k2;
                threads[j2] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() {
                        double sum = 0.0;
                        for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                            sum += a2.getDouble(k2);
                        }
                        return sum;
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
                for (j2 = 0; j2 < nthreads; ++j2) {
                    double res = (Double)threads[j2].get();
                    sum += res;
                }
            }
            catch (InterruptedException | ExecutionException ex) {
                for (long i3 = 0L; i3 < length; ++i3) {
                    sum += a2.getDouble(i3);
                }
            }
        }
        return sum;
    }

    public static double sumKahan(final LargeArray a2) {
        if (a2 == null || !a2.isNumeric() || a2.getType() == LargeArrayType.COMPLEX_FLOAT || a2.getType() == LargeArrayType.COMPLEX_DOUBLE) {
            throw new IllegalArgumentException("a == null || !a.isNumeric() || a.getType() == LargeArrayType.COMPLEX_FLOAT || a.getType() == LargeArrayType.COMPLEX_DOUBLE");
        }
        if (a2.isConstant()) {
            return (double)a2.length() * a2.getDouble(0L);
        }
        double sum = 0.0;
        double c2 = 0.0;
        long length = a2.length();
        int nthreads = (int)FastMath.min((long)length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long i2 = 0L; i2 < length; ++i2) {
                double y2 = a2.getDouble(i2) - c2;
                double t2 = sum + y2;
                c2 = t2 - sum - y2;
                sum = t2;
            }
        } else {
            int j2;
            long k2 = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (j2 = 0; j2 < nthreads; ++j2) {
                final long firstIdx = (long)j2 * k2;
                final long lastIdx = j2 == nthreads - 1 ? length : firstIdx + k2;
                threads[j2] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() {
                        double sum = 0.0;
                        double c2 = 0.0;
                        for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                            double y2 = a2.getDouble(k2) - c2;
                            double t2 = sum + y2;
                            c2 = t2 - sum - y2;
                            sum = t2;
                        }
                        return sum;
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
                for (j2 = 0; j2 < nthreads; ++j2) {
                    double res = (Double)threads[j2].get();
                    sum += res;
                }
            }
            catch (InterruptedException | ExecutionException ex) {
                for (long i3 = 0L; i3 < length; ++i3) {
                    double y3 = a2.getDouble(i3) - c2;
                    double t3 = sum + y3;
                    c2 = t3 - sum - y3;
                    sum = t3;
                }
            }
        }
        return sum;
    }

    public static double avg(final LargeArray a2) {
        if (a2 == null || !a2.isNumeric() || a2.getType() == LargeArrayType.COMPLEX_FLOAT || a2.getType() == LargeArrayType.COMPLEX_DOUBLE) {
            throw new IllegalArgumentException("a == null || !a.isNumeric() || a.getType() == LargeArrayType.COMPLEX_FLOAT || a.getType() == LargeArrayType.COMPLEX_DOUBLE");
        }
        if (a2.isConstant()) {
            return a2.getDouble(0L);
        }
        double sum = 0.0;
        long length = a2.length();
        int nthreads = (int)FastMath.min((long)length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long i2 = 0L; i2 < length; ++i2) {
                sum += a2.getDouble(i2);
            }
        } else {
            int j2;
            long k2 = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (j2 = 0; j2 < nthreads; ++j2) {
                final long firstIdx = (long)j2 * k2;
                final long lastIdx = j2 == nthreads - 1 ? length : firstIdx + k2;
                threads[j2] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() {
                        double sum = 0.0;
                        for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                            sum += a2.getDouble(k2);
                        }
                        return sum;
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
                for (j2 = 0; j2 < nthreads; ++j2) {
                    double res = (Double)threads[j2].get();
                    sum += res;
                }
            }
            catch (InterruptedException | ExecutionException ex) {
                for (long i3 = 0L; i3 < length; ++i3) {
                    sum += a2.getDouble(i3);
                }
            }
        }
        return sum / (double)length;
    }

    public static double avgKahan(final LargeArray a2) {
        if (a2 == null || !a2.isNumeric() || a2.getType() == LargeArrayType.COMPLEX_FLOAT || a2.getType() == LargeArrayType.COMPLEX_DOUBLE) {
            throw new IllegalArgumentException("a == null || !a.isNumeric() || a.getType() == LargeArrayType.COMPLEX_FLOAT || a.getType() == LargeArrayType.COMPLEX_DOUBLE");
        }
        if (a2.isConstant()) {
            return a2.getDouble(0L);
        }
        double sum = 0.0;
        double c2 = 0.0;
        long length = a2.length();
        int nthreads = (int)FastMath.min((long)length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long i2 = 0L; i2 < length; ++i2) {
                double y2 = a2.getDouble(i2) - c2;
                double t2 = sum + y2;
                c2 = t2 - sum - y2;
                sum = t2;
            }
        } else {
            int j2;
            long k2 = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (j2 = 0; j2 < nthreads; ++j2) {
                final long firstIdx = (long)j2 * k2;
                final long lastIdx = j2 == nthreads - 1 ? length : firstIdx + k2;
                threads[j2] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() {
                        double sum = 0.0;
                        double c2 = 0.0;
                        for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                            double y2 = a2.getDouble(k2) - c2;
                            double t2 = sum + y2;
                            c2 = t2 - sum - y2;
                            sum = t2;
                        }
                        return sum;
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
                for (j2 = 0; j2 < nthreads; ++j2) {
                    double res = (Double)threads[j2].get();
                    sum += res;
                }
            }
            catch (InterruptedException | ExecutionException ex) {
                for (long i3 = 0L; i3 < length; ++i3) {
                    double y3 = a2.getDouble(i3) - c2;
                    double t3 = sum + y3;
                    c2 = t3 - sum - y3;
                    sum = t3;
                }
            }
        }
        return sum / (double)length;
    }

    public static double std(final LargeArray a2) {
        if (a2 == null || !a2.isNumeric() || a2.getType() == LargeArrayType.COMPLEX_FLOAT || a2.getType() == LargeArrayType.COMPLEX_DOUBLE) {
            throw new IllegalArgumentException("a == null || !a.isNumeric() || a.getType() == LargeArrayType.COMPLEX_FLOAT || a.getType() == LargeArrayType.COMPLEX_DOUBLE");
        }
        if (a2.isConstant()) {
            return 0.0;
        }
        double sum = 0.0;
        double sum2 = 0.0;
        double c1 = 0.0;
        double c2 = 0.0;
        long length = a2.length();
        if (length < 2L) {
            return Double.NaN;
        }
        int nthreads = (int)FastMath.min((long)length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long i2 = 0L; i2 < length; ++i2) {
                double elem = a2.getDouble(i2);
                double y2 = elem - c1;
                double t2 = sum + y2;
                c1 = t2 - sum - y2;
                sum = t2;
                double y22 = elem * elem - c2;
                double t22 = sum2 + y22;
                c2 = t22 - sum2 - y22;
                sum2 = t22;
            }
        } else {
            int j2;
            long k2 = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (j2 = 0; j2 < nthreads; ++j2) {
                final long firstIdx = (long)j2 * k2;
                final long lastIdx = j2 == nthreads - 1 ? length : firstIdx + k2;
                threads[j2] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() {
                        double[] sum = new double[2];
                        double c1 = 0.0;
                        double c2 = 0.0;
                        for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                            double elem = a2.getDouble(k2);
                            double y2 = elem - c1;
                            double t2 = sum[0] + y2;
                            c1 = t2 - sum[0] - y2;
                            sum[0] = t2;
                            double y22 = elem * elem - c2;
                            double t22 = sum[1] + y22;
                            c2 = t22 - sum[1] - y22;
                            sum[1] = t22;
                        }
                        return sum;
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
                for (j2 = 0; j2 < nthreads; ++j2) {
                    double[] res = (double[])threads[j2].get();
                    sum += res[0];
                    sum2 += res[1];
                }
            }
            catch (InterruptedException | ExecutionException ex) {
                for (long i3 = 0L; i3 < length; ++i3) {
                    double elem = a2.getDouble(i3);
                    double y3 = elem - c1;
                    double t3 = sum + y3;
                    c1 = t3 - sum - y3;
                    sum = t3;
                    double y2 = elem * elem - c2;
                    double t2 = sum2 + y2;
                    c2 = t2 - sum2 - y2;
                    sum2 = t2;
                }
            }
        }
        return FastMath.sqrt((double)FastMath.max((double)0.0, (double)((sum2 /= (double)length) - (sum /= (double)length) * sum)));
    }

    public static double stdKahan(final LargeArray a2) {
        if (a2 == null || !a2.isNumeric() || a2.getType() == LargeArrayType.COMPLEX_FLOAT || a2.getType() == LargeArrayType.COMPLEX_DOUBLE) {
            throw new IllegalArgumentException("a == null || !a.isNumeric() || a.getType() == LargeArrayType.COMPLEX_FLOAT || a.getType() == LargeArrayType.COMPLEX_DOUBLE");
        }
        if (a2.isConstant()) {
            return 0.0;
        }
        double sum = 0.0;
        double sum2 = 0.0;
        long length = a2.length();
        if (length < 2L) {
            return Double.NaN;
        }
        int nthreads = (int)FastMath.min((long)length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long i2 = 0L; i2 < length; ++i2) {
                double elem = a2.getDouble(i2);
                sum += elem;
                sum2 += elem * elem;
            }
        } else {
            int j2;
            long k2 = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (j2 = 0; j2 < nthreads; ++j2) {
                final long firstIdx = (long)j2 * k2;
                final long lastIdx = j2 == nthreads - 1 ? length : firstIdx + k2;
                threads[j2] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() {
                        double[] sum = new double[2];
                        for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                            double elem = a2.getDouble(k2);
                            sum[0] = sum[0] + elem;
                            sum[1] = sum[1] + elem * elem;
                        }
                        return sum;
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
                for (j2 = 0; j2 < nthreads; ++j2) {
                    double[] res = (double[])threads[j2].get();
                    sum += res[0];
                    sum2 += res[1];
                }
            }
            catch (InterruptedException | ExecutionException ex) {
                for (long i3 = 0L; i3 < length; ++i3) {
                    double elem = a2.getDouble(i3);
                    sum += elem;
                    sum2 += elem * elem;
                }
            }
        }
        return FastMath.sqrt((double)FastMath.max((double)0.0, (double)((sum2 /= (double)length) - (sum /= (double)length) * sum)));
    }
}

