/*
 * Decompiled with CFR 0.152.
 */
package water;

import water.Atomic;
import water.Futures;
import water.H2O;
import water.H2ONode;
import water.Iced;
import water.Key;
import water.Keyed;
import water.Paxos;
import water.RPC;
import water.TaskGetKey;
import water.TaskPutKey;
import water.Value;

public abstract class DKV {
    public static Value put(Key key, Iced v2) {
        return DKV.put(key, new Value(key, v2));
    }

    public static Value put(Key key, Iced v2, Futures fs) {
        return DKV.put(key, new Value(key, v2), fs);
    }

    public static Value put(Key key, Iced v2, Futures fs, boolean dontCache) {
        return DKV.put(key, new Value(key, v2), fs, dontCache);
    }

    public static Value put(Keyed keyed) {
        return DKV.put(keyed._key, new Value(keyed._key, keyed));
    }

    public static Value put(Keyed keyed, Futures fs) {
        return DKV.put(keyed._key, new Value(keyed._key, keyed), fs);
    }

    public static Value put(Key key, Value val) {
        Futures fs = new Futures();
        Value old = DKV.put(key, val, fs);
        fs.blockForPending();
        return old;
    }

    public static Value put(Key key, Value val, Futures fs) {
        return DKV.put(key, val, fs, false);
    }

    public static Value put(Key key, Value val, Futures fs, boolean dontCache) {
        assert (key != null);
        assert (val == null || val._key == key) : "non-matching keys " + key + " != " + val._key;
        Value old;
        Value res;
        while ((res = DKV.DputIfMatch(key, val, old = Value.STORE_get(key), fs, dontCache)) != old) {
            if (val == null || val._key == key) continue;
            key = val._key;
        }
        return old;
    }

    public static Value remove(Key key) {
        return DKV.put(key, null);
    }

    public static Value remove(Key key, Futures fs) {
        return DKV.put(key, null, fs);
    }

    public static Value DputIfMatch(Key key, Value val, Value old, Futures fs) {
        return DKV.DputIfMatch(key, val, old, fs, false);
    }

    public static Value DputIfMatch(Key key, Value val, Value old, Futures fs, boolean dontCache) {
        Value res;
        if (old != null && !key.home()) {
            old.startRemotePut();
        }
        if (val == null && key.home()) {
            val = Value.makeNull(key);
        }
        if ((res = H2O.putIfMatch(key, val, old)) != old) {
            return res;
        }
        if (old != null && old == val) {
            System.out.println("No invalidate, new==old");
            return old;
        }
        if (old != null && val != null && val.equals(old)) {
            System.out.println("No invalidate, new.equals(old)");
            return old;
        }
        Paxos.lockCloud(key);
        if (key.home()) {
            if (old != null) {
                old.lockAndInvalidate(H2O.SELF, val, fs);
            } else {
                val.lowerActiveGetCount(null);
            }
        } else {
            TaskPutKey.put(key.home_node(), key, val, fs, dontCache);
        }
        return old;
    }

    static void write_barrier() {
        for (H2ONode h2o : H2O.CLOUD._memary) {
            for (RPC rpc : h2o.tasks()) {
                if (!(rpc._dt instanceof TaskPutKey) && !(rpc._dt instanceof Atomic)) continue;
                rpc.get();
            }
        }
    }

    public static <T extends Iced> T getGet(String key) {
        return key == null ? null : (T)DKV.getGet(Key.make(key));
    }

    public static <T extends Iced> T getGet(Key key) {
        if (null == key) {
            return null;
        }
        Value v2 = DKV.get(key);
        if (null == v2) {
            return null;
        }
        return v2.get();
    }

    public static Value get(Key key) {
        return DKV.get(key, true);
    }

    public static void prefetch(Key key) {
        DKV.get(key, false);
    }

    public static Value get(String key_name) {
        return DKV.get(Key.make(key_name), true);
    }

    public static void prefetch(String key_name) {
        DKV.get(Key.make(key_name), false);
    }

    private static Value get(Key key, boolean blocking) {
        H2ONode home;
        H2O cloud = H2O.CLOUD;
        Value val = Value.STORE_get(key);
        if (val != null) {
            if (val.rawMem() != null || val.rawPOJO() != null || val.isPersisted()) {
                return val;
            }
            assert (!key.home());
        }
        if ((home = cloud._memary[key.home(cloud)]) == H2O.SELF) {
            return null;
        }
        TaskPutKey tpk = home.pendingPutKey(key);
        if (tpk != null) {
            return tpk._xval == null || tpk._xval.isNull() ? null : tpk._xval;
        }
        RPC<TaskGetKey> tgk = TaskGetKey.start(home, key);
        return blocking ? TaskGetKey.get(tgk) : null;
    }
}

