/*
 * Decompiled with CFR 0.152.
 */
package water;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ByteChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import water.AutoBuffer;
import water.DTask;
import water.H2O;
import water.H2ONodeTimestamp;
import water.H2OSecurityManager;
import water.HeartBeat;
import water.Iced;
import water.Key;
import water.Paxos;
import water.RPC;
import water.TaskPutKey;
import water.ThreadHelper;
import water.nbhm.NonBlockingHashMap;
import water.nbhm.NonBlockingHashMapLong;
import water.network.SocketChannelFactory;
import water.util.ArrayUtils;
import water.util.Log;
import water.util.MathUtils;
import water.util.UnsafeUtils;

public final class H2ONode
extends Iced<H2ONode>
implements Comparable {
    private transient SocketChannelFactory _socketFactory;
    private transient H2OSecurityManager _security;
    private transient PriorityBlockingQueue<ByteBuffer> _outgoingMsgQ;
    transient short _unique_idx;
    transient boolean _announcedLostContact;
    public transient long _last_heard_from;
    public volatile transient HeartBeat _heartbeat;
    public transient int _tcp_readers;
    private transient short _timestamp;
    private transient boolean _removed_from_cloud;
    private volatile transient boolean _accessed_local_dkv;
    public final H2Okey _key;
    private static final NonBlockingHashMap<H2Okey, H2ONode> INTERN = new NonBlockingHashMap();
    private static final AtomicInteger UNIQUE = new AtomicInteger(1);
    static H2ONode[] IDX = new H2ONode[1];
    private transient ByteChannel[] _socks = new ByteChannel[2];
    private transient int _socksAvail = this._socks.length;
    static final AtomicInteger TCPS = new AtomicInteger(0);
    private transient SmallMessagesSendThread _sendThread = null;
    private static String SEND_THREAD_NAME_PREFIX = "TCP-SMALL-SEND-";
    private final NonBlockingHashMapLong<RPC> _tasks = new NonBlockingHashMapLong();
    private final NonBlockingHashMapLong<TaskPutKey> _tasksPutKey = new NonBlockingHashMapLong();
    private final AtomicInteger _created_task_ids = new AtomicInteger(1);
    private final NonBlockingHashMapLong<RPC.RPCCall> _work = new NonBlockingHashMapLong();
    private final AtomicInteger _removed_task_ids = new AtomicInteger(0);
    private final RPC.RPCCall _removed_task = new RPC.RPCCall(this);

    public final boolean isClient() {
        return this._heartbeat._client;
    }

    final void setTimestamp(short newTimestamp) {
        if (!H2ONodeTimestamp.isDefined(this._timestamp) && H2ONodeTimestamp.isDefined(newTimestamp)) {
            boolean isClient = H2ONodeTimestamp.decodeIsClient(newTimestamp);
            if (isClient) {
                Log.info("Client " + this + " started communicating with this H2O node.");
            } else {
                Log.debug("H2O Node " + this + " started communicating with this H2O node.");
            }
        }
        this._timestamp = newTimestamp;
    }

    public final short getTimestamp() {
        return this._timestamp;
    }

    public final boolean isRemovedFromCloud() {
        return this._removed_from_cloud;
    }

    private boolean isPossibleClient() {
        return H2ONodeTimestamp.decodeIsClient(this._timestamp) || this.isClient();
    }

    void setHeartBeat(HeartBeat hb) {
        this._heartbeat = hb;
    }

    void removeFromCloud() {
        this._removed_from_cloud = true;
        this.stopSendThread();
    }

    private void stopSendThread() {
        this._sendThread = null;
    }

    private SmallMessagesSendThread startSendThread() {
        SmallMessagesSendThread newSendThread;
        if (this.isClient() && !H2O.ARGS.allow_clients) {
            throw new IllegalStateException("Attempt to communicate with client " + this.getIpPortString() + " blocked. Client connections are not allowed in this cloud.");
        }
        this._sendThread = newSendThread = new SmallMessagesSendThread();
        newSendThread.start();
        return newSendThread;
    }

    public String getIp() {
        return this._key.getHostString();
    }

    public String getIpPortString() {
        return this._key.getIpPortString();
    }

    public final int ip4() {
        return (int)this._key._ipLow;
    }

    public boolean isSelf() {
        return this == H2O.SELF;
    }

    private H2ONode(H2Okey key, short unique_idx, short timestamp) {
        this._key = key;
        this._unique_idx = unique_idx;
        this._last_heard_from = System.currentTimeMillis();
        this._heartbeat = new HeartBeat();
        this._timestamp = timestamp;
        this._security = H2OSecurityManager.instance();
        this._socketFactory = SocketChannelFactory.instance(this._security);
        this._outgoingMsgQ = H2ONode.makeOutgoingMessageQueue();
        this._sendThread = null;
    }

    public boolean isHealthy() {
        return this.isHealthy(System.currentTimeMillis());
    }

    public boolean isHealthy(long now) {
        return now - this._last_heard_from < 60000L;
    }

    public void markLocalDKVAccess() {
        this._accessed_local_dkv = true;
    }

    public boolean accessedLocalDKV() {
        return this._accessed_local_dkv;
    }

    static H2ONode[] getClients() {
        ArrayList<H2ONode> clients = new ArrayList<H2ONode>(INTERN.size());
        for (Map.Entry<H2Okey, H2ONode> entry : INTERN.entrySet()) {
            if (!entry.getValue().isClient() || entry.getValue().isRemovedFromCloud()) continue;
            clients.add(entry.getValue());
        }
        return clients.toArray(new H2ONode[0]);
    }

    static H2ONode getClientByIPPort(String ipPort) {
        for (Map.Entry<H2Okey, H2ONode> entry : INTERN.entrySet()) {
            if (!entry.getValue().isClient() || entry.getValue().isRemovedFromCloud() || !entry.getValue().getIpPortString().equals(ipPort)) continue;
            return entry.getValue();
        }
        return null;
    }

    private void refreshClient(short newTimestamp) {
        boolean respawned = H2ONodeTimestamp.hasNodeRespawned(this._timestamp, newTimestamp);
        if (respawned) {
            Log.info("Client reconnected with a new timestamp=" + newTimestamp + ", old client: " + this.toDebugString());
            if (this._sendThread != null) {
                this.startSendThread();
            }
        }
        if (!H2ONodeTimestamp.isDefined(newTimestamp)) {
            this.setTimestamp(newTimestamp);
        }
        this._removed_from_cloud = false;
        this._last_heard_from = System.currentTimeMillis();
    }

    boolean removeClient() {
        Log.info("Removing client: " + this.toDebugString());
        boolean removed = !this._removed_from_cloud;
        this.removeFromCloud();
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static H2ONode intern(H2Okey key, short timestamp) {
        boolean foundPossibleClient = H2ONodeTimestamp.decodeIsClient(timestamp);
        if (!H2O.ARGS.client && foundPossibleClient && !H2O.ARGS.allow_clients) {
            throw new IllegalStateException("Client connections are not allowed, source " + key.getIpPortString());
        }
        H2ONode h2o = INTERN.get(key);
        if (h2o != null) {
            if (foundPossibleClient || h2o.isPossibleClient()) {
                h2o.refreshClient(timestamp);
            }
            if (!H2ONodeTimestamp.isDefined(h2o.getTimestamp())) {
                h2o.setTimestamp(timestamp);
            }
            return h2o;
        }
        if (foundPossibleClient) {
            Log.info("New (possible) client found, timestamp=" + timestamp);
        }
        int idx = UNIQUE.getAndIncrement();
        assert (idx < Short.MAX_VALUE);
        h2o = new H2ONode(key, (short)idx, timestamp);
        H2ONode old = INTERN.putIfAbsent(key, h2o);
        if (old != null) {
            if (foundPossibleClient && old.isPossibleClient()) {
                old.refreshClient(timestamp);
            }
            return old;
        }
        Class<H2O> clazz = H2O.class;
        synchronized (H2O.class) {
            while (idx >= IDX.length) {
                IDX = Arrays.copyOf(IDX, IDX.length << 1);
            }
            H2ONode.IDX[idx] = h2o;
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return h2o;
        }
    }

    static H2ONode intern(InetAddress ip, int port, short timestamp) {
        return H2ONode.intern(new H2Okey(ip, port), timestamp);
    }

    public static H2ONode intern(InetAddress ip, int port) {
        return H2ONode.intern(ip, port, (short)0);
    }

    static H2ONode intern(byte[] bs, int off) {
        byte[] b2 = new byte[H2Okey.SIZE_OF_IP];
        if (!H2O.IS_IPV6) {
            UnsafeUtils.set4(b2, 0, UnsafeUtils.get4(bs, off));
        } else {
            UnsafeUtils.set8(b2, 0, UnsafeUtils.get8(bs, off));
            UnsafeUtils.set8(b2, 8, UnsafeUtils.get8(bs, off + 8));
        }
        int port = UnsafeUtils.get2(bs, off + H2Okey.SIZE_OF_IP) & 0xFFFF;
        try {
            return H2ONode.intern(InetAddress.getByAddress(b2), port);
        }
        catch (UnknownHostException e2) {
            throw Log.throwErr(e2);
        }
    }

    public static H2ONode self(InetAddress local) {
        assert (H2O.H2O_PORT != 0);
        try {
            ArrayList<NetworkInterface> matchingIfs = new ArrayList<NetworkInterface>();
            Enumeration<NetworkInterface> netIfs = NetworkInterface.getNetworkInterfaces();
            block8: while (netIfs.hasMoreElements()) {
                NetworkInterface netIf = netIfs.nextElement();
                Enumeration<InetAddress> addrs = netIf.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress addr = addrs.nextElement();
                    if (!addr.equals(local)) continue;
                    matchingIfs.add(netIf);
                    continue block8;
                }
            }
            switch (matchingIfs.size()) {
                case 0: {
                    H2O.CLOUD_MULTICAST_IF = null;
                    break;
                }
                case 1: {
                    H2O.CLOUD_MULTICAST_IF = (NetworkInterface)matchingIfs.get(0);
                    break;
                }
                default: {
                    String msg = "Found multiple network interfaces for ip address " + local;
                    for (NetworkInterface ni : matchingIfs) {
                        msg = msg + "\n\t" + ni;
                    }
                    msg = msg + "\nUsing " + matchingIfs.get(0) + " for UDP broadcast";
                    Log.warn(msg);
                    H2O.CLOUD_MULTICAST_IF = (NetworkInterface)matchingIfs.get(0);
                    break;
                }
            }
        }
        catch (SocketException e2) {
            throw Log.throwErr(e2);
        }
        try {
            if (H2O.CLOUD_MULTICAST_IF != null && !H2O.CLOUD_MULTICAST_IF.supportsMulticast()) {
                Log.info("Selected H2O.CLOUD_MULTICAST_IF: " + H2O.CLOUD_MULTICAST_IF + " doesn't support multicast");
            }
            if (H2O.CLOUD_MULTICAST_IF != null && !H2O.CLOUD_MULTICAST_IF.isUp()) {
                throw new RuntimeException("Selected H2O.CLOUD_MULTICAST_IF: " + H2O.CLOUD_MULTICAST_IF + " is not up and running");
            }
        }
        catch (SocketException e3) {
            throw Log.throwErr(e3);
        }
        return H2ONode.intern(new H2Okey(local, H2O.H2O_PORT), H2ONodeTimestamp.calculateNodeTimestamp());
    }

    public String toString() {
        return this._key.toString();
    }

    public String toDebugString() {
        String base = this._key.toString();
        if (!this.isClient()) {
            return base;
        }
        StringBuilder sb = new StringBuilder(base);
        sb.append("(");
        sb.append("timestamp=").append(this._timestamp);
        if (this._heartbeat != null) {
            sb.append(", ").append("cloud_name_hash=").append(this._heartbeat._cloud_name_hash);
        }
        sb.append(")");
        return sb.toString();
    }

    public int hashCode() {
        return this._key.hashCode();
    }

    public boolean equals(Object o2) {
        return this._key.equals(((H2ONode)o2)._key);
    }

    public int compareTo(Object o2) {
        return this._key.compareTo(((H2ONode)o2)._key);
    }

    public int index() {
        return H2O.CLOUD.nidx(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ByteChannel getTCPSocket() throws IOException {
        H2ONode h2ONode = this;
        synchronized (h2ONode) {
            ByteChannel sock;
            while (this._socksAvail == 0) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if ((sock = this._socks[--this._socksAvail]) != null) {
                if (sock.isOpen()) {
                    return sock;
                }
                assert (TCPS.get() > 0);
                TCPS.decrementAndGet();
            }
        }
        SocketChannel sock2 = SocketChannel.open();
        sock2.socket().setReuseAddress(true);
        sock2.socket().setSendBufferSize(AutoBuffer.BBP_BIG._size);
        boolean res = sock2.connect(this._key);
        assert (res && !sock2.isConnectionPending() && sock2.isBlocking() && sock2.isConnected() && sock2.isOpen());
        ByteBuffer bb = ByteBuffer.allocate(6).order(ByteOrder.nativeOrder());
        bb.put((byte)2);
        bb.putShort(H2O.SELF._timestamp);
        bb.putChar((char)H2O.H2O_PORT);
        bb.put((byte)-17);
        bb.flip();
        ByteChannel wrappedSocket = this._socketFactory.clientChannel(sock2, this._key.getHostName(), this._key.getPort());
        while (bb.hasRemaining()) {
            wrappedSocket.write(bb);
        }
        TCPS.incrementAndGet();
        return wrappedSocket;
    }

    synchronized void freeTCPSocket(ByteChannel sock) {
        assert (0 <= this._socksAvail && this._socksAvail < this._socks.length);
        assert (TCPS.get() > 0);
        if (sock != null && !sock.isOpen()) {
            sock = null;
        }
        this._socks[this._socksAvail++] = sock;
        if (sock == null) {
            TCPS.decrementAndGet();
        }
        this.notify();
    }

    public final void sendMessage(ByteBuffer bb, byte msg_priority) {
        SmallMessagesSendThread sendThread = this._sendThread;
        if (sendThread == null) {
            if (this._removed_from_cloud) {
                Log.warn("Node " + this + " is not active in the cloud anymore but we want to communicate with it.Re-opening the communication channel.");
            }
            sendThread = this.startSendThread();
        }
        assert (sendThread != null);
        sendThread.sendMessage(bb, msg_priority);
    }

    public static ByteChannel openChan(byte tcpType, SocketChannelFactory socketFactory, InetAddress originAddr, int originPort, short nodeTimeStamp) throws IOException {
        SocketChannel sock = SocketChannel.open();
        sock.socket().setReuseAddress(true);
        sock.socket().setSendBufferSize(AutoBuffer.BBP_BIG._size);
        InetSocketAddress isa = new InetSocketAddress(originAddr, originPort);
        boolean res = sock.connect(isa);
        assert (res) : "Should be already connected, but connection is in non-blocking mode and the connection operation is in progress!";
        sock.configureBlocking(true);
        assert (!sock.isConnectionPending() && sock.isBlocking() && sock.isConnected() && sock.isOpen());
        sock.socket().setTcpNoDelay(true);
        ByteBuffer bb = ByteBuffer.allocate(6).order(ByteOrder.nativeOrder());
        bb.put(tcpType).putShort(nodeTimeStamp).putChar((char)H2O.H2O_PORT).put((byte)-17).flip();
        ByteChannel wrappedSocket = socketFactory.clientChannel(sock, isa.getHostName(), isa.getPort());
        while (bb.hasRemaining()) {
            wrappedSocket.write(bb);
        }
        return wrappedSocket;
    }

    public static ByteChannel openChan(byte tcpType, SocketChannelFactory socketFactory, String originAddr, int originPort, short nodeTimeStamp) throws IOException {
        return H2ONode.openChan(tcpType, socketFactory, InetAddress.getByName(originAddr), originPort, nodeTimeStamp);
    }

    private static PriorityBlockingQueue<ByteBuffer> makeOutgoingMessageQueue() {
        return new PriorityBlockingQueue<ByteBuffer>(11, new Comparator<ByteBuffer>(){

            @Override
            public int compare(ByteBuffer bb1, ByteBuffer bb2) {
                return bb1.position() - bb2.position();
            }
        });
    }

    void taskPut(int tnum, RPC rpc) {
        this._tasks.put(tnum, rpc);
        if (rpc._dt instanceof TaskPutKey) {
            this._tasksPutKey.put(tnum, (TaskPutKey)rpc._dt);
        }
    }

    RPC taskGet(int tnum) {
        return this._tasks.get(tnum);
    }

    void taskRemove(int tnum) {
        this._tasks.remove(tnum);
        this._tasksPutKey.remove(tnum);
    }

    Collection<RPC> tasks() {
        return this._tasks.values();
    }

    int taskSize() {
        return this._tasks.size();
    }

    TaskPutKey pendingPutKey(Key k2) {
        for (TaskPutKey tpk : this._tasksPutKey.values()) {
            if (!k2.equals(tpk._key)) continue;
            return tpk;
        }
        return null;
    }

    int nextTaskNum() {
        return this._created_task_ids.getAndIncrement();
    }

    RPC.RPCCall has_task(int tnum) {
        if (tnum <= this._removed_task_ids.get()) {
            return this._removed_task;
        }
        return this._work.get(tnum);
    }

    RPC.RPCCall record_task(RPC.RPCCall rpc) {
        RPC.RPCCall x2 = this._work.putIfAbsent(rpc._tsknum, rpc);
        if (x2 != null) {
            return x2;
        }
        if (rpc._tsknum > this._removed_task_ids.get()) {
            return null;
        }
        this._work.remove(rpc._tsknum);
        return this._removed_task;
    }

    void record_task_answer(RPC.RPCCall rpcall) {
        rpcall._started = System.currentTimeMillis();
        rpcall._retry = 10000L;
    }

    void remove_task_tracking(int task) {
        int t2;
        RPC.RPCCall rpc2;
        RPC.RPCCall rpc = this._work.get(task);
        if (rpc == null) {
            return;
        }
        DTask dt = rpc._dt;
        if (dt != null && rpc.CAS_DT(dt, null)) {
            assert (rpc._computed) : "Still not done #" + task + " " + dt.getClass() + " from " + rpc._client;
            dt.onAckAck();
        }
        while ((rpc2 = this._work.get((t2 = this._removed_task_ids.get()) + 1)) != null && rpc2._dt == null && this._removed_task_ids.compareAndSet(t2, t2 + 1)) {
            this._work.remove(t2 + 1);
        }
    }

    void rebooted() {
        this._work.clear();
        this._removed_task_ids.set(0);
    }

    public final AutoBuffer write_impl(AutoBuffer ab) {
        return this._key.write(ab);
    }

    public final H2ONode read_impl(AutoBuffer ab) {
        return H2ONode.intern(H2Okey.read(ab), (short)0);
    }

    public final AutoBuffer writeJSON_impl(AutoBuffer ab) {
        return ab.putJSONStr("node", this._key.toString());
    }

    public final H2ONode readJSON_impl(AutoBuffer ab) {
        throw H2O.fail();
    }

    public SocketChannelFactory getSocketFactory() {
        return this._socketFactory;
    }

    public H2OSecurityManager getSecurityManager() {
        return this._security;
    }

    public boolean isLeaderNode() {
        if (H2O.CLOUD.size() == 0) {
            return false;
        }
        return H2O.CLOUD.leader() != null && H2O.CLOUD.leader().equals(this);
    }

    class SmallMessagesSendThread
    extends Thread {
        private ByteChannel _chan;
        private final ByteBuffer _bb;

        SmallMessagesSendThread() {
            super(SEND_THREAD_NAME_PREFIX + H2ONode.this);
            ThreadHelper.initCommonThreadProperties(this);
            this._bb = AutoBuffer.BBP_BIG.make();
        }

        private void sendMessage(ByteBuffer bb, byte msg_priority) {
            assert (bb.position() == 0 && bb.limit() > 0);
            if (msg_priority >= 119) {
                msg_priority = (byte)(msg_priority - 119 + 10);
            } else if (msg_priority >= 10) {
                msg_priority = (byte)10;
            }
            if (msg_priority > bb.limit()) {
                msg_priority = (byte)bb.limit();
            }
            bb.position(msg_priority);
            H2ONode.this._outgoingMsgQ.put(bb);
        }

        private boolean isActive() {
            return H2ONode.this._sendThread == this || H2ONode.this._sendThread == null && H2ONode.this.isPossibleClient();
        }

        private boolean keepSending() {
            return !H2ONode.this.isRemovedFromCloud() || H2ONode.this.isPossibleClient();
        }

        @Override
        public void run() {
            try {
                while (this.isActive()) {
                    try {
                        ByteBuffer bb = (ByteBuffer)H2ONode.this._outgoingMsgQ.take();
                        if (!this.isActive()) {
                            H2ONode.this._outgoingMsgQ.put(bb);
                            break;
                        }
                        while (bb != null) {
                            assert (!bb.isDirect()) : "Direct BBs already got recycled";
                            assert (bb.limit() + 1 + 2 <= this._bb.capacity()) : "Small message larger than the output buffer";
                            if (this._bb.remaining() < bb.limit() + 1 + 2) {
                                this.sendBuffer();
                            }
                            this._bb.putChar((char)bb.limit());
                            this._bb.put(bb.array(), 0, bb.limit());
                            this._bb.put((byte)-17);
                            bb = (ByteBuffer)H2ONode.this._outgoingMsgQ.poll();
                        }
                        this.sendBuffer();
                    }
                    catch (IllegalMonitorStateException bb) {
                    }
                    catch (InterruptedException bb) {}
                }
            }
            catch (Throwable t2) {
                throw Log.throwErr(t2);
            }
            if (this._chan != null) {
                try {
                    this._chan.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this._chan = null;
            }
        }

        void sendBuffer() {
            int retries = 0;
            this._bb.flip();
            while (this.keepSending() && this._bb.hasRemaining()) {
                try {
                    ByteChannel byteChannel;
                    if (this._chan == null) {
                        byteChannel = this.openChan();
                        this._chan = this._chan;
                    } else {
                        byteChannel = this._chan;
                    }
                    ByteChannel chan = byteChannel;
                    chan.write(this._bb);
                }
                catch (IOException ioe) {
                    this._bb.rewind();
                    if (this.keepSending() && !H2O.getShutdownRequested() && (Paxos._cloudLocked || retries++ > 300)) {
                        Log.err("Got IO error when sending a batch of bytes: ", ioe);
                        retries = 150;
                    }
                    if (this._chan != null) {
                        try {
                            this._chan.close();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    this._chan = null;
                    int sleep = Math.max(5000, ++retries << 1);
                    try {
                        Thread.sleep(sleep);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this._bb.clear();
        }

        private ByteChannel openChan() throws IOException {
            return H2ONode.openChan((byte)1, H2ONode.this._socketFactory, H2ONode.this._key.getAddress(), H2ONode.this._key.getPort(), H2O.SELF._timestamp);
        }
    }

    static final class H2Okey
    extends InetSocketAddress
    implements Comparable {
        final long _ipHigh;
        final long _ipLow;
        static int SIZE_OF_IP = H2O.IS_IPV6 ? 16 : 4;
        static int SIZE = SIZE_OF_IP + 2;

        H2Okey(InetAddress inet, int port) {
            super(inet, port);
            byte[] b2 = inet.getAddress();
            if (b2.length == 4) {
                assert (!H2O.IS_IPV6) : "IPv4 stack specified but IPv6 address passed! " + inet;
                this._ipHigh = 0L;
                this._ipLow = (long)ArrayUtils.encodeAsInt(b2) & 0xFFFFFFFFL;
            } else {
                assert (H2O.IS_IPV6) : "IPv6 stack specified but IPv4 address passed! " + inet;
                this._ipHigh = ArrayUtils.encodeAsLong(b2, 8, 8);
                this._ipLow = ArrayUtils.encodeAsLong(b2, 0, 8);
            }
        }

        int getApiPort() {
            return this.getPort() - H2O.ARGS.port_offset;
        }

        int getInternalPort() {
            return this.getPort();
        }

        @Override
        public String toString() {
            return this.getAddress() + ":" + this.getApiPort();
        }

        public String getIpPortString() {
            return this.getAddress().getHostAddress() + ":" + this.getApiPort();
        }

        AutoBuffer write(AutoBuffer ab) {
            return (!H2O.IS_IPV6 ? ab.put4((int)this._ipLow) : ab.put8(this._ipLow).put8(this._ipHigh)).put2((char)this.getInternalPort());
        }

        static H2Okey read(AutoBuffer ab) {
            try {
                InetAddress inet = InetAddress.getByAddress(ab.getA1(SIZE_OF_IP));
                char port = ab.get2();
                return new H2Okey(inet, (int)port);
            }
            catch (UnknownHostException e2) {
                throw Log.throwErr(e2);
            }
        }

        public int compareTo(Object x2) {
            if (x2 == null) {
                return -1;
            }
            if (x2 == this) {
                return 0;
            }
            H2Okey key = (H2Okey)x2;
            int res = MathUtils.compareUnsigned(this._ipHigh, this._ipLow, key._ipHigh, key._ipLow);
            return res != 0 ? res : this.getInternalPort() - key.getInternalPort();
        }
    }
}

