/*
 * Decompiled with CFR 0.152.
 */
package water;

import java.util.Random;
import water.AutoBuffer;
import water.Freezable;
import water.HeartBeat;
import water.TypeMap;
import water.util.UnsafeUtils;

public class JavaSelfCheck {
    public static boolean checkCompatibility() {
        if (!JavaSelfCheck.checkUnsafe()) {
            return false;
        }
        if (!JavaSelfCheck.checkWeaver()) {
            return false;
        }
        return JavaSelfCheck.checkSerialization();
    }

    private static boolean checkSerialization() {
        byte[] bytes = AutoBuffer.serializeBootstrapFreezable(new HeartBeat());
        return AutoBuffer.deserializeBootstrapFreezable(bytes) instanceof HeartBeat;
    }

    private static boolean checkWeaver() {
        Freezable f2 = TypeMap.newFreezable(HeartBeat.class.getName());
        if (!(f2 instanceof HeartBeat)) {
            return false;
        }
        return TypeMap.getIcer(f2) != null;
    }

    private static boolean checkUnsafe() {
        int i2;
        int N2 = 1024;
        Random r2 = new Random();
        double[] doubleData = new double[1024];
        byte[] doubleBytes = new byte[8192];
        long[] longData = new long[1024];
        byte[] longBytes = new byte[8192];
        for (i2 = 0; i2 < 1024; ++i2) {
            doubleData[i2] = r2.nextDouble();
            UnsafeUtils.set8d(doubleBytes, i2 * 8, doubleData[i2]);
            longData[i2] = r2.nextLong();
            UnsafeUtils.set8(longBytes, i2 * 8, longData[i2]);
        }
        for (i2 = 0; i2 < 1024; ++i2) {
            double d2 = UnsafeUtils.get8d(doubleBytes, i2 * 8);
            if (d2 != doubleData[i2]) {
                return false;
            }
            long l2 = UnsafeUtils.get8(longBytes, i2 * 8);
            if (l2 == longData[i2]) continue;
            return false;
        }
        return true;
    }
}

