/*
 * Decompiled with CFR 0.152.
 */
package water;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import water.DKV;
import water.H2O;
import water.Iced;
import water.Key;
import water.Lockable;
import water.MRTask;
import water.TypeMap;
import water.Value;

public class KeySnapshot {
    private static final long _updateInterval = 1000L;
    private static volatile KeySnapshot _cache;
    public final KeyInfo[] _keyInfos;
    public final long timestamp;

    public static KeySnapshot cache() {
        return _cache;
    }

    public KeySnapshot filter(KVFilter kvf) {
        ArrayList<KeyInfo> res = new ArrayList<KeyInfo>();
        for (KeyInfo kinfo : this._keyInfos) {
            if (!kvf.filter(kinfo)) continue;
            res.add(kinfo);
        }
        return new KeySnapshot(res.toArray(new KeyInfo[res.size()]));
    }

    KeySnapshot(KeyInfo[] snapshot) {
        this._keyInfos = snapshot;
        this.timestamp = System.currentTimeMillis();
    }

    public Key[] keys() {
        Key[] res = new Key[this._keyInfos.length];
        for (int i2 = 0; i2 < this._keyInfos.length; ++i2) {
            res[i2] = this._keyInfos[i2]._key;
        }
        return res;
    }

    public static Key[] globalKeysOfClass(final Class clz) {
        return KeySnapshot.globalSnapshot().filter(new KVFilter(){

            @Override
            public boolean filter(KeyInfo k2) {
                return Value.isSubclassOf(k2._type, clz);
            }
        }).keys();
    }

    public <T extends Iced> Map<String, T> fetchAll(Class<T> c2) {
        return this.fetchAll(c2, false, 0, Integer.MAX_VALUE);
    }

    public <T extends Iced> Map<String, T> fetchAll(Class<T> c2, boolean exact) {
        return this.fetchAll(c2, exact, 0, Integer.MAX_VALUE);
    }

    public <T extends Iced> Map<String, T> fetchAll(Class<T> c2, boolean exact, int offset, int limit) {
        TreeMap res = new TreeMap();
        int typeId = TypeMap.onIce(c2.getName());
        for (KeyInfo kinfo : this._keyInfos) {
            if (kinfo._type != typeId && (exact || !Value.isSubclassOf(kinfo._type, c2))) continue;
            if (offset > 0) {
                --offset;
                continue;
            }
            Value v2 = DKV.get(kinfo._key);
            if (v2 == null) continue;
            Object t2 = v2.get();
            res.put(kinfo._key.toString(), t2);
            if (res.size() == limit) break;
        }
        return res;
    }

    public static KeySnapshot localSnapshot() {
        return KeySnapshot.localSnapshot(false);
    }

    public static KeySnapshot localSnapshot(boolean homeOnly) {
        Object[] kvs = H2O.STORE.raw_array();
        ArrayList<KeyInfo> res = new ArrayList<KeyInfo>();
        for (int i2 = 2; i2 < kvs.length; i2 += 2) {
            Value val;
            Key key;
            Object ok = kvs[i2];
            if (!(ok instanceof Key) || !(key = (Key)ok).user_allowed() || homeOnly && !key.home() || (val = Value.STORE_get(key)) == null) continue;
            res.add(new KeyInfo(key, val));
        }
        Object[] arr = res.toArray(new KeyInfo[res.size()]);
        Arrays.sort(arr);
        return new KeySnapshot((KeyInfo[])arr);
    }

    public static KeySnapshot globalSnapshot() {
        return KeySnapshot.globalSnapshot(-1L);
    }

    public static KeySnapshot globalSnapshot(long timeTolerance) {
        KeySnapshot res = _cache;
        long t2 = System.currentTimeMillis();
        if (res == null || t2 - res.timestamp > timeTolerance) {
            res = new KeySnapshot(((GlobalUKeySetTask)new GlobalUKeySetTask().doAllNodes())._res);
        } else if (t2 - res.timestamp > 1000L) {
            H2O.submitTask(new H2O.H2OCountedCompleter(){

                @Override
                public void compute2() {
                    new GlobalUKeySetTask().doAllNodes();
                }
            });
        }
        return res;
    }

    private static class GlobalUKeySetTask
    extends MRTask<GlobalUKeySetTask> {
        KeyInfo[] _res;

        GlobalUKeySetTask() {
            super((byte)119);
        }

        @Override
        public void setupLocal() {
            this._res = KeySnapshot.localSnapshot((boolean)true)._keyInfos;
        }

        @Override
        public void reduce(GlobalUKeySetTask gbt) {
            if (this._res == null) {
                this._res = gbt._res;
            } else if (gbt._res != null) {
                KeyInfo[] res = new KeyInfo[this._res.length + gbt._res.length];
                int j2 = 0;
                int k2 = 0;
                for (int i2 = 0; i2 < res.length; ++i2) {
                    res[i2] = j2 < gbt._res.length && (k2 == this._res.length || gbt._res[j2].compareTo(this._res[k2]) < 0) ? gbt._res[j2++] : this._res[k2++];
                }
                this._res = res;
            }
        }

        @Override
        public void postGlobal() {
            _cache = new KeySnapshot(this._res);
        }
    }

    public static final class KeyInfo
    extends Iced
    implements Comparable<KeyInfo> {
        public final Key _key;
        public final int _type;
        public final int _sz;
        public final byte _backEnd;

        public KeyInfo(Key k2, Value v2) {
            this._key = k2;
            this._type = v2.type();
            this._sz = v2._max;
            this._backEnd = v2.backend();
        }

        @Override
        public int compareTo(KeyInfo ki) {
            return this._key.compareTo(ki._key);
        }

        public boolean isFrame() {
            return this._type == TypeMap.FRAME;
        }

        public boolean isLockable() {
            return TypeMap.theFreezable(this._type) instanceof Lockable;
        }
    }

    public static abstract class KVFilter {
        public abstract boolean filter(KeyInfo var1);
    }
}

