/*
 * Decompiled with CFR 0.152.
 */
package water;

import java.util.concurrent.atomic.AtomicInteger;
import jsr166y.CountedCompleter;
import jsr166y.ForkJoinTask;
import water.H2O;
import water.Job;
import water.util.Log;

public class ParallelizationTask<T extends H2O.H2OCountedCompleter<T>>
extends H2O.H2OCountedCompleter {
    private final transient AtomicInteger _ctr;
    private final T[] _tasks;
    private final Job<?> _j;
    private final int _maxParallelTasks;

    public ParallelizationTask(T[] tasks, int maxParallelTasks, Job<?> j2) {
        if (maxParallelTasks <= 0) {
            throw new IllegalArgumentException("Argument maxParallelTasks should be a positive integer, got: " + maxParallelTasks);
        }
        this._maxParallelTasks = maxParallelTasks;
        this._ctr = new AtomicInteger(this._maxParallelTasks - 1);
        this._tasks = tasks;
        this._j = j2;
    }

    @Override
    public void compute2() {
        int nTasks = this._tasks.length;
        this.addToPendingCount(nTasks - 1);
        for (int i2 = 0; i2 < Math.min(this._maxParallelTasks, nTasks); ++i2) {
            this.asyncVecTask(i2);
        }
    }

    private void asyncVecTask(int task) {
        ((CountedCompleter)this._tasks[task]).setCompleter(new Callback(task));
        ((ForkJoinTask)this._tasks[task]).fork();
    }

    private void stopAll() {
        for (T task : this._tasks) {
            if (task == null) continue;
            ((ForkJoinTask)task).cancel(true);
        }
    }

    private class Callback
    extends H2O.H2OCallback {
        private final int _taskId;

        Callback(int taskId) {
            super(ParallelizationTask.this);
            this._taskId = taskId;
        }

        public void callback(H2O.H2OCountedCompleter cc) {
            ((ParallelizationTask)ParallelizationTask.this)._tasks[this._taskId] = null;
            if (ParallelizationTask.this._j != null && ParallelizationTask.this._j.stop_requested()) {
                int current = ParallelizationTask.this._ctr.get();
                Log.info("Skipping execution of last " + (ParallelizationTask.this._tasks.length - current) + " out of " + ParallelizationTask.this._tasks.length + " tasks.");
                ParallelizationTask.this.stopAll();
                throw new Job.JobCancelledException();
            }
            int i2 = ParallelizationTask.this._ctr.incrementAndGet();
            if (i2 < ParallelizationTask.this._tasks.length) {
                ParallelizationTask.this.asyncVecTask(i2);
            }
        }
    }
}

