/*
 * Decompiled with CFR 0.152.
 */
package water;

import water.H2O;
import water.Paxos;
import water.api.PingHandler;
import water.util.Log;

public class RestApiPingCheckThread
extends Thread {
    public RestApiPingCheckThread() {
        super("RestApiPingCheckThread");
        this.setDaemon(true);
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            if (Paxos._cloudLocked) {
                if (H2O.SELF == H2O.CLOUD.leader()) {
                    if (RestApiPingCheckThread.isTimeoutExceeded(PingHandler.lastAccessed, H2O.ARGS.rest_api_ping_timeout)) {
                        Log.fatal("Stopping H2O cluster since we haven't received any REST api request on 3/Ping!");
                        H2O.shutdown(-1);
                    }
                } else {
                    Thread.currentThread().interrupt();
                    continue;
                }
            }
            try {
                Thread.sleep(H2O.ARGS.rest_api_ping_timeout);
            }
            catch (InterruptedException e2) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static boolean isTimeoutExceeded(long lastHeardFrom, long timeout) {
        return System.currentTimeMillis() - lastHeardFrom >= timeout;
    }
}

