/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import java.io.InputStream;
import java.nio.charset.Charset;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import water.DKV;
import water.fvec.Frame;
import water.server.ServletUtils;
import water.util.FileUtils;
import water.util.Log;

public class DatasetServlet
extends HttpServlet {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void doGet(HttpServletRequest request2, HttpServletResponse response) {
        String uri = ServletUtils.getDecodedUri(request2);
        try {
            String suggested_fname;
            int x2;
            String f_name = request2.getParameter("frame_id");
            String hex_string = request2.getParameter("hex_string");
            String escape_quotes_string = request2.getParameter("escape_quotes");
            if (f_name == null) {
                throw new RuntimeException("Cannot find value for parameter 'frame_id'");
            }
            Frame dataset = (Frame)DKV.getGet(f_name);
            Frame.CSVStreamParams parms = new Frame.CSVStreamParams();
            if (hex_string != null) {
                parms.setHexString(Boolean.parseBoolean(hex_string));
            }
            if (escape_quotes_string != null) {
                parms.setEscapeQuotes(Boolean.parseBoolean(escape_quotes_string));
            }
            InputStream is = dataset.toCSV(parms);
            response.setContentType("application/octet-stream");
            response.setCharacterEncoding(Charset.defaultCharset().name());
            boolean dot = false;
            for (x2 = f_name.length() - 1; x2 >= 0; --x2) {
                if (Character.isLetterOrDigit(f_name.charAt(x2)) || f_name.charAt(x2) == '_') continue;
                if (f_name.charAt(x2) != '.' || dot) break;
                dot = true;
            }
            if (!(suggested_fname = f_name.substring(x2 + 1).replace(".hex", ".csv")).endsWith(".csv")) {
                suggested_fname = suggested_fname + ".csv";
            }
            f_name = suggested_fname;
            response.addHeader("Content-Disposition", "attachment; filename=" + f_name);
            ServletUtils.setResponseStatus(response, 200);
            ServletOutputStream os2 = null;
            try {
                os2 = response.getOutputStream();
                FileUtils.copyStream(is, os2, 2048);
                if (os2 == null) return;
            }
            catch (Throwable throwable) {
                if (os2 == null) throw throwable;
                try {
                    os2.close();
                    throw throwable;
                }
                catch (Exception e2) {
                    Log.err(e2);
                }
                throw throwable;
            }
            try {
                os2.close();
                return;
            }
            catch (Exception e3) {
                Log.err(e3);
            }
            return;
        }
        catch (Exception e4) {
            ServletUtils.sendErrorResponse(response, e4, uri);
            return;
        }
        finally {
            ServletUtils.logRequest("GET", request2, response);
        }
    }
}

