/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import water.api.ValuesProvider;

public class EnumValuesProvider<E extends Enum<E>>
implements ValuesProvider {
    private String[] _values;

    public EnumValuesProvider(Class<E> clazz) {
        this(clazz, e2 -> true);
    }

    public EnumValuesProvider(Class<E> clazz, Predicate<E> filter) {
        this._values = this.getValuesOf(clazz, filter);
    }

    public EnumValuesProvider(Class<E> clazz, E[] excluded) {
        List exclusions = Arrays.asList(excluded);
        this._values = this.getValuesOf(clazz, e2 -> !exclusions.contains(e2));
    }

    @Override
    public String[] values() {
        return this._values;
    }

    private String[] getValuesOf(Class<E> clazz, Predicate<E> filter) {
        Enum[] values = (Enum[])clazz.getEnumConstants();
        ArrayList<String> names = new ArrayList<String>(values.length);
        for (Enum val : values) {
            if (!filter.test(val)) continue;
            names.add(val.name());
        }
        return names.toArray(new String[0]);
    }
}

