/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import water.H2O;
import water.MRTask;
import water.api.Handler;
import water.api.schemas3.FindV3;
import water.api.schemas3.FrameV3;
import water.exceptions.H2OCategoricalLevelNotFoundArgumentException;
import water.exceptions.H2OColumnNotFoundArgumentException;
import water.exceptions.H2OIllegalArgumentException;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.ArrayUtils;
import water.util.IcedHashMapGeneric;

class FindHandler
extends Handler {
    FindHandler() {
    }

    public FindV3 find(int version, FindV3 find) {
        Frame frame = find.key._fr;
        if (find.column != null) {
            Vec vec = frame.vec(find.column);
            if (vec == null) {
                throw new H2OColumnNotFoundArgumentException("column", frame, find.column);
            }
            find.key = new FrameV3(new Frame(new String[]{find.column}, new Vec[]{vec}));
            frame = find.key._fr;
        }
        Vec[] vecs = frame.vecs();
        double[] ds = new double[vecs.length];
        for (int i2 = 0; i2 < vecs.length; ++i2) {
            if (vecs[i2].isCategorical()) {
                int idx = ArrayUtils.find(vecs[i2].domain(), find.match);
                if (idx == -1 && vecs.length == 1) {
                    throw new H2OCategoricalLevelNotFoundArgumentException("match", find.match, frame._key.toString(), frame.name(i2));
                }
                ds[i2] = idx;
                continue;
            }
            if (vecs[i2].isUUID()) {
                throw H2O.unimpl();
            }
            if (vecs[i2].isString()) {
                throw H2O.unimpl();
            }
            if (vecs[i2].isTime()) {
                throw H2O.unimpl();
            }
            try {
                ds[i2] = find.match == null ? Double.NaN : Double.parseDouble(find.match);
                continue;
            }
            catch (NumberFormatException e2) {
                if (vecs.length == 1) {
                    IcedHashMapGeneric.IcedHashMapStringObject values = new IcedHashMapGeneric.IcedHashMapStringObject();
                    String msg = "Frame: " + frame._key.toString() + " as only one column, it is numeric, and the find pattern is not numeric: " + find.match;
                    values.put("frame_name", frame._key.toString());
                    values.put("column_name", frame.name(i2));
                    values.put("pattern", find.match);
                    throw new H2OIllegalArgumentException(msg, msg, values);
                }
                ds[i2] = Double.longBitsToDouble(-889275714L);
            }
        }
        Find f2 = (Find)new Find(find.row, ds).doAll(frame);
        find.prev = f2._prev;
        find.next = f2._next == Long.MAX_VALUE ? -1L : f2._next;
        return find;
    }

    private static class Find
    extends MRTask<Find> {
        final long _row;
        final double[] _ds;
        long _prev;
        long _next;

        Find(long row, double[] ds) {
            super((byte)117);
            this._row = row;
            this._ds = ds;
            this._prev = -1L;
            this._next = Long.MAX_VALUE;
        }

        @Override
        public void map(Chunk[] cs) {
            for (int col = 0; col < cs.length; ++col) {
                Chunk C2 = cs[col];
                for (int row = 0; row < C2._len; ++row) {
                    if (C2.atd(row) != this._ds[col] && (!C2.isNA(row) || !Double.isNaN(this._ds[col]))) continue;
                    long r2 = C2.start() + (long)row;
                    if (r2 < this._row) {
                        if (r2 <= this._prev) continue;
                        this._prev = r2;
                        continue;
                    }
                    if (r2 <= this._row || r2 >= this._next) continue;
                    this._next = r2;
                }
            }
        }

        @Override
        public void reduce(Find f2) {
            if (this._prev < f2._prev) {
                this._prev = f2._prev;
            }
            if (this._next > f2._next) {
                this._next = f2._next;
            }
        }
    }
}

