/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import water.ExtensionManager;
import water.Job;
import water.api.Handler;
import water.api.schemas3.ImportHiveTableV3;
import water.api.schemas3.JobV3;
import water.fvec.Frame;

public class ImportHiveTableHandler
extends Handler {
    private HiveTableImporter getImporter() {
        return (HiveTableImporter)((Object)ExtensionManager.getInstance().getCoreExtension("HiveTableImporter"));
    }

    public JobV3 importHiveTable(int version, ImportHiveTableV3 request2) throws Exception {
        HiveTableImporter importer2 = this.getImporter();
        if (importer2 != null) {
            try {
                Job<Frame> job = importer2.loadHiveTable(request2.database, request2.table, request2.partitions, request2.allow_multi_format);
                return new JobV3(job);
            }
            catch (NoClassDefFoundError e2) {
                throw new IllegalStateException("Hive Metastore client classes not available on classpath, try specifying the database as JDBC URL.", e2);
            }
        }
        throw new IllegalStateException("HiveTableImporter extension not enabled.");
    }

    public static interface HiveTableImporter {
        public static final String DEFAULT_DATABASE = "default";
        public static final String NAME = "HiveTableImporter";

        public Job<Frame> loadHiveTable(String var1, String var2, String[][] var3, boolean var4) throws Exception;
    }
}

