/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import water.DKV;
import water.Job;
import water.Key;
import water.Value;
import water.api.Handler;
import water.api.RestApiHandler;
import water.api.SchemaServer;
import water.api.schemas3.JobV3;
import water.api.schemas3.JobsV3;
import water.api.schemas4.input.JobIV4;
import water.api.schemas4.output.JobV4;
import water.exceptions.H2ONotFoundArgumentException;
import water.server.ServletUtils;
import water.util.Log;

public class JobsHandler
extends Handler {
    public JobsV3 list(int version, JobsV3 s2) {
        Job[] jobs = Job.jobs();
        s2.jobs = new JobV3[jobs.length];
        int i2 = 0;
        for (Job j2 : jobs) {
            try {
                s2.jobs[i2] = (JobV3)SchemaServer.schema(version, j2).fillFromImpl(j2);
            }
            catch (H2ONotFoundArgumentException e2) {
                s2.jobs[i2] = new JobV3().fillFromImpl(j2);
            }
            ++i2;
        }
        return s2;
    }

    public JobsV3 fetch(int version, JobsV3 s2) {
        JobV3 job;
        Key<Job> key = s2.job_id.key();
        long waitingStartedAt = System.currentTimeMillis();
        long waitMs = JobsHandler.fetchJobTimeoutMs();
        Job<?> j2 = Job.tryGetDoneJob(key, waitMs);
        long waitingEndedAt = System.currentTimeMillis();
        if (Log.isLoggingFor(5)) {
            Log.trace("Waited for job result for " + (waitingEndedAt - waitingStartedAt) + "ms.");
        }
        try {
            job = (JobV3)SchemaServer.schema(version, j2);
        }
        catch (H2ONotFoundArgumentException e2) {
            job = new JobV3().fillFromImpl(j2);
        }
        job.fillFromImpl(j2);
        s2.jobs = new JobV3[1];
        s2.jobs[0] = job;
        return s2;
    }

    static long fetchJobTimeoutMs() {
        String timeoutSpec = ServletUtils.getSessionProperty("job.fetch_timeout_ms", null);
        if (timeoutSpec == null) {
            return -1L;
        }
        try {
            return Long.parseLong(timeoutSpec);
        }
        catch (Exception e2) {
            Log.trace(e2);
            return -1L;
        }
    }

    public JobsV3 cancel(int version, JobsV3 c2) {
        long start;
        block3: {
            Job j2 = (Job)DKV.getGet(c2.job_id.key());
            if (j2 == null) {
                throw new IllegalArgumentException("No job with key " + c2.job_id.key());
            }
            j2.stop();
            start = System.currentTimeMillis();
            Log.info("Waiting for job " + c2.job_id.key() + " to finish execution.");
            try {
                j2.get();
            }
            catch (Exception e2) {
                if (Job.isCancelledException(e2)) break block3;
                Log.warn("Job was cancelled with exception", e2);
            }
        }
        long took = System.currentTimeMillis() - start;
        Log.info("Job " + c2.job_id.key() + " cancelled (waiting took=" + took + "ms).");
        return c2;
    }

    public static class FetchJob
    extends RestApiHandler<JobIV4, JobV4> {
        @Override
        public String name() {
            return "getJob4";
        }

        @Override
        public String help() {
            return "Retrieve information about the current state of a job.";
        }

        @Override
        public JobV4 exec(int ignored, JobIV4 input) {
            Key key = Key.make(input.job_id);
            Value val = DKV.get(key);
            if (val == null) {
                throw new IllegalArgumentException("Job " + input.job_id + " is missing");
            }
            Object iced = val.get();
            if (!(iced instanceof Job)) {
                throw new IllegalArgumentException("Id " + input.job_id + " references a " + iced.getClass() + " not a Job");
            }
            Job job = (Job)iced;
            JobV4 out = new JobV4();
            out.fillFromImpl(job);
            return out;
        }
    }
}

