/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import water.DKV;
import water.Key;
import water.api.Handler;
import water.api.schemas3.JobV3;
import water.api.schemas3.ParseSVMLightV3;
import water.api.schemas3.ParseV3;
import water.exceptions.H2OIllegalArgumentException;
import water.fvec.Frame;
import water.parser.ParseDataset;
import water.parser.ParseSetup;
import water.parser.ParseWriter;
import water.parser.ParserInfo;
import water.parser.ParserService;

class ParseHandler
extends Handler {
    ParseHandler() {
    }

    public ParseV3 parse(int version, ParseV3 parse2) {
        ParserInfo parserInfo = ParserService.INSTANCE.getByName(parse2.parse_type).info();
        ParseSetup setup = new ParseSetup(parserInfo, parse2.separator, parse2.single_quotes, parse2.check_header, parse2.number_columns, ParseHandler.delNulls(parse2.column_names), ParseSetup.strToColumnTypes(parse2.column_types), parse2.domains, parse2.na_strings, null, new ParseWriter.ParseErr[]{}, parse2.chunk_size, parse2.decrypt_tool != null ? parse2.decrypt_tool.key() : null, parse2.skipped_columns, parse2.custom_non_data_line_markers != null ? parse2.custom_non_data_line_markers.getBytes() : null, parse2.escapechar);
        if (parse2.source_frames == null) {
            throw new H2OIllegalArgumentException("Data for Frame '" + parse2.destination_frame.name + "' is not available. Please check that the path is valid (for all H2O nodes).'");
        }
        Key[] srcs = new Key[parse2.source_frames.length];
        for (int i2 = 0; i2 < parse2.source_frames.length; ++i2) {
            srcs[i2] = parse2.source_frames[i2].key();
        }
        if (parse2.partition_by != null) {
            String[][] partitionValues = ParseHandler.syntheticColumValuesFromPartitions(parse2.partition_by, srcs);
            setup.setSyntheticColumns(parse2.partition_by, partitionValues, (byte)4);
        }
        if ((setup.getParseType().name().toLowerCase().equals("svmlight") || setup.getParseType().name().toLowerCase().equals("avro")) && setup.getSkippedColumns() != null && setup.getSkippedColumns().length > 0) {
            throw new H2OIllegalArgumentException("Parser: skipped_columns are not supported for SVMlight or Avro parsers.");
        }
        if (setup.getSkippedColumns() != null && (setup.get_parse_columns_indices() == null || setup.get_parse_columns_indices().length == 0)) {
            throw new H2OIllegalArgumentException("Parser:  all columns in the file are skipped and no H2OFrame can be returned.");
        }
        parse2.job = new JobV3(ParseDataset.parse(parse2.destination_frame.key(), (Key[])srcs, (boolean)parse2.delete_on_done, (ParseSetup)setup, (boolean)parse2.blocking)._job);
        if (parse2.blocking) {
            Frame fr = (Frame)DKV.getGet(parse2.destination_frame.key());
            parse2.rows = fr.numRows();
        }
        return parse2;
    }

    private static String[][] syntheticColumValuesFromPartitions(String[] partitionColumnNames, Key[] fileKeys) throws IllegalArgumentException {
        String[][] values = new String[fileKeys.length][partitionColumnNames.length];
        for (int fileIndex = 0; fileIndex < fileKeys.length; ++fileIndex) {
            for (int partitionIndex = 0; partitionIndex < partitionColumnNames.length; ++partitionIndex) {
                String partitionValue;
                Matcher matcher = Pattern.compile(partitionColumnNames[partitionIndex] + "=([^\\/\\\\]+)").matcher(fileKeys[fileIndex].toString());
                if (!matcher.find()) {
                    throw new IllegalArgumentException(String.format("Unable to find partition column '%s' in file key '%s'", partitionColumnNames[partitionIndex], fileKeys[fileIndex].toString()));
                }
                values[fileIndex][partitionIndex] = partitionValue = matcher.group(1);
            }
        }
        return values;
    }

    private static String[] delNulls(String[] names) {
        if (names == null) {
            return null;
        }
        for (int i2 = 0; i2 < names.length; ++i2) {
            if (!names[i2].equals("null")) continue;
            names[i2] = null;
        }
        return names;
    }

    public JobV3 parseSVMLight(int version, ParseSVMLightV3 parse2) {
        Key<Frame> destKey;
        Key[] fkeys = new Key[parse2.source_frames.length];
        for (int i2 = 0; i2 < fkeys.length; ++i2) {
            fkeys[i2] = parse2.source_frames[i2].key();
        }
        Key<Object> key = destKey = parse2.destination_frame == null ? null : parse2.destination_frame.key();
        if (destKey == null) {
            destKey = Key.make(ParseSetup.createHexName(parse2.source_frames[0].toString()));
        }
        ParseSetup setup = ParseSetup.guessSetup(fkeys, ParseSetup.makeSVMLightSetup());
        return new JobV3().fillFromImpl(ParseDataset.forkParseSVMLight(destKey, fkeys, setup));
    }
}

