/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import water.DKV;
import water.Key;
import water.api.Handler;
import water.api.schemas3.KeyV3;
import water.api.schemas3.ParseSetupV3;
import water.exceptions.H2OIllegalArgumentException;
import water.parser.DefaultParserProviders;
import water.parser.ParseDataset;
import water.parser.ParseSetup;
import water.util.DistributedException;
import water.util.PojoUtils;

public class ParseSetupHandler
extends Handler {
    public ParseSetupV3 guessSetup(int version, ParseSetupV3 p2) {
        ParseSetup ps;
        int i2;
        if (p2.source_frames == null || p2.source_frames.length == 0) {
            throw new H2OIllegalArgumentException("No file names given for parsing.");
        }
        Key[] fkeys = new Key[p2.source_frames.length];
        for (i2 = 0; i2 < p2.source_frames.length; ++i2) {
            fkeys[i2] = p2.source_frames[i2].key();
            if (DKV.get(fkeys[i2]) != null) continue;
            throw new IllegalArgumentException("Key not loaded: " + p2.source_frames[i2]);
        }
        if (p2.na_strings != null) {
            for (i2 = 0; i2 < p2.na_strings.length; ++i2) {
                if (p2.na_strings[i2] == null || p2.na_strings[i2].length != 0) continue;
                p2.na_strings[i2] = null;
            }
        }
        this.checkPartitionByColumnPresence(p2.source_frames, p2.partition_by);
        try {
            ps = new ParseSetup(p2);
            ps = ParseSetup.guessSetup(fkeys, ps);
        }
        catch (Throwable ex) {
            Throwable ex2 = ex;
            if (ex instanceof DistributedException) {
                ex2 = ex.getCause();
            }
            if (ex2 instanceof ParseDataset.H2OParseException) {
                throw new H2OIllegalArgumentException(ex2.getMessage());
            }
            throw ex;
        }
        ps.setSkippedColumns(p2.skipped_columns);
        ps.setParseColumnIndices(ps.getNumberColumns(), ps.getSkippedColumns());
        if (ps.errs() != null && ps.errs().length > 0) {
            p2.warnings = new String[ps.errs().length];
            for (int i3 = 0; i3 < ps.errs().length; ++i3) {
                p2.warnings[i3] = ps.errs().toString();
            }
        }
        if ((null == p2.column_name_filter || "".equals(p2.column_name_filter)) && 0 == p2.column_offset && 0 == p2.column_count) {
            PojoUtils.copyProperties(p2, ps, PojoUtils.FieldNaming.ORIGIN_HAS_UNDERSCORES, new String[]{"destination_key", "source_keys", "column_types", "parse_type"});
            p2.total_filtered_column_count = p2.number_columns;
        } else {
            PojoUtils.copyProperties(p2, ps, PojoUtils.FieldNaming.ORIGIN_HAS_UNDERSCORES, new String[]{"destination_key", "source_keys", "column_types", "data", "parse_type"});
            String[] all_col_names = ps.getColumnNames();
            String[][] data = ps.getData();
            ArrayList<Integer> keep_indexes = new ArrayList<Integer>();
            if (null != p2.column_name_filter && !"".equals(p2.column_name_filter)) {
                Pattern pattern = Pattern.compile(p2.column_name_filter);
                Matcher m4 = pattern.matcher("dummy");
                for (int column = 0; column < all_col_names.length; ++column) {
                    m4.reset(all_col_names[column]);
                    if (!m4.matches()) continue;
                    keep_indexes.add(column);
                }
            } else {
                for (int column = 0; column < all_col_names.length; ++column) {
                    keep_indexes.add(column);
                }
            }
            int width_to_return = Math.max(0, keep_indexes.size() - p2.column_offset);
            if (p2.column_count > 0) {
                width_to_return = Math.min(width_to_return, p2.column_count);
            }
            String[][] filtered_data = new String[data.length][width_to_return];
            for (int row = 0; row < data.length; ++row) {
                int output_column = 0;
                for (int input_column_index = p2.column_offset; input_column_index < p2.column_offset + width_to_return; ++input_column_index) {
                    filtered_data[row][output_column++] = data[row][(Integer)keep_indexes.get(input_column_index)];
                }
            }
            p2.data = filtered_data;
            p2.total_filtered_column_count = keep_indexes.size();
        }
        p2.destination_frame = ParseSetup.createHexName(p2.source_frames[0].toString());
        if (p2.check_header == 1 && p2.data != null && Arrays.equals(p2.column_names, p2.data[0])) {
            p2.data = (String[][])Arrays.copyOfRange(p2.data, 1, p2.data.length);
        }
        p2.column_types = ps.getColumnTypeStrings();
        p2.parse_type = ps.getParseType() != null ? ps.getParseType().name() : DefaultParserProviders.GUESS_INFO.name();
        return p2;
    }

    private void checkPartitionByColumnPresence(KeyV3.FrameKeyV3[] sourceFrames, String[] partitionByColumns) {
        if (partitionByColumns == null || partitionByColumns.length == 0) {
            return;
        }
        HashMap<String, String> nonMatchingKeys = new HashMap<String, String>();
        for (String partitionColumn : partitionByColumns) {
            Pattern pattern = Pattern.compile(".*" + partitionColumn + "=([^\\/\\\\]+).*");
            for (int i2 = 0; i2 < sourceFrames.length; ++i2) {
                String framePath = sourceFrames[i2].key().toString();
                Matcher matcher = pattern.matcher(framePath);
                if (matcher.matches()) continue;
                nonMatchingKeys.put(framePath, partitionColumn);
            }
        }
        if (nonMatchingKeys.size() == 0) {
            return;
        }
        StringBuilder errMsgBuilder = new StringBuilder("The following files do not contain required partitionBy columns on their path: ");
        nonMatchingKeys.entrySet().forEach(nonMatching -> {
            errMsgBuilder.append('\n');
            errMsgBuilder.append("File: ");
            errMsgBuilder.append((String)nonMatching.getKey());
            errMsgBuilder.append(" | Missing column: ");
            errMsgBuilder.append((String)nonMatching.getValue());
        });
        throw new IllegalArgumentException(errMsgBuilder.toString());
    }
}

