/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import water.DKV;
import water.Key;
import water.Value;
import water.server.ServletUtils;

public class PutKeyServlet
extends HttpServlet {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doPost(HttpServletRequest request2, HttpServletResponse response) {
        String uri = ServletUtils.getDecodedUri(request2);
        try {
            String destKey = this.paramDestinationKey(request2, response);
            Boolean overwrite = this.paramOverwrite(request2, response, true);
            if (!this.validate(destKey, overwrite, response)) {
                return;
            }
            InputStream is = ServletUtils.extractPartInputStream(request2, response);
            if (is == null) {
                return;
            }
            Key key = Key.make(destKey);
            int bytesStored = -1;
            if (DKV.get(key) == null || overwrite.booleanValue()) {
                byte[] ba = IOUtils.toByteArray((InputStream)is);
                DKV.put(key, new Value(key, ba));
                bytesStored = ba.length;
            }
            String responsePayload = "{ \"destination_key\": \"" + destKey + "\", \"total_bytes\": " + bytesStored + " }\n";
            response.setContentType("application/json");
            response.getWriter().write(responsePayload);
        }
        catch (Exception e2) {
            ServletUtils.sendErrorResponse(response, e2, uri);
        }
        finally {
            ServletUtils.logRequest("POST", request2, response);
        }
    }

    private String paramDestinationKey(HttpServletRequest request2, HttpServletResponse response) {
        String keyName = request2.getParameter("destination_key");
        return keyName != null ? keyName : "func_" + Key.rand();
    }

    private Boolean paramOverwrite(HttpServletRequest request2, HttpServletResponse response, boolean defaultValue) {
        String val = request2.getParameter("overwrite");
        return val != null ? Boolean.valueOf(val) : defaultValue;
    }

    private boolean validate(String destKey, Boolean overwrite, HttpServletResponse response) throws IOException {
        if (destKey == null) {
            ServletUtils.sendResponseError(response, 400, "The field 'destination_frame` is compulsory!");
            return false;
        }
        return true;
    }
}

