/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import water.DKV;
import water.Job;
import water.Key;
import water.KeySnapshot;
import water.Lockable;
import water.MRTask;
import water.Value;
import water.util.Log;

public class UnlockTask
extends MRTask<UnlockTask> {
    final boolean _quiet;

    public UnlockTask() {
        super((byte)119);
        this._quiet = false;
    }

    public UnlockTask(boolean q2) {
        super((byte)119);
        this._quiet = q2;
    }

    @Override
    public void setupLocal() {
        KeySnapshot.KeyInfo[] kinfo;
        for (KeySnapshot.KeyInfo k2 : kinfo = KeySnapshot.localSnapshot((boolean)true)._keyInfos) {
            Value val;
            if (!k2.isLockable() || (val = DKV.get(k2._key)) == null) continue;
            Lockable lockable = (Lockable)val.get();
            Key<Job>[] lockers = lockable._lockers;
            if (lockers == null) continue;
            for (Key<Job> locker : lockers) {
                Job job;
                if (locker == null || locker.type() != 3 || (job = locker.get()) == null || !job.isRunning()) continue;
                throw new UnsupportedOperationException("Cannot unlock all keys since locking jobs are still running.");
            }
            lockable.unlock_all();
            Log.info("Unlocked key '" + k2._key + "' from " + lockers.length + " lockers.");
        }
        if (!this._quiet) {
            Log.info("All keys are now unlocked.");
        }
    }
}

