/*
 * Decompiled with CFR 0.152.
 */
package water.automl.api.schemas3;

import ai.h2o.automl.leaderboard.Leaderboard;
import java.util.stream.Stream;
import water.Key;
import water.api.API;
import water.api.schemas3.KeyV3;
import water.api.schemas3.SchemaV3;
import water.api.schemas3.TwoDimTableV3;
import water.fvec.Frame;

public class LeaderboardV99
extends SchemaV3<Leaderboard, LeaderboardV99> {
    @API(help="Identifier for models that should be grouped together in the leaderboard", direction=API.Direction.INOUT)
    public final String project_name = "<default>";
    @API(help="List of models for this leaderboard, sorted by metric so that the best is first", direction=API.Direction.OUTPUT)
    public KeyV3.ModelKeyV3[] models;
    @API(help="Frame for this leaderboard", direction=API.Direction.OUTPUT)
    public KeyV3.FrameKeyV3 leaderboard_frame;
    @API(help="Checksum for the Frame for this leaderboard", direction=API.Direction.OUTPUT)
    public long leaderboard_frame_checksum;
    @API(help="Sort metrics for the models in this leaderboard, in the same order as the models", direction=API.Direction.OUTPUT)
    public double[] sort_metrics;
    @API(help="Metric used to sort this leaderboard", direction=API.Direction.INOUT)
    public String sort_metric;
    @API(help="Metric direction used in the sort", direction=API.Direction.INOUT)
    public boolean sort_decreasing;
    @API(help="A table representation of this leaderboard, for easy rendering", direction=API.Direction.OUTPUT)
    public TwoDimTableV3 table;

    @Override
    public LeaderboardV99 fillFromImpl(Leaderboard leaderboard) {
        super.fillFromImpl(leaderboard, new String[]{"models", "leaderboard_frame", "sort_metrics", "sort_decreasing"});
        this.models = (KeyV3.ModelKeyV3[])Stream.of(leaderboard.getModelKeys()).map(KeyV3.ModelKeyV3::new).toArray(KeyV3.ModelKeyV3[]::new);
        if (leaderboard.leaderboardFrame() != null) {
            this.leaderboard_frame = new KeyV3.FrameKeyV3((Key<Frame>)leaderboard.leaderboardFrame()._key);
        }
        this.sort_metrics = leaderboard.getSortMetricValues();
        this.sort_decreasing = !Leaderboard.isLossFunction(this.sort_metric);
        this.table = new TwoDimTableV3().fillFromImpl(leaderboard.toTwoDimTable(new String[0]));
        return this;
    }
}

