/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import java.util.UUID;
import water.fvec.Chunk;
import water.fvec.ChunkVisitor;
import water.parser.BufferedString;
import water.util.UnsafeUtils;

public class C0DChunk
extends Chunk {
    private static final int _OFF = 12;
    private double _con;

    public C0DChunk(double con, int len) {
        this._start = -1L;
        this.set_len(len);
        this._mem = new byte[12];
        this._con = con;
        UnsafeUtils.set8d(this._mem, 0, con);
        UnsafeUtils.set4(this._mem, 8, len);
    }

    @Override
    public boolean hasFloat() {
        return !Double.isNaN(this._con);
    }

    @Override
    protected final long at8_impl(int i2) {
        if (Double.isNaN(this._con)) {
            throw new IllegalArgumentException("at8_abs but value is missing");
        }
        return (long)this._con;
    }

    @Override
    long at16h_impl(int idx) {
        throw C0DChunk.wrongType(UUID.class, Object.class);
    }

    @Override
    protected final double atd_impl(int i2) {
        return this._con;
    }

    @Override
    protected final boolean isNA_impl(int i2) {
        return Double.isNaN(this._con);
    }

    @Override
    boolean set_impl(int idx, long l2) {
        return (double)l2 == this._con;
    }

    @Override
    boolean set_impl(int i2, double d2) {
        return d2 == this._con;
    }

    @Override
    boolean set_impl(int i2, float f2) {
        return (double)f2 == this._con;
    }

    @Override
    boolean setNA_impl(int i2) {
        return Double.isNaN(this._con);
    }

    @Override
    double min() {
        return this._con;
    }

    @Override
    double max() {
        return this._con;
    }

    @Override
    BufferedString atStr_impl(BufferedString bStr, int idx) {
        if (Double.isNaN(this._con)) {
            return null;
        }
        return super.atStr_impl(bStr, idx);
    }

    @Override
    public final void initFromBytes() {
        this._start = -1L;
        this._cidx = -1;
        this._con = UnsafeUtils.get8d(this._mem, 0);
        this.set_len(UnsafeUtils.get4(this._mem, 8));
    }

    @Override
    public boolean isSparseZero() {
        return this._con == 0.0;
    }

    @Override
    public int sparseLenZero() {
        return this._con == 0.0 ? 0 : this._len;
    }

    @Override
    public int nextNZ(int rid) {
        return this._con == 0.0 ? this._len : rid + 1;
    }

    @Override
    public int nonzeros(int[] arr) {
        if (this._con == 0.0) {
            return 0;
        }
        for (int i2 = 0; i2 < this._len; ++i2) {
            arr[i2] = i2;
        }
        return this._len;
    }

    @Override
    public boolean isSparseNA() {
        return Double.isNaN(this._con);
    }

    @Override
    public int sparseLenNA() {
        return Double.isNaN(this._con) ? 0 : this._len;
    }

    @Override
    public int getSparseDoubles(double[] vals, int[] ids, double NA2) {
        if (this._con == 0.0) {
            return 0;
        }
        double con = Double.isNaN(this._con) ? NA2 : this._con;
        for (int i2 = 0; i2 < this._len; ++i2) {
            vals[i2] = con;
            ids[i2] = i2;
        }
        return this._len;
    }

    @Override
    public <T extends ChunkVisitor> T processRows(T v2, int from, int to) {
        if (this._con == 0.0) {
            v2.addZeros(to - from);
        } else if (Double.isNaN(this._con)) {
            v2.addNAs(to - from);
        } else {
            for (int i2 = from; i2 < to; ++i2) {
                v2.addValue(this._con);
            }
        }
        return v2;
    }

    @Override
    public <T extends ChunkVisitor> T processRows(T v2, int[] ids) {
        if (this._con == 0.0) {
            v2.addZeros(ids.length);
        } else if (Double.isNaN(this._con)) {
            v2.addNAs(ids.length);
        } else {
            for (int i2 = 0; i2 < ids.length; ++i2) {
                v2.addValue(this._con);
            }
        }
        return v2;
    }
}

