/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import water.fvec.CSChunk;
import water.fvec.ChunkVisitor;
import water.util.PrettyPrint;

public final class C1SChunk
extends CSChunk {
    C1SChunk(byte[] bs, long bias, int scale) {
        super(bs, bias, scale, 0);
        if (scale < 0) {
            double div = PrettyPrint.pow10(1L, -scale);
            for (int i2 = 0; i2 < this._len; ++i2) {
                int x2 = 0xFF & this._mem[16 + i2];
                if (x2 == 255 || this.getD(x2, 255, Double.NaN) == (double)((long)x2 + bias) / div) continue;
                this.setDecimal();
                break;
            }
        }
    }

    @Override
    protected final long at8_impl(int i2) {
        int x2 = 0xFF & this._mem[16 + i2];
        if (x2 == 255) {
            throw new IllegalArgumentException("at8_abs but value is missing");
        }
        return this.get8(x2);
    }

    @Override
    protected final double atd_impl(int i2) {
        return this.getD(0xFF & this._mem[16 + i2], 255);
    }

    @Override
    protected final boolean isNA_impl(int i2) {
        return (0xFF & this._mem[i2 + 16]) == 255;
    }

    @Override
    boolean setNA_impl(int idx) {
        this._mem[idx + 16] = -1;
        return true;
    }

    @Override
    protected boolean set_impl(int i2, double x2) {
        if (Double.isNaN(x2)) {
            return this.setNA_impl(i2);
        }
        int y2 = this.getScaledValue(x2, 255);
        byte b2 = (byte)y2;
        if (this.getD(0xFF & b2, 255, Double.NaN) != x2) {
            return false;
        }
        this._mem[16 + i2] = b2;
        assert (!this.isNA_impl(i2));
        return true;
    }

    @Override
    public double[] getDoubles(double[] vals, int from, int to, double NA2) {
        for (int i2 = from; i2 < to; ++i2) {
            vals[i2 - from] = this.getD(0xFF & this._mem[16 + i2], 255, NA2);
        }
        return vals;
    }

    @Override
    public double[] getDoubles(double[] vals, int[] ids) {
        int j2 = 0;
        for (int i2 : ids) {
            vals[j2++] = this.getD(0xFF & this._mem[16 + i2], 255);
        }
        return vals;
    }

    private <T extends ChunkVisitor> void processRow(T v2, int i2, long bias, int exp) {
        long x2 = 0xFF & this._mem[16 + i2];
        if (x2 == 255L) {
            v2.addNAs(1);
        } else {
            v2.addValue(x2 + bias, exp);
        }
    }

    @Override
    protected <T extends ChunkVisitor> T processRows2(T v2, int from, int to, long bias, int exp) {
        for (int i2 = from; i2 < to; ++i2) {
            this.processRow(v2, i2, bias, exp);
        }
        return v2;
    }

    @Override
    protected <T extends ChunkVisitor> T processRows2(T v2, int from, int to) {
        for (int i2 = from; i2 < to; ++i2) {
            v2.addValue(this.getD(0xFF & this._mem[16 + i2], 255));
        }
        return v2;
    }

    @Override
    protected <T extends ChunkVisitor> T processRows2(T v2, int[] ids, long bias, int exp) {
        for (int i2 : ids) {
            this.processRow(v2, i2, bias, exp);
        }
        return v2;
    }

    @Override
    protected <T extends ChunkVisitor> T processRows2(T v2, int[] ids) {
        for (int i2 : ids) {
            v2.addValue(this.getD(0xFF & this._mem[16 + i2], 255));
        }
        return v2;
    }
}

