/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import water.fvec.Chunk;
import water.fvec.ChunkVisitor;
import water.util.UnsafeUtils;

public class C2Chunk
extends Chunk {
    protected static final int _NA = Short.MIN_VALUE;
    protected static final int _OFF = 0;

    C2Chunk(byte[] bs) {
        this._mem = bs;
        this._start = -1L;
        this.set_len(this._mem.length >> 1);
    }

    @Override
    protected final long at8_impl(int i2) {
        int res = UnsafeUtils.get2(this._mem, (i2 << 1) + 0);
        if (res == Short.MIN_VALUE) {
            throw new IllegalArgumentException("at8_abs but value is missing");
        }
        return res;
    }

    @Override
    protected final double atd_impl(int i2) {
        int res = UnsafeUtils.get2(this._mem, (i2 << 1) + 0);
        return res == Short.MIN_VALUE ? Double.NaN : (double)res;
    }

    @Override
    protected final boolean isNA_impl(int i2) {
        return UnsafeUtils.get2(this._mem, (i2 << 1) + 0) == Short.MIN_VALUE;
    }

    @Override
    boolean set_impl(int idx, long l2) {
        if (-32768L >= l2 || l2 > 32767L) {
            return false;
        }
        UnsafeUtils.set2(this._mem, (idx << 1) + 0, (short)l2);
        return true;
    }

    @Override
    boolean set_impl(int idx, double d2) {
        if (Double.isNaN(d2)) {
            return this.setNA_impl(idx);
        }
        long l2 = (long)d2;
        return (double)l2 == d2 && this.set_impl(idx, l2);
    }

    @Override
    boolean set_impl(int i2, float f2) {
        return this.set_impl(i2, (double)f2);
    }

    @Override
    boolean setNA_impl(int idx) {
        UnsafeUtils.set2(this._mem, (idx << 1) + 0, (short)Short.MIN_VALUE);
        return true;
    }

    private final void processRow(int r2, ChunkVisitor v2) {
        int i2 = UnsafeUtils.get2(this._mem, (r2 << 1) + 0);
        if (i2 == Short.MIN_VALUE) {
            v2.addNAs(1);
        } else {
            v2.addValue(i2);
        }
    }

    @Override
    public double[] getDoubles(double[] vals, int from, int to, double NA2) {
        for (int i2 = from; i2 < to; ++i2) {
            int x2 = UnsafeUtils.get2(this._mem, 2 * i2);
            vals[i2 - from] = x2 == Short.MIN_VALUE ? NA2 : (double)x2;
        }
        return vals;
    }

    @Override
    public double[] getDoubles(double[] vals, int[] ids) {
        int k2 = 0;
        for (int i2 : ids) {
            int x2 = UnsafeUtils.get2(this._mem, 2 * i2);
            vals[k2++] = x2 == Short.MIN_VALUE ? Double.NaN : (double)x2;
        }
        return vals;
    }

    @Override
    public int[] getIntegers(int[] vals, int from, int to, int NA2) {
        for (int i2 = from; i2 < to; ++i2) {
            int x2 = UnsafeUtils.get2(this._mem, 2 * i2);
            vals[i2 - from] = x2 == Short.MIN_VALUE ? NA2 : x2;
        }
        return vals;
    }

    @Override
    public <T extends ChunkVisitor> T processRows(T v2, int from, int to) {
        for (int i2 = from; i2 < to; ++i2) {
            this.processRow(i2, v2);
        }
        return v2;
    }

    @Override
    public <T extends ChunkVisitor> T processRows(T v2, int[] ids) {
        for (int i2 : ids) {
            this.processRow(i2, v2);
        }
        return v2;
    }

    @Override
    public final void initFromBytes() {
        this._start = -1L;
        this._cidx = -1;
        this.set_len(this._mem.length >> 1);
        assert (this._mem.length == this._len << 1);
    }

    @Override
    public boolean hasFloat() {
        return false;
    }
}

