/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import water.fvec.Chunk;
import water.fvec.ChunkVisitor;
import water.fvec.NewChunk;
import water.util.UnsafeUtils;

public class C4FChunk
extends Chunk {
    public C4FChunk(byte[] bs) {
        this._mem = bs;
        this._start = -1L;
        this.set_len(this._mem.length >> 2);
    }

    @Override
    protected final long at8_impl(int i2) {
        float res = UnsafeUtils.get4f(this._mem, i2 << 2);
        if (Float.isNaN(res)) {
            throw new IllegalArgumentException("at8_abs but value is missing");
        }
        return (long)res;
    }

    @Override
    protected final double atd_impl(int i2) {
        float res = UnsafeUtils.get4f(this._mem, i2 << 2);
        return Float.isNaN(res) ? Double.NaN : (double)res;
    }

    @Override
    protected final boolean isNA_impl(int i2) {
        return Float.isNaN(UnsafeUtils.get4f(this._mem, i2 << 2));
    }

    @Override
    boolean set_impl(int idx, long l2) {
        return false;
    }

    @Override
    boolean set_impl(int i2, double d2) {
        return false;
    }

    @Override
    boolean set_impl(int i2, float f2) {
        UnsafeUtils.set4f(this._mem, i2 << 2, f2);
        return true;
    }

    @Override
    boolean setNA_impl(int idx) {
        UnsafeUtils.set4f(this._mem, idx << 2, Float.NaN);
        return true;
    }

    @Override
    public NewChunk extractRows(NewChunk nc, int from, int to) {
        for (int i2 = from; i2 < to; ++i2) {
            nc.addNum(UnsafeUtils.get4f(this._mem, 4 * i2));
        }
        return nc;
    }

    @Override
    public NewChunk extractRows(NewChunk nc, int ... rows) {
        for (int i2 : rows) {
            nc.addNum(UnsafeUtils.get4f(this._mem, 4 * i2));
        }
        return nc;
    }

    private final void processRow(int r2, ChunkVisitor v2) {
        float f2 = UnsafeUtils.get4f(this._mem, r2 << 2);
        if (Float.isNaN(f2)) {
            v2.addNAs(1);
        } else {
            v2.addValue(f2);
        }
    }

    @Override
    public <T extends ChunkVisitor> T processRows(T v2, int from, int to) {
        for (int i2 = from; i2 < to; ++i2) {
            this.processRow(i2, v2);
        }
        return v2;
    }

    @Override
    public <T extends ChunkVisitor> T processRows(T v2, int[] ids) {
        for (int i2 : ids) {
            this.processRow(i2, v2);
        }
        return v2;
    }

    @Override
    public final void initFromBytes() {
        this._start = -1L;
        this._cidx = -1;
        this.set_len(this._mem.length >> 2);
        assert (this._mem.length == this._len << 2);
    }

    @Override
    public boolean hasFloat() {
        return true;
    }
}

