/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import water.DKV;
import water.Futures;
import water.MemoryManager;
import water.Value;
import water.fvec.Chunk;
import water.fvec.ChunkVisitor;
import water.util.UnsafeUtils;

public class C4VolatileChunk
extends Chunk {
    protected static final long _NA = Integer.MIN_VALUE;
    private transient int[] _is;

    C4VolatileChunk(int[] is) {
        this._is = is;
        this._mem = new byte[0];
        this._start = -1L;
        this._len = is.length;
    }

    @Override
    public boolean isVolatile() {
        return true;
    }

    public int[] getValues() {
        return this._is;
    }

    @Override
    protected final long at8_impl(int i2) {
        long res = this._is[i2];
        if (res == Integer.MIN_VALUE) {
            throw new IllegalArgumentException("at8_abs but value is missing");
        }
        return res;
    }

    @Override
    protected final double atd_impl(int i2) {
        long res = this._is[i2];
        return res == Integer.MIN_VALUE ? Double.NaN : (double)res;
    }

    @Override
    protected final boolean isNA_impl(int i2) {
        return (long)this._is[i2] == Integer.MIN_VALUE;
    }

    @Override
    boolean set_impl(int idx, long l2) {
        if (Integer.MIN_VALUE >= l2 || l2 > Integer.MAX_VALUE) {
            return false;
        }
        this._is[idx] = (int)l2;
        return true;
    }

    @Override
    boolean set_impl(int i2, double d2) {
        return false;
    }

    @Override
    boolean set_impl(int i2, float f2) {
        return false;
    }

    @Override
    boolean setNA_impl(int idx) {
        this._is[idx] = Integer.MIN_VALUE;
        return true;
    }

    private final void processRow(int r2, ChunkVisitor v2) {
        int i2 = UnsafeUtils.get4(this._mem, r2 << 2);
        if ((long)i2 == Integer.MIN_VALUE) {
            v2.addNAs(1);
        } else {
            v2.addValue(i2);
        }
    }

    @Override
    public <T extends ChunkVisitor> T processRows(T v2, int from, int to) {
        for (int i2 = from; i2 < to; ++i2) {
            this.processRow(i2, v2);
        }
        return v2;
    }

    @Override
    public <T extends ChunkVisitor> T processRows(T v2, int[] ids) {
        for (int i2 : ids) {
            this.processRow(i2, v2);
        }
        return v2;
    }

    @Override
    public final void initFromBytes() {
        this._len = this._mem.length >> 2;
        this._is = MemoryManager.malloc4(this._len);
        for (int i2 = 0; i2 < this._is.length; ++i2) {
            this._is[i2] = UnsafeUtils.get4(this._mem, 4 * i2);
        }
        this._mem = null;
    }

    @Override
    public Futures close(int cidx, Futures fs) {
        if (this.chk2() != null) {
            return this.chk2().close(cidx, fs);
        }
        Value v2 = new Value(this._vec.chunkKey(cidx), this, this._len * 4, 1);
        DKV.put(v2._key, v2, fs);
        return fs;
    }

    @Override
    public byte[] asBytes() {
        byte[] res = MemoryManager.malloc1(this._len * 4);
        for (int i2 = 0; i2 < this._len; ++i2) {
            UnsafeUtils.set4(res, 4 * i2, this._is[i2]);
        }
        return res;
    }

    @Override
    public boolean hasFloat() {
        return false;
    }
}

