/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import water.fvec.Chunk;
import water.fvec.ChunkVisitor;
import water.util.PrettyPrint;
import water.util.UnsafeUtils;

public abstract class CSChunk
extends Chunk {
    protected static final int _OFF = 16;
    private transient double _scale;
    private transient long _bias;
    private transient boolean _isDecimal;

    CSChunk(byte[] bs, long bias, int scale, int szLog) {
        this._mem = bs;
        this._start = -1L;
        this.set_len(this._mem.length - 16 >> szLog);
        this._bias = bias;
        UnsafeUtils.set8(this._mem, 0, bias);
        UnsafeUtils.set4(this._mem, 8, scale);
        this._scale = PrettyPrint.pow10(1L, scale);
        UnsafeUtils.set4(this._mem, 12, szLog);
    }

    protected void setDecimal() {
        this._isDecimal = true;
        this._scale = PrettyPrint.pow10(1L, -UnsafeUtils.get4(this._mem, 8));
        UnsafeUtils.set4(this._mem, 12, -UnsafeUtils.get4(this._mem, 12) - 1);
    }

    private int getSzLog() {
        int x2 = UnsafeUtils.get4(this._mem, 12);
        return x2 < 0 ? -x2 - 1 : x2;
    }

    public final double scale() {
        return this._isDecimal ? 1.0 / this._scale : this._scale;
    }

    @Override
    public final byte precision() {
        return (byte)Math.max(UnsafeUtils.get4(this._mem, 8), 0);
    }

    protected final double getD(int x2, int NA2) {
        return this.getD(x2, NA2, Double.NaN);
    }

    protected final double getD(int x2, int NA2, double naImpute) {
        return x2 == NA2 ? naImpute : (this._isDecimal ? (double)(this._bias + (long)x2) / this._scale : (double)(this._bias + (long)x2) * this._scale);
    }

    protected final long get8(int x2) {
        return (this._bias + (long)x2) * (long)this._scale;
    }

    @Override
    public final boolean hasFloat() {
        return this._isDecimal || this._scale < 1.0;
    }

    @Override
    public final void initFromBytes() {
        this._start = -1L;
        this._cidx = -1;
        this.set_len(this._mem.length - 16 >> this.getSzLog());
        this._bias = UnsafeUtils.get8(this._mem, 0);
        int x2 = UnsafeUtils.get4(this._mem, 8);
        int szLog = UnsafeUtils.get4(this._mem, 12);
        this._isDecimal = szLog < 0;
        this._scale = PrettyPrint.pow10(1L, this._isDecimal ? -x2 : x2);
    }

    @Override
    protected long at8_impl(int i2) {
        double res = this.atd_impl(i2);
        if (Double.isNaN(res)) {
            throw new IllegalArgumentException("at8_abs but value is missing");
        }
        return (long)res;
    }

    @Override
    public final boolean set_impl(int idx, long l2) {
        double d2 = l2;
        if (d2 != (double)l2) {
            return false;
        }
        return this.set_impl(idx, d2);
    }

    @Override
    public final boolean set_impl(int idx, float f2) {
        return this.set_impl(idx, (double)f2);
    }

    protected final int getScaledValue(double d2, int NA2) {
        assert (!Double.isNaN(d2)) : "NaN should be handled separately";
        return (int)((this._isDecimal ? d2 * this._scale : d2 / this._scale) - (double)this._bias);
    }

    @Override
    public final <T extends ChunkVisitor> T processRows(T v2, int from, int to) {
        if (v2.expandedVals()) {
            this.processRows2(v2, from, to, this._bias, UnsafeUtils.get4(this._mem, 8));
        } else {
            this.processRows2(v2, from, to);
        }
        return v2;
    }

    @Override
    public <T extends ChunkVisitor> T processRows(T v2, int[] ids) {
        if (v2.expandedVals()) {
            this.processRows2(v2, ids, this._bias, UnsafeUtils.get4(this._mem, 8));
        } else {
            this.processRows2(v2, ids);
        }
        return v2;
    }

    protected abstract <T extends ChunkVisitor> T processRows2(T var1, int var2, int var3, long var4, int var6);

    protected abstract <T extends ChunkVisitor> T processRows2(T var1, int var2, int var3);

    protected abstract <T extends ChunkVisitor> T processRows2(T var1, int[] var2, long var3, int var5);

    protected abstract <T extends ChunkVisitor> T processRows2(T var1, int[] var2);
}

