/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import water.H2O;
import water.fvec.CXIChunk;
import water.fvec.Chunk;
import water.fvec.ChunkVisitor;
import water.util.UnsafeUtils;

public class CXFChunk
extends CXIChunk {
    protected CXFChunk(byte[] mem) {
        super(mem);
    }

    private double getVal(int x2) {
        switch (this._elem_sz) {
            case 8: {
                return UnsafeUtils.get4f(this._mem, x2 + 4);
            }
            case 12: {
                return UnsafeUtils.get8d(this._mem, x2 + 4);
            }
        }
        throw H2O.unimpl();
    }

    @Override
    public long at8_impl(int idx) {
        int x2 = this.findOffset(idx);
        if (x2 < 0) {
            if (this._isNA) {
                throw new RuntimeException("at4 but the value is missing!");
            }
            return 0L;
        }
        double val = this.getVal(x2);
        if (Double.isNaN(val)) {
            throw new RuntimeException("at4 but the value is missing!");
        }
        return (long)val;
    }

    @Override
    public double atd_impl(int idx) {
        int x2 = this.findOffset(idx);
        if (x2 < 0) {
            return this._isNA ? Double.NaN : 0.0;
        }
        return this.getVal(x2);
    }

    @Override
    public Chunk deepCopy() {
        return new CXFChunk((byte[])this._mem.clone());
    }

    @Override
    public <T extends ChunkVisitor> T processRows(T v2, int from, int to) {
        int id;
        int x2;
        int prevId = from - 1;
        int n2 = x2 = from == 0 ? 8 : this.findOffset(from);
        if (x2 < 0) {
            x2 = -x2 - 1;
        }
        while (x2 < this._mem.length && (id = this.getId(x2)) < to) {
            if (this._isNA) {
                v2.addNAs(id - prevId - 1);
            } else {
                v2.addZeros(id - prevId - 1);
            }
            v2.addValue(this.getVal(x2));
            prevId = id;
            x2 += this._elem_sz;
        }
        if (this._isNA) {
            v2.addNAs(to - prevId - 1);
        } else {
            v2.addZeros(to - prevId - 1);
        }
        return v2;
    }

    @Override
    public <T extends ChunkVisitor> T processRows(T v2, int[] ids) {
        int x2 = 8;
        int zeros = 0;
        for (int k2 = 0; k2 < ids.length; ++k2) {
            int idk = ids[k2];
            assert (ids[k2] >= 0 && (k2 == 0 || ids[k2] > ids[k2 - 1]));
            int idx = ids[ids.length - 1] + 1;
            while (x2 < this._mem.length && (idx = this.getId(x2)) < idk) {
                x2 += this._elem_sz;
            }
            if (x2 == this._mem.length) {
                zeros += ids.length - k2;
                break;
            }
            if (idx == idk) {
                if (this._isNA) {
                    v2.addNAs(zeros);
                } else {
                    v2.addZeros(zeros);
                }
                v2.addValue(this.getVal(x2));
                zeros = 0;
                x2 += this._elem_sz;
                continue;
            }
            ++zeros;
        }
        if (zeros > 0) {
            if (this._isNA) {
                v2.addNAs(zeros);
            } else {
                v2.addZeros(zeros);
            }
        }
        return v2;
    }

    @Override
    public boolean hasFloat() {
        return true;
    }
}

