/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import java.util.Date;
import java.util.UUID;
import water.AutoBuffer;
import water.DKV;
import water.Futures;
import water.Iced;
import water.Value;
import water.fvec.C4VolatileChunk;
import water.fvec.C8DVolatileChunk;
import water.fvec.ChunkVisitor;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.parser.BufferedString;

public abstract class Chunk
extends Iced<Chunk>
implements Vec.Holder {
    transient long _start = -1L;
    transient int _cidx = -1;
    public transient int _len;
    private transient Chunk _chk2;
    transient Vec _vec;
    byte[] _mem;

    public Chunk() {
    }

    private Chunk(byte[] bytes) {
        this._mem = bytes;
        this.initFromBytes();
    }

    public final long start() {
        return this._start;
    }

    int set_len(int len) {
        this._len = len;
        return this._len;
    }

    public int len() {
        return this._len;
    }

    public Chunk chk2() {
        return this._chk2;
    }

    @Override
    public Vec vec() {
        return this._vec;
    }

    public void setVec(Vec vec) {
        this._vec = vec;
    }

    public void setStart(long start) {
        this._start = start;
    }

    public byte[] getBytes() {
        return this._mem;
    }

    public void setBytes(byte[] mem) {
        this._mem = mem;
    }

    final long at8_abs(long i2) {
        long x2 = i2 - (this._start > 0L ? this._start : 0L);
        if (0L <= x2 && x2 < (long)this._len) {
            return this.at8((int)x2);
        }
        throw new ArrayIndexOutOfBoundsException("" + this._start + " <= " + i2 + " < " + (this._start + (long)this._len));
    }

    final double at_abs(long i2) {
        long x2 = i2 - (this._start > 0L ? this._start : 0L);
        if (0L <= x2 && x2 < (long)this._len) {
            return this.atd((int)x2);
        }
        throw new ArrayIndexOutOfBoundsException("" + this._start + " <= " + i2 + " < " + (this._start + (long)this._len));
    }

    final boolean isNA_abs(long i2) {
        long x2 = i2 - (this._start > 0L ? this._start : 0L);
        if (0L <= x2 && x2 < (long)this._len) {
            return this.isNA((int)x2);
        }
        throw new ArrayIndexOutOfBoundsException("" + this._start + " <= " + i2 + " < " + (this._start + (long)this._len));
    }

    final long at16l_abs(long i2) {
        long x2 = i2 - (this._start > 0L ? this._start : 0L);
        if (0L <= x2 && x2 < (long)this._len) {
            return this.at16l((int)x2);
        }
        throw new ArrayIndexOutOfBoundsException("" + this._start + " <= " + i2 + " < " + (this._start + (long)this._len));
    }

    final long at16h_abs(long i2) {
        long x2 = i2 - (this._start > 0L ? this._start : 0L);
        if (0L <= x2 && x2 < (long)this._len) {
            return this.at16h((int)x2);
        }
        throw new ArrayIndexOutOfBoundsException("" + this._start + " <= " + i2 + " < " + (this._start + (long)this._len));
    }

    final BufferedString atStr_abs(BufferedString bStr, long i2) {
        long x2 = i2 - (this._start > 0L ? this._start : 0L);
        if (0L <= x2 && x2 < (long)this._len) {
            return this.atStr(bStr, (int)x2);
        }
        throw new ArrayIndexOutOfBoundsException("" + this._start + " <= " + i2 + " < " + (this._start + (long)this._len));
    }

    public final double atd(int i2) {
        return this._chk2 == null ? this.atd_impl(i2) : this._chk2.atd_impl(i2);
    }

    public final long at8(int i2) {
        return this._chk2 == null ? this.at8_impl(i2) : this._chk2.at8_impl(i2);
    }

    public final boolean isNA(int i2) {
        return this._chk2 == null ? this.isNA_impl(i2) : this._chk2.isNA_impl(i2);
    }

    public final long at16l(int i2) {
        return this._chk2 == null ? this.at16l_impl(i2) : this._chk2.at16l_impl(i2);
    }

    public final long at16h(int i2) {
        return this._chk2 == null ? this.at16h_impl(i2) : this._chk2.at16h_impl(i2);
    }

    public final BufferedString atStr(BufferedString bStr, int i2) {
        return this._chk2 == null ? this.atStr_impl(bStr, i2) : this._chk2.atStr_impl(bStr, i2);
    }

    public String stringAt(int i2) {
        return this.atStr(new BufferedString(), i2).toString();
    }

    final void set_abs(long i2, long l2) {
        long x2 = i2 - this._start;
        if (0L <= x2 && x2 < (long)this._len) {
            this.set((int)x2, l2);
        } else {
            this._vec.set(i2, l2);
        }
    }

    final void set_abs(long i2, double d2) {
        long x2 = i2 - this._start;
        if (0L <= x2 && x2 < (long)this._len) {
            this.set((int)x2, d2);
        } else {
            this._vec.set(i2, d2);
        }
    }

    final void set_abs(long i2, float f2) {
        long x2 = i2 - this._start;
        if (0L <= x2 && x2 < (long)this._len) {
            this.set((int)x2, f2);
        } else {
            this._vec.set(i2, f2);
        }
    }

    final void setNA_abs(long i2) {
        long x2 = i2 - this._start;
        if (0L <= x2 && x2 < (long)this._len) {
            this.setNA((int)x2);
        } else {
            this._vec.setNA(i2);
        }
    }

    public final void set_abs(long i2, String str) {
        long x2 = i2 - this._start;
        if (0L <= x2 && x2 < (long)this._len) {
            this.set((int)x2, str);
        } else {
            this._vec.set(i2, str);
        }
    }

    public final void set_abs(long i2, UUID uuid) {
        long x2 = i2 - this._start;
        if (0L <= x2 && x2 < (long)this._len) {
            this.set((int)x2, uuid);
        } else {
            this._vec.set(i2, uuid);
        }
    }

    public boolean hasFloat() {
        return true;
    }

    public boolean hasNA() {
        return true;
    }

    public void replaceAll(Chunk replacement) {
        assert (this._len == replacement._len);
        this._vec.preWriting();
        this._chk2 = replacement;
        assert (this._chk2._chk2 == null);
    }

    public Chunk deepCopy() {
        Chunk c2 = (Chunk)this.clone();
        c2._vec = null;
        c2._start = -1L;
        c2._cidx = -1;
        c2._mem = (byte[])this._mem.clone();
        c2.initFromBytes();
        assert (this.len() == c2._len);
        return c2;
    }

    private void setWrite() {
        if (this._chk2 != null) {
            return;
        }
        assert (!(this instanceof NewChunk)) : "Cannot direct-write into a NewChunk, only append";
        this.setWrite((Chunk)this.clone());
    }

    private void setWrite(Chunk ck) {
        assert (this._chk2 == null);
        this._vec.preWriting();
        this._chk2 = ck;
        assert (this._chk2._chk2 == null);
    }

    public final long set(int idx, long l2) {
        this.setWrite();
        if (this._chk2.set_impl(idx, l2)) {
            return l2;
        }
        this._chk2 = this.inflate();
        this._chk2.set_impl(idx, l2);
        return l2;
    }

    public final double[] set(double[] d2) {
        assert (d2.length == this._len && this._chk2 == null);
        this.setWrite(new NewChunk(this, d2));
        return d2;
    }

    public final double set(int idx, double d2) {
        this.setWrite();
        if (this._chk2.set_impl(idx, d2)) {
            return d2;
        }
        this._chk2 = this.inflate();
        this._chk2.set_impl(idx, d2);
        return d2;
    }

    public final float set(int idx, float f2) {
        this.setWrite();
        if (this._chk2.set_impl(idx, f2)) {
            return f2;
        }
        this._chk2 = this.inflate();
        this._chk2.set_impl(idx, f2);
        return f2;
    }

    public final boolean setNA(int idx) {
        this.setWrite();
        if (this._chk2.setNA_impl(idx)) {
            return true;
        }
        this._chk2 = this.inflate();
        this._chk2.setNA_impl(idx);
        return true;
    }

    public final String set(int idx, String str) {
        this.setWrite();
        if (this._chk2.set_impl(idx, str)) {
            return str;
        }
        this._chk2 = this.inflate();
        this._chk2.set_impl(idx, str);
        return str;
    }

    public final UUID set(int idx, UUID uuid) {
        this.setWrite();
        long lo = uuid.getLeastSignificantBits();
        long hi = uuid.getMostSignificantBits();
        if (this._chk2.set_impl(idx, lo, hi)) {
            return uuid;
        }
        this._chk2 = this.inflate();
        this._chk2.set_impl(idx, lo, hi);
        return uuid;
    }

    private Object setUnknown(int idx) {
        this.setNA(idx);
        return null;
    }

    public final Object setAny(int idx, Object x2) {
        return x2 instanceof String ? this.set(idx, (String)x2) : (x2 instanceof Double ? Double.valueOf(this.set(idx, (Double)x2)) : (x2 instanceof Float ? Float.valueOf(this.set(idx, ((Float)x2).floatValue())) : (x2 instanceof Long ? Long.valueOf(this.set(idx, (Long)x2)) : (x2 instanceof Integer ? Long.valueOf(this.set(idx, ((Integer)x2).longValue())) : (x2 instanceof UUID ? this.set(idx, (UUID)x2) : (x2 instanceof Date ? Long.valueOf(this.set(idx, ((Date)x2).getTime())) : this.setUnknown(idx)))))));
    }

    public Futures close(int cidx, Futures fs) {
        if (this instanceof NewChunk) {
            this._chk2 = this;
        }
        if (this._chk2 == null) {
            return fs;
        }
        if (this._chk2 instanceof NewChunk) {
            this._chk2 = ((NewChunk)this._chk2).new_close();
        }
        DKV.put(this._vec.chunkKey(cidx), this._chk2, fs, true);
        return fs;
    }

    public int cidx() {
        assert (this._cidx != -1) : "Chunk idx was not properly loaded!";
        return this._cidx;
    }

    public final Chunk setVolatile(double[] ds) {
        C8DVolatileChunk res = new C8DVolatileChunk(ds);
        Value v2 = new Value(this._vec.chunkKey(this._cidx), res, ds.length * 8, 1);
        DKV.put(v2._key, v2);
        return res;
    }

    public final Chunk setVolatile(int[] vals) {
        C4VolatileChunk res = new C4VolatileChunk(vals);
        Value v2 = new Value(this._vec.chunkKey(this._cidx), res, vals.length * 4, 1);
        DKV.put(v2._key, v2);
        return res;
    }

    public boolean isVolatile() {
        return false;
    }

    static WrongType wrongType(Class<?> expected, Class<?> actual) {
        return new WrongType(expected, actual);
    }

    abstract double atd_impl(int var1);

    abstract long at8_impl(int var1);

    abstract boolean isNA_impl(int var1);

    long at16l_impl(int idx) {
        throw Chunk.wrongType(UUID.class, Object.class);
    }

    long at16h_impl(int idx) {
        throw Chunk.wrongType(UUID.class, Object.class);
    }

    BufferedString atStr_impl(BufferedString bStr, int idx) {
        throw new IllegalArgumentException("Not a String");
    }

    abstract boolean set_impl(int var1, long var2);

    abstract boolean set_impl(int var1, double var2);

    abstract boolean set_impl(int var1, float var2);

    abstract boolean setNA_impl(int var1);

    boolean set_impl(int idx, String str) {
        return false;
    }

    boolean set_impl(int i2, long lo, long hi) {
        return false;
    }

    public boolean isSparseZero() {
        return false;
    }

    public int sparseLenZero() {
        return this._len;
    }

    public int nextNZ(int rid) {
        return rid + 1;
    }

    public int nextNZ(int rid, boolean onlyTrueZero) {
        return rid + 1;
    }

    public int nonzeros(int[] res) {
        int k2 = 0;
        for (int i2 = 0; i2 < this._len; ++i2) {
            if (this.atd(i2) == 0.0) continue;
            res[k2++] = i2;
        }
        return k2;
    }

    public boolean isSparseNA() {
        return false;
    }

    public int sparseLenNA() {
        return this._len;
    }

    double min() {
        return Double.NaN;
    }

    double max() {
        return Double.NaN;
    }

    public final NewChunk inflate() {
        return this.extractRows(new NewChunk(this), 0, this._len);
    }

    public Chunk nextChunk() {
        return this._vec.nextChunk(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._start + ".." + (this._start + (long)this._len - 1L) + "]";
    }

    public long byteSize() {
        long s2 = this._mem == null ? 0L : (long)this._mem.length;
        s2 += 68L;
        if (this._chk2 != null) {
            s2 += this._chk2.byteSize();
        }
        return s2;
    }

    public final AutoBuffer write_impl(AutoBuffer bb) {
        return bb.putA1(this._mem);
    }

    @Override
    public byte[] asBytes() {
        return this._mem;
    }

    @Override
    public final Chunk reloadFromBytes(byte[] ary) {
        this._mem = ary;
        this.initFromBytes();
        return this;
    }

    protected abstract void initFromBytes();

    public final Chunk read_impl(AutoBuffer ab) {
        this._mem = ab.getA1();
        this.initFromBytes();
        return this;
    }

    public byte precision() {
        return -1;
    }

    public final void reportBrokenCategorical(int i2, int j2, long l2, int[] cmap, int levels) {
        int k2;
        StringBuilder sb = new StringBuilder("Categorical renumber task, column # " + i2 + ": Found OOB index " + l2 + " (expected 0 - " + cmap.length + ", global domain has " + levels + " levels) pulled from " + this.getClass().getSimpleName() + "\n");
        for (k2 = 0; k2 < Math.min(5, this._len); ++k2) {
            sb.append("at8_abs[" + ((long)k2 + this._start) + "] = " + this.atd(k2) + ", _chk2 = " + (this._chk2 != null ? Double.valueOf(this._chk2.atd(k2)) : "") + "\n");
        }
        sb.append("...\n");
        for (k2 = Math.max(k2, j2 - 2); k2 < Math.min(this._len, j2 + 2); ++k2) {
            sb.append("at8_abs[" + ((long)k2 + this._start) + "] = " + this.atd(k2) + ", _chk2 = " + (this._chk2 != null ? Double.valueOf(this._chk2.atd(k2)) : "") + "\n");
        }
        sb.append("...\n");
        for (k2 = Math.max(k2, this._len - 5); k2 < this._len; ++k2) {
            sb.append("at8_abs[" + ((long)k2 + this._start) + "] = " + this.atd(k2) + ", _chk2 = " + (this._chk2 != null ? Double.valueOf(this._chk2.atd(k2)) : "") + "\n");
        }
        throw new RuntimeException(sb.toString());
    }

    public abstract <T extends ChunkVisitor> T processRows(T var1, int var2, int var3);

    public abstract <T extends ChunkVisitor> T processRows(T var1, int[] var2);

    public NewChunk extractRows(NewChunk nc, int from, int to) {
        return this.processRows(new ChunkVisitor.NewChunkVisitor((NewChunk)nc), (int)from, (int)to)._nc;
    }

    public NewChunk extractRows(NewChunk nc, int[] rows) {
        return this.processRows(new ChunkVisitor.NewChunkVisitor((NewChunk)nc), (int[])rows)._nc;
    }

    public NewChunk extractRows(NewChunk nc, int row) {
        return this.processRows(new ChunkVisitor.NewChunkVisitor((NewChunk)nc), (int)row, (int)(row + 1))._nc;
    }

    public double[] getDoubles(double[] vals, int from, int to) {
        return this.getDoubles(vals, from, to, Double.NaN);
    }

    public double[] getDoubles(double[] vals, int from, int to, double NA2) {
        return this.processRows(new ChunkVisitor.DoubleAryVisitor((double[])vals, (double)NA2), (int)from, (int)to).vals;
    }

    public int[] getIntegers(int[] vals, int from, int to, int NA2) {
        return this.processRows(new ChunkVisitor.IntAryVisitor((int[])vals, (int)NA2), (int)from, (int)to).vals;
    }

    public double[] getDoubles(double[] vals, int[] ids) {
        return this.processRows(new ChunkVisitor.DoubleAryVisitor((double[])vals), (int[])ids).vals;
    }

    public int getSparseDoubles(double[] vals, int[] ids) {
        return this.getSparseDoubles(vals, ids, Double.NaN);
    }

    public int getSparseDoubles(double[] vals, int[] ids, double NA2) {
        return this.processRows(new ChunkVisitor.SparseDoubleAryVisitor(vals, ids, this.isSparseNA(), NA2), 0, this._len).sparseLen();
    }

    static class WrongType
    extends IllegalArgumentException {
        private final Class<?> expected;
        private final Class<?> actual;

        public WrongType(Class<?> expected, Class<?> actual) {
            super("Expected: " + expected + ", actual: " + actual);
            this.expected = expected;
            this.actual = actual;
        }
    }
}

