/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import water.fvec.NewChunk;
import water.parser.BufferedString;
import water.util.PrettyPrint;

public abstract class ChunkVisitor {
    public boolean expandedVals() {
        return false;
    }

    void addValue(BufferedString bs) {
        throw new UnsupportedOperationException();
    }

    void addValue(long uuid_lo, long uuid_hi) {
        throw new UnsupportedOperationException();
    }

    void addValue(int val) {
        throw new UnsupportedOperationException();
    }

    void addValue(double val) {
        throw new UnsupportedOperationException();
    }

    void addValue(long val) {
        throw new UnsupportedOperationException();
    }

    void addValue(long m4, int e2) {
        this.addValue(PrettyPrint.pow10(m4, e2));
    }

    void addZeros(int zeros) {
        throw new UnsupportedOperationException();
    }

    void addNAs(int nas) {
        throw new UnsupportedOperationException();
    }

    public static final class IntAryVisitor
    extends ChunkVisitor {
        public final int[] vals;
        private int _k = 0;
        private final int _na;

        IntAryVisitor(int[] vals, int NA2) {
            this.vals = vals;
            this._na = NA2;
        }

        @Override
        public void addValue(int val) {
            this.vals[this._k++] = val;
        }

        @Override
        public void addValue(long val) {
            if (Integer.MAX_VALUE < val || val < Integer.MIN_VALUE) {
                throw new RuntimeException(val + " does not fit into int");
            }
            this.vals[this._k++] = (int)val;
        }

        @Override
        public void addValue(double val) {
            if (Double.isNaN(val)) {
                this.vals[this._k++] = this._na;
            } else {
                int i2 = (int)val;
                if ((double)i2 != val) {
                    throw new RuntimeException(val + " does not fit into int");
                }
                this.vals[this._k++] = i2;
            }
        }

        @Override
        public void addZeros(int zeros) {
            int k2;
            int kmax = k2 + zeros;
            for (k2 = this._k; k2 < kmax; ++k2) {
                this.vals[k2] = 0;
            }
            this._k = kmax;
        }

        @Override
        public void addNAs(int nas) {
            int k2;
            int kmax = k2 + nas;
            for (k2 = this._k; k2 < kmax; ++k2) {
                this.vals[k2] = this._na;
            }
            this._k = kmax;
        }
    }

    public static final class CombiningDoubleAryVisitor
    extends ChunkVisitor {
        public final double[] vals;
        private int _k = 0;
        private final double _na;

        public CombiningDoubleAryVisitor(double[] vals) {
            this(vals, Double.NaN);
        }

        CombiningDoubleAryVisitor(double[] vals, double NA2) {
            this.vals = vals;
            this._na = NA2;
        }

        @Override
        void addValue(int val) {
            int n2 = this._k++;
            this.vals[n2] = this.vals[n2] + (double)val;
        }

        @Override
        void addValue(long val) {
            int n2 = this._k++;
            this.vals[n2] = this.vals[n2] + (double)val;
        }

        @Override
        void addValue(double val) {
            if (Double.isNaN(val)) {
                this.vals[this._k++] = this._na;
            } else {
                int n2 = this._k++;
                this.vals[n2] = this.vals[n2] + val;
            }
        }

        @Override
        void addZeros(int zeros) {
            this._k += zeros;
        }

        @Override
        void addNAs(int nas) {
            int k2;
            int kmax = k2 + nas;
            for (k2 = this._k; k2 < kmax; ++k2) {
                this.vals[k2] = this._na;
            }
            this._k = kmax;
        }

        public void reset() {
            this._k = 0;
        }
    }

    public static final class SparseDoubleAryVisitor
    extends ChunkVisitor {
        public final boolean naSparse;
        public final double[] vals;
        public final int[] ids;
        private int _sparseLen;
        private int _len;
        private final double _na;

        public int sparseLen() {
            return this._sparseLen;
        }

        SparseDoubleAryVisitor(double[] vals, int[] ids) {
            this(vals, ids, false, Double.NaN);
        }

        SparseDoubleAryVisitor(double[] vals, int[] ids, boolean naSparse) {
            this(vals, ids, naSparse, Double.NaN);
        }

        SparseDoubleAryVisitor(double[] vals, int[] ids, boolean naSparse, double NA2) {
            this.vals = vals;
            this.ids = ids;
            this._na = NA2;
            this.naSparse = naSparse;
        }

        @Override
        void addValue(int val) {
            ++this._len;
            this.vals[this._sparseLen++] = val;
        }

        @Override
        void addValue(long val) {
            ++this._len;
            this.vals[this._sparseLen++] = val;
        }

        @Override
        void addValue(double val) {
            ++this._len;
            this.vals[this._sparseLen++] = Double.isNaN(val) ? this._na : val;
        }

        @Override
        void addZeros(int zeros) {
            if (this.naSparse) {
                int kmax = this._sparseLen + zeros;
                for (int k2 = this._sparseLen; k2 < kmax; ++k2) {
                    ++this._len;
                    this.vals[k2] = 0.0;
                }
                this._sparseLen = kmax;
            } else {
                this._len += zeros;
            }
        }

        @Override
        void addNAs(int nas) {
            if (!this.naSparse) {
                int kmax = this._sparseLen + nas;
                for (int k2 = this._sparseLen; k2 < kmax; ++k2) {
                    ++this._len;
                    this.vals[k2] = this._na;
                }
                this._sparseLen = kmax;
            } else {
                this._len += nas;
            }
        }
    }

    public static final class DoubleAryVisitor
    extends ChunkVisitor {
        public final double[] vals;
        private int _k = 0;
        private final double _na;

        DoubleAryVisitor(double[] vals) {
            this(vals, Double.NaN);
        }

        DoubleAryVisitor(double[] vals, double NA2) {
            this.vals = vals;
            this._na = NA2;
        }

        @Override
        void addValue(int val) {
            this.vals[this._k++] = val;
        }

        @Override
        void addValue(long val) {
            this.vals[this._k++] = val;
        }

        @Override
        void addValue(double val) {
            this.vals[this._k++] = Double.isNaN(val) ? this._na : val;
        }

        @Override
        void addZeros(int zeros) {
            int k2;
            int kmax = k2 + zeros;
            for (k2 = this._k; k2 < kmax; ++k2) {
                this.vals[k2] = 0.0;
            }
            this._k = kmax;
        }

        @Override
        void addNAs(int nas) {
            int k2;
            int kmax = k2 + nas;
            for (k2 = this._k; k2 < kmax; ++k2) {
                this.vals[k2] = this._na;
            }
            this._k = kmax;
        }
    }

    public static final class NewChunkVisitor
    extends ChunkVisitor {
        final NewChunk _nc;

        public NewChunkVisitor(NewChunk nc) {
            this._nc = nc;
        }

        @Override
        public boolean expandedVals() {
            return true;
        }

        @Override
        void addValue(BufferedString bs) {
            this._nc.addStr(bs);
        }

        @Override
        void addValue(long uuid_lo, long uuid_hi) {
            this._nc.addUUID(uuid_lo, uuid_hi);
        }

        @Override
        void addValue(int val) {
            this._nc.addNum(val, 0);
        }

        @Override
        void addValue(long val) {
            this._nc.addNum(val, 0);
        }

        @Override
        void addValue(long val, int exp) {
            this._nc.addNum(val, exp);
        }

        @Override
        void addValue(double val) {
            this._nc.addNum(val);
        }

        @Override
        void addZeros(int zeros) {
            this._nc.addZeros(zeros);
        }

        @Override
        void addNAs(int nas) {
            this._nc.addNAs(nas);
        }
    }
}

