/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import water.DKV;
import water.Futures;
import water.Key;
import water.Keyed;
import water.TypeMap;
import water.Value;
import water.fvec.ByteVec;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.Log;
import water.util.MathUtils;
import water.util.UnsafeUtils;

public abstract class FileVec
extends ByteVec {
    long _len;
    private final byte _be;
    public static final int DFLT_LOG2_CHUNK_SIZE = 22;
    public static final int DFLT_CHUNK_SIZE = 0x400000;
    public int _chunkSize = 0x400000;
    public int _nChunks = -1;

    public byte getBackend() {
        return this._be;
    }

    public String getPath() {
        return FileVec.getPathForKey(this._key);
    }

    public static String getPathForKey(Key k2) {
        int off = k2._kb[0] == 5 || k2._kb[0] == 4 ? 10 : 0;
        String p2 = new String(k2._kb, off, k2._kb.length - off);
        if (p2.startsWith("nfs:/")) {
            p2 = p2.substring("nfs:/".length());
        } else if (p2.startsWith("nfs:\\")) {
            p2 = p2.substring("nfs:\\".length());
        }
        return p2;
    }

    protected FileVec(Key key, long len, byte be) {
        super(key, -1);
        this._len = len;
        this._be = be;
    }

    public void setNChunks(int n2) {
        this._nChunks = n2;
        this.setChunkSize((int)this.length() / n2);
    }

    public int setChunkSize(int chunkSize) {
        return this.setChunkSize(null, chunkSize);
    }

    public int setChunkSize(Frame fr, int chunkSize) {
        Futures fs = new Futures();
        Keyed.remove(this._key, fs, true);
        fs.blockForPending();
        if (chunkSize <= 0) {
            throw new IllegalArgumentException("Chunk sizes must be > 0.");
        }
        if (chunkSize > 0x40000000) {
            throw new IllegalArgumentException("Chunk sizes must be < 1G.");
        }
        this._chunkSize = chunkSize;
        fs = new Futures();
        DKV.put(this._key, this, fs);
        if (fr != null) {
            fr.reloadVecs();
            DKV.put(fr._key, fr, fs);
        }
        fs.blockForPending();
        return this._chunkSize;
    }

    @Override
    public long length() {
        return this._len;
    }

    @Override
    public int nChunks() {
        if (this._nChunks != -1) {
            return this._nChunks;
        }
        return (int)Math.max(1L, this._len / (long)this._chunkSize + (long)(this._len % (long)this._chunkSize != 0L ? 1 : 0));
    }

    @Override
    public int nonEmptyChunks() {
        return this.nChunks();
    }

    @Override
    public boolean writable() {
        return false;
    }

    @Override
    public long byteSize() {
        return this.length();
    }

    @Override
    public int elem2ChunkIdx(long i2) {
        assert (0L <= i2 && i2 <= this._len) : " " + i2 + " < " + this._len;
        int cidx = (int)(i2 / (long)this._chunkSize);
        int nc = this.nChunks();
        if (i2 >= this._len) {
            return nc;
        }
        if (cidx >= nc) {
            cidx = nc - 1;
        }
        assert (0 <= cidx && cidx < nc);
        return cidx;
    }

    @Override
    long chunk2StartElem(int cidx) {
        return (long)cidx * (long)this._chunkSize;
    }

    public static long chunkOffset(Key ckey) {
        return (long)FileVec.chunkIdx(ckey) * (long)((FileVec)Vec.getVecKey((Key)ckey).get())._chunkSize;
    }

    static int chunkIdx(Key ckey) {
        assert (ckey._kb[0] == 5);
        return UnsafeUtils.get4(ckey._kb, 6);
    }

    @Override
    public Value chunkIdx(int cidx) {
        long nchk = this.nChunks();
        assert (0 <= cidx && (long)cidx < nchk);
        Key dkey = this.chunkKey(cidx);
        Value val1 = DKV.get(dkey);
        if (val1 != null) {
            return val1;
        }
        int len = (int)((long)cidx < nchk - 1L ? (long)this._chunkSize : this._len - this.chunk2StartElem(cidx));
        Value val2 = new Value(dkey, len, null, TypeMap.C1NCHUNK, this._be);
        val2.setDsk();
        Futures fs = dkey.home() ? null : new Futures();
        Value val3 = DKV.DputIfMatch(dkey, val2, null, fs);
        if (!dkey.home() && fs != null) {
            fs.blockForPending();
        }
        return val3 == null ? val2 : val3;
    }

    public static int calcOptimalChunkSize(long totalSize, int numCols, long maxLineLength, int cores, int cloudsize, boolean oldHeuristic, boolean verbose) {
        long localParseSize = (long)((double)totalSize) / (long)cloudsize;
        if (oldHeuristic) {
            long chunkSize = localParseSize / (long)(cores * 4);
            if (chunkSize <= 65536L) {
                return 0x400000;
            }
            if ((chunkSize = 1L << MathUtils.log2(chunkSize)) < 0x400000L && localParseSize / chunkSize * (long)numCols < 0x200000L) {
                return (int)chunkSize;
            }
            long tmp = localParseSize * (long)numCols / 0x200000L;
            if (tmp > 0x40000000L) {
                return 0x40000000;
            }
            if (tmp > 0x400000L) {
                chunkSize = 1 << MathUtils.log2((int)tmp);
                return (int)chunkSize;
            }
            return 0x400000;
        }
        int minNumberRows = 10;
        int perNodeChunkCountLimit = 0x200000;
        int minParseChunkSize = 4096;
        int maxParseChunkSize = 0xFFFFFFF;
        long chunkSize = Math.max(localParseSize / (long)(4 * cores) + 1L, (long)minParseChunkSize);
        if (chunkSize > 0x100000L) {
            chunkSize = (chunkSize & 0xFFFFFFFFFFFFFE00L) + 512L;
        }
        if (totalSize <= 65536L) {
            chunkSize = Math.max(0x400000, (int)((long)minNumberRows * maxLineLength));
        } else if (chunkSize < 0x400000L && localParseSize / chunkSize * (long)numCols < (long)perNodeChunkCountLimit) {
            chunkSize = Math.max((int)chunkSize, (int)((long)minNumberRows * maxLineLength));
        } else {
            int chunkCount = cores * 4 * numCols;
            if (chunkCount > perNodeChunkCountLimit) {
                double ratio = 1 << Math.max(2, MathUtils.log2((int)((double)chunkCount) / perNodeChunkCountLimit));
                chunkSize = (long)((double)chunkSize * ratio);
            }
            if ((chunkSize = Math.min((long)maxParseChunkSize, chunkSize)) <= (long)minNumberRows * maxLineLength) {
                chunkSize = (int)Math.max(0x400000L, Math.min((long)maxParseChunkSize, (long)minNumberRows * maxLineLength));
            }
        }
        assert (chunkSize >= (long)minParseChunkSize);
        assert (chunkSize <= (long)maxParseChunkSize);
        if (verbose) {
            Log.info("ParseSetup heuristic: cloudSize: " + cloudsize + ", cores: " + cores + ", numCols: " + numCols + ", maxLineLength: " + maxLineLength + ", totalSize: " + totalSize + ", localParseSize: " + localParseSize + ", chunkSize: " + chunkSize + ", numChunks: " + Math.max(1L, totalSize / chunkSize) + ", numChunks * cols: " + Math.max(1L, totalSize / chunkSize) * (long)numCols);
        }
        return (int)chunkSize;
    }
}

