/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import hex.CreateFrame;
import java.util.Arrays;
import java.util.Random;
import jsr166y.CountedCompleter;
import water.H2O;
import water.H2ORuntime;
import water.Job;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.FileVec;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.ArrayUtils;
import water.util.FrameUtils;
import water.util.RandomBase;
import water.util.RandomUtils;

public class FrameCreator
extends H2O.H2OCountedCompleter {
    transient Vec _v;
    private final CreateFrame _createFrame;
    private int[] _cat_cols;
    private int[] _int_cols;
    private int[] _real_cols;
    private int[] _bin_cols;
    private int[] _time_cols;
    private int[] _string_cols;
    private String[][] _domain;
    private Frame _out;

    public FrameCreator(CreateFrame createFrame) {
        this._createFrame = createFrame;
        int[] idx = this._createFrame.has_response ? ArrayUtils.seq(1, this._createFrame.cols + 1) : ArrayUtils.seq(0, this._createFrame.cols);
        int[] shuffled_idx = new int[idx.length];
        ArrayUtils.shuffleArray(idx, idx.length, shuffled_idx, this._createFrame.seed_for_column_types, 0);
        int catcols = (int)(this._createFrame.categorical_fraction * (double)this._createFrame.cols + 0.1);
        int intcols = (int)(this._createFrame.integer_fraction * (double)this._createFrame.cols + 0.1);
        int bincols = (int)(this._createFrame.binary_fraction * (double)this._createFrame.cols + 0.1);
        int timecols = (int)(this._createFrame.time_fraction * (double)this._createFrame.cols + 0.1);
        int stringcols = (int)(this._createFrame.string_fraction * (double)this._createFrame.cols + 0.1);
        int realcols = this._createFrame.cols - catcols - intcols - bincols - timecols - stringcols;
        if (realcols < 0 && catcols > 0) {
            --catcols;
            ++realcols;
        }
        if (realcols < 0 && intcols > 0) {
            --intcols;
            ++realcols;
        }
        if (realcols < 0 && bincols > 0) {
            --bincols;
            ++realcols;
        }
        if (realcols < 0 && timecols > 0) {
            --timecols;
            ++realcols;
        }
        if (realcols < 0 && stringcols > 0) {
            --stringcols;
            ++realcols;
        }
        assert (catcols >= 0);
        assert (intcols >= 0);
        assert (bincols >= 0);
        assert (realcols >= 0);
        assert (timecols >= 0);
        assert (stringcols >= 0);
        this._cat_cols = Arrays.copyOfRange(shuffled_idx, 0, catcols);
        this._int_cols = Arrays.copyOfRange(shuffled_idx, catcols, catcols + intcols);
        this._real_cols = Arrays.copyOfRange(shuffled_idx, catcols + intcols, catcols + intcols + realcols);
        this._bin_cols = Arrays.copyOfRange(shuffled_idx, catcols + intcols + realcols, catcols + intcols + realcols + bincols);
        this._time_cols = Arrays.copyOfRange(shuffled_idx, catcols + intcols + realcols + bincols, catcols + intcols + realcols + bincols + timecols);
        this._string_cols = Arrays.copyOfRange(shuffled_idx, catcols + intcols + realcols + bincols + timecols, catcols + intcols + realcols + bincols + timecols + stringcols);
        this._domain = new String[this._createFrame.cols + (this._createFrame.has_response ? 1 : 0)][];
        if (createFrame.randomize) {
            if (this._createFrame.has_response) {
                assert (this._createFrame.response_factors >= 1);
                String[] stringArray = this._domain[0] = this._createFrame.response_factors == 1 ? null : new String[this._createFrame.response_factors];
                if (this._domain[0] != null) {
                    for (int i2 = 0; i2 < this._domain[0].length; ++i2) {
                        this._domain[0][i2] = Integer.toString(i2);
                    }
                }
            }
            for (int c2 : this._cat_cols) {
                this._domain[c2] = new String[this._createFrame.factors];
                for (int i3 = 0; i3 < this._createFrame.factors; ++i3) {
                    this._domain[c2][i3] = "c" + c2 + ".l" + i3;
                }
            }
        }
        int rows_per_chunk = FileVec.calcOptimalChunkSize((int)((double)((float)(catcols + intcols) * (float)this._createFrame.rows * 4.0f) + (double)((float)bincols * (float)this._createFrame.rows * 1.0f) * this._createFrame.binary_ones_fraction + (double)((float)(realcols + timecols + stringcols) * (float)this._createFrame.rows * 8.0f)), this._createFrame.cols, this._createFrame.cols * 4, H2ORuntime.availableProcessors(), H2O.getCloudSize(), false, true);
        this._v = Vec.makeCon((double)this._createFrame.value, this._createFrame.rows, (int)Math.ceil(Math.log1p(rows_per_chunk)), false);
    }

    public int nChunks() {
        return this._v.nChunks();
    }

    @Override
    public void compute2() {
        int i2;
        int totcols = this._createFrame.cols + (this._createFrame.has_response ? 1 : 0);
        Vec[] vecs = new Vec[totcols];
        if (this._createFrame.randomize) {
            byte[] types2 = new byte[vecs.length];
            for (int i3 : this._cat_cols) {
                types2[i3] = 4;
            }
            for (int i3 : this._bin_cols) {
                types2[i3] = 3;
            }
            for (int i3 : this._int_cols) {
                types2[i3] = 3;
            }
            for (int i3 : this._real_cols) {
                types2[i3] = 3;
            }
            for (int i3 : this._time_cols) {
                types2[i3] = 5;
            }
            for (int i3 : this._string_cols) {
                types2[i3] = 2;
            }
            if (this._createFrame.has_response) {
                types2[0] = this._createFrame.response_factors == 1 ? 3 : 4;
            }
            vecs = this._v.makeZeros(totcols, this._domain, types2);
        } else {
            for (int i4 = 0; i4 < vecs.length; ++i4) {
                vecs[i4] = this._v.makeCon(this._createFrame.value);
            }
        }
        this._v.remove();
        this._v = null;
        String[] names = new String[vecs.length];
        if (this._createFrame.has_response) {
            names[0] = "response";
            for (i2 = 1; i2 < vecs.length; ++i2) {
                names[i2] = "C" + i2;
            }
        } else {
            for (i2 = 0; i2 < vecs.length; ++i2) {
                names[i2] = "C" + (i2 + 1);
            }
        }
        this._out = new Frame(this._createFrame._job._result, names, vecs);
        assert (this._out.numRows() == this._createFrame.rows);
        assert (this._out.numCols() == totcols);
        this._out.delete_and_lock(this._createFrame._job._key);
        new FrameRandomizer(this._createFrame, this._cat_cols, this._int_cols, this._real_cols, this._bin_cols, this._time_cols, this._string_cols).doAll(this._out);
        FrameUtils.MissingInserter mi = new FrameUtils.MissingInserter(this._createFrame._job._result, this._createFrame.seed, this._createFrame.missing_fraction);
        mi.execImpl().get();
        this.tryComplete();
    }

    @Override
    public void onCompletion(CountedCompleter caller) {
        this._out.update(this._createFrame._job._key);
        this._out.unlock(this._createFrame._job._key);
    }

    private static class FrameRandomizer
    extends MRTask<FrameRandomizer> {
        private final CreateFrame _createFrame;
        private final int[] _cat_cols;
        private final int[] _int_cols;
        private final int[] _real_cols;
        private final int[] _bin_cols;
        private final int[] _time_cols;
        private final int[] _string_cols;

        public FrameRandomizer(CreateFrame createFrame, int[] cat_cols, int[] int_cols, int[] real_cols, int[] bin_cols, int[] time_cols, int[] string_cols) {
            this._createFrame = createFrame;
            this._cat_cols = cat_cols;
            this._int_cols = int_cols;
            this._real_cols = real_cols;
            this._bin_cols = bin_cols;
            this._time_cols = time_cols;
            this._string_cols = string_cols;
        }

        void setSeed(Random rng, int col, long row) {
            rng.setSeed(this._createFrame.seed + (long)this._createFrame.cols * row + (long)col);
            rng.setSeed(rng.nextLong());
        }

        @Override
        public void map(Chunk[] cs) {
            int r2;
            Job<Frame> job = this._createFrame._job;
            if (job.stop_requested()) {
                return;
            }
            if (!this._createFrame.randomize) {
                return;
            }
            RandomBase rng = RandomUtils.getRNG(new Random().nextLong());
            if (this._createFrame.has_response) {
                for (int r3 = 0; r3 < cs[0]._len; ++r3) {
                    this.setSeed(rng, 0, cs[0]._start + (long)r3);
                    if (this._createFrame.response_factors > 1) {
                        cs[0].set(r3, (int)(rng.nextDouble() * (double)this._createFrame.response_factors));
                        continue;
                    }
                    if (this._createFrame.positive_response) {
                        cs[0].set(r3, (double)this._createFrame.real_range * rng.nextDouble());
                        continue;
                    }
                    cs[0].set(r3, (double)this._createFrame.real_range * (1.0 - 2.0 * rng.nextDouble()));
                }
            }
            job.update(1L);
            for (int c2 : this._cat_cols) {
                for (r2 = 0; r2 < cs[c2]._len; ++r2) {
                    this.setSeed(rng, c2, cs[c2]._start + (long)r2);
                    cs[c2].set(r2, (int)(rng.nextDouble() * (double)this._createFrame.factors));
                }
            }
            job.update(1L);
            for (int c2 : this._int_cols) {
                for (r2 = 0; r2 < cs[c2]._len; ++r2) {
                    this.setSeed(rng, c2, cs[c2]._start + (long)r2);
                    cs[c2].set(r2, -this._createFrame.integer_range + (long)(rng.nextDouble() * (double)(2L * this._createFrame.integer_range + 1L)));
                }
            }
            job.update(1L);
            for (int c2 : this._real_cols) {
                for (r2 = 0; r2 < cs[c2]._len; ++r2) {
                    this.setSeed(rng, c2, cs[c2]._start + (long)r2);
                    cs[c2].set(r2, (double)this._createFrame.real_range * (1.0 - 2.0 * rng.nextDouble()));
                }
            }
            job.update(1L);
            for (int c2 : this._bin_cols) {
                for (r2 = 0; r2 < cs[c2]._len; ++r2) {
                    this.setSeed(rng, c2, cs[c2]._start + (long)r2);
                    cs[c2].set(r2, (double)rng.nextFloat() > this._createFrame.binary_ones_fraction ? 0L : 1L);
                }
            }
            job.update(1L);
            for (int c2 : this._time_cols) {
                for (r2 = 0; r2 < cs[c2]._len; ++r2) {
                    this.setSeed(rng, c2, cs[c2]._start + (long)r2);
                    cs[c2].set(r2, Math.abs(rng.nextLong() % 1576800000000L));
                }
            }
            job.update(1L);
            byte[] by2 = new byte[8];
            for (int c3 : this._string_cols) {
                for (int r4 = 0; r4 < cs[c3]._len; ++r4) {
                    this.setSeed(rng, c3, cs[c3]._start + (long)r4);
                    for (int i2 = 0; i2 < by2.length; ++i2) {
                        by2[i2] = (byte)(65 + rng.nextInt(25));
                    }
                    cs[c3].set(r4, new String(by2));
                }
            }
            job.update(1L);
        }
    }
}

