/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import water.AutoBuffer;
import water.DKV;
import water.Futures;
import water.H2O;
import water.Key;
import water.Keyed;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.ChunkVisitor;
import water.fvec.Vec;
import water.fvec.WrappedVec;
import water.util.ArrayUtils;
import water.util.IcedHashMap;
import water.util.IcedLong;

public class InteractionWrappedVec
extends WrappedVec {
    private final Key<Vec> _masterVecKey1;
    private final Key<Vec> _masterVecKey2;
    private transient Vec _masterVec1;
    private transient Vec _masterVec2;
    private String[] _v1Domain;
    private String[] _v2Domain;
    public boolean _useAllFactorLevels;
    public boolean _skipMissing;
    public boolean _standardize;
    private long[] _bins;
    private String[] _missingDomains;
    public transient GetMeanTask t;
    private String[] _v1Enums;
    private String[] _v2Enums;

    public InteractionWrappedVec(Key<Vec> key, int rowLayout, String[] vec1DomainLimit, String[] vec2DomainLimit, boolean useAllFactorLevels, boolean skipMissing, boolean standardize, Key<Vec> masterVecKey1, Key<Vec> masterVecKey2) {
        super(key, rowLayout, (Key<Vec>)null);
        this._masterVecKey1 = masterVecKey1;
        this._masterVecKey2 = masterVecKey2;
        this._v1Enums = vec1DomainLimit;
        this._v2Enums = vec2DomainLimit;
        this._masterVec1 = this._masterVecKey1.get();
        this._masterVec2 = this._masterVecKey2.get();
        this._useAllFactorLevels = useAllFactorLevels;
        this._skipMissing = skipMissing;
        this._standardize = standardize;
        this.setupDomain(this._standardize);
        DKV.put(this);
        if (this.t != null) {
            this.t.doAll(this);
        }
    }

    public String[] v1Domain() {
        return this._v1Enums == null ? this._v1Domain : this._v1Enums;
    }

    public String[] v2Domain() {
        return this._v2Enums == null ? this._v2Domain : this._v2Enums;
    }

    @Override
    public String[] domain() {
        String[] res1 = this.v1Domain();
        String[] res2 = this.v2Domain();
        return res1 == null ? res2 : (res2 == null ? res1 : super.domain());
    }

    public Vec v1() {
        return this._masterVec1 == null ? (this._masterVec1 = this._masterVecKey1.get()) : this._masterVec1;
    }

    public Vec v2() {
        return this._masterVec2 == null ? (this._masterVec2 = this._masterVecKey2.get()) : this._masterVec2;
    }

    public int expandedLength() {
        if (this.isNumericInteraction()) {
            return 1;
        }
        if (this.isCategorical()) {
            return this.domain().length;
        }
        if (this._v1Domain != null) {
            return this._v1Enums == null ? this._v1Domain.length - (this._useAllFactorLevels ? 0 : 1) : this._v1Enums.length - (this._useAllFactorLevels ? 0 : 1);
        }
        return this._v2Enums == null ? this._v2Domain.length - (this._useAllFactorLevels ? 0 : 1) : this._v2Enums.length - (this._useAllFactorLevels ? 0 : 1);
    }

    public double[] getMeans() {
        if (null != this._v1Domain && null != this._v2Domain) {
            double[] res = new double[this.domain().length];
            Arrays.fill(res, Double.NaN);
            return res;
        }
        if (null == this._v1Domain && null == this._v2Domain) {
            return new double[]{super.mean()};
        }
        return ((GetMeanTask)new GetMeanTask(this.v1Domain() == null ? this.v2Domain().length : this.v1Domain().length).doAll(this))._d;
    }

    public double getSub(int i2) {
        if (this.t == null) {
            return this.mean();
        }
        return this.t._d[i2];
    }

    public double getMul(int i2) {
        double sigma = this.t == null ? this.sigma() : this.t._sigma[i2];
        return sigma == 0.0 ? 1.0 : 1.0 / sigma;
    }

    public double getSigma(int i2) {
        return this.t == null ? this.sigma() : this.t._sigma[i2];
    }

    public boolean isNumericInteraction() {
        return null == this.v1Domain() && null == this.v2Domain();
    }

    @Override
    public double mean() {
        if (null == this.t && this.isNumericInteraction()) {
            return super.mean();
        }
        return 0.0;
    }

    @Override
    public double sigma() {
        if (null == this.t && this.isNumericInteraction()) {
            return super.sigma();
        }
        return 1.0;
    }

    @Override
    public int mode() {
        if (!this.isCategorical()) {
            if (this.v1Domain() != null) {
                assert (this.v2Domain() == null);
                return this._masterVec1.mode();
            }
            if (this.v2Domain() != null) {
                assert (this.v1Domain() == null);
                return this._masterVec2.mode();
            }
            throw H2O.unimpl();
        }
        return ArrayUtils.maxIndex(this._bins);
    }

    public long[] getBins() {
        return this._bins;
    }

    public String[] missingDomains() {
        return this._missingDomains;
    }

    private void setupDomain(boolean standardize) {
        if (this._masterVec1.isCategorical() || this._masterVec2.isCategorical()) {
            this._v1Domain = this._masterVec1.domain();
            this._v2Domain = this._masterVec2.domain();
            if (this._v1Domain != null && this._v2Domain != null) {
                CombineDomainTask t2 = (CombineDomainTask)new CombineDomainTask(this._v1Domain, this._v2Domain, this._v1Enums, this._v2Enums, this._useAllFactorLevels, this._skipMissing).doAll(this._masterVec1, this._masterVec2);
                this.setDomain(t2._dom);
                this._bins = t2._bins;
                this._type = (byte)4;
                this._missingDomains = t2._missingDom;
            } else {
                GetMeanTask getMeanTask = standardize ? new GetMeanTask(this.v1Domain() == null ? this.v2Domain().length : this.v1Domain().length) : (this.t = null);
            }
        }
        if (null == this._v1Domain && null == this._v2Domain) {
            this._useAllFactorLevels = true;
        }
    }

    @Override
    public Chunk chunkForChunkIdx(int cidx) {
        Chunk[] cs = new Chunk[]{(this._masterVec1 != null ? this._masterVec1 : (this._masterVec1 = this._masterVecKey1.get())).chunkForChunkIdx(cidx), (this._masterVec2 != null ? this._masterVec2 : (this._masterVec2 = this._masterVecKey2.get())).chunkForChunkIdx(cidx)};
        return new InteractionWrappedChunk(this, cs);
    }

    @Override
    public Vec doCopy() {
        InteractionWrappedVec v2 = new InteractionWrappedVec(this.group().addVec(), this._rowLayout, this._v1Enums, this._v2Enums, this._useAllFactorLevels, this._skipMissing, this._standardize, this._masterVecKey1, this._masterVecKey2);
        if (null != this.domain()) {
            v2.setDomain(this.domain());
        }
        if (null != this._v1Domain) {
            v2._v1Domain = (String[])this._v1Domain.clone();
        }
        if (null != this._v2Domain) {
            v2._v2Domain = (String[])this._v2Domain.clone();
        }
        return v2;
    }

    @Override
    protected AutoBuffer writeAll_impl(AutoBuffer ab) {
        ab.putAStr(this._v1Domain);
        ab.putAStr(this._v2Domain);
        ab.putZ(this._useAllFactorLevels);
        ab.putZ(this._skipMissing);
        ab.putZ(this._standardize);
        ab.putAStr(this._missingDomains);
        ab.putAStr(this._v1Enums);
        ab.putAStr(this._v2Enums);
        return super.writeAll_impl(ab);
    }

    @Override
    protected Keyed readAll_impl(AutoBuffer ab, Futures fs) {
        this._v1Domain = ab.getAStr();
        this._v2Domain = ab.getAStr();
        this._useAllFactorLevels = ab.getZ();
        this._skipMissing = ab.getZ();
        this._standardize = ab.getZ();
        this._missingDomains = ab.getAStr();
        this._v1Enums = ab.getAStr();
        this._v2Enums = ab.getAStr();
        return super.readAll_impl(ab, fs);
    }

    public static class InteractionWrappedChunk
    extends Chunk {
        public final transient Chunk[] _c;
        public final boolean _c1IsCat;
        public final boolean _c2IsCat;
        public final boolean _isCat;

        InteractionWrappedChunk(InteractionWrappedVec transformWrappedVec, Chunk[] c2) {
            this._c = c2;
            this.set_len(this._c[0]._len);
            this._start = this._c[0]._start;
            this._vec = transformWrappedVec;
            this._cidx = this._c[0]._cidx;
            this._c1IsCat = this._c[0]._vec.isCategorical();
            this._c2IsCat = this._c[1]._vec.isCategorical();
            this._isCat = this._vec.isCategorical();
        }

        @Override
        public double atd_impl(int idx) {
            if (this._isCat && this.isNA_impl(idx)) {
                return Double.NaN;
            }
            if (this._isCat) {
                int val = Arrays.binarySearch(this._vec.domain(), this.getKey(idx));
                return val < 0 ? -1 : val;
            }
            return (this._c1IsCat ? 1.0 : this._c[0].atd(idx)) * (this._c2IsCat ? 1.0 : this._c[1].atd(idx));
        }

        @Override
        public long at8_impl(int idx) {
            if (this._isCat) {
                long val = Arrays.binarySearch(this._vec.domain(), this.getKey(idx));
                return val < 0L ? -1L : val;
            }
            return (this._c1IsCat ? 1L : this._c[0].at8(idx)) * (this._c2IsCat ? 1L : this._c[1].at8(idx));
        }

        private String getKey(int idx) {
            return this._c[0]._vec.domain()[(int)this._c[0].at8(idx)] + "_" + this._c[1]._vec.domain()[(int)this._c[1].at8(idx)];
        }

        @Override
        public boolean isNA_impl(int idx) {
            return this._c[0].isNA(idx) || this._c[1].isNA(idx);
        }

        @Override
        public boolean set_impl(int idx, long l2) {
            return false;
        }

        @Override
        public boolean set_impl(int idx, double d2) {
            return false;
        }

        @Override
        public boolean set_impl(int idx, float f2) {
            return false;
        }

        @Override
        public boolean setNA_impl(int idx) {
            return false;
        }

        public ChunkVisitor processRows(ChunkVisitor nc, int from, int to) {
            for (int i2 = from; i2 < to; ++i2) {
                nc.addValue(this.atd(i2));
            }
            return nc;
        }

        public ChunkVisitor processRows(ChunkVisitor nc, int ... rows) {
            for (int i2 : rows) {
                nc.addValue(this.atd(i2));
            }
            return nc;
        }

        @Override
        protected final void initFromBytes() {
            throw H2O.fail();
        }
    }

    private static class CombineDomainTask
    extends MRTask<CombineDomainTask> {
        private String[] _dom;
        private long[] _bins;
        private String[] _missingDom;
        private final String[] _left;
        private final String[] _rite;
        private final String[] _leftLimit;
        private final String[] _riteLimit;
        private final boolean _useAllLvls;
        private final boolean _skipMissing;
        private IcedHashMap<String, IcedLong> _perChkMap;
        private IcedHashMap<String, String> _perChkMapMissing;

        CombineDomainTask(String[] left, String[] rite, String[] leftLimit, String[] riteLimit, boolean useAllLvls, boolean skipMissing) {
            this._left = left;
            this._rite = rite;
            this._leftLimit = leftLimit;
            this._riteLimit = riteLimit;
            this._useAllLvls = useAllLvls;
            this._skipMissing = skipMissing;
        }

        @Override
        public void map(Chunk[] c2) {
            HashSet B2;
            this._perChkMap = new IcedHashMap();
            if (!this._useAllLvls) {
                this._perChkMapMissing = new IcedHashMap();
            }
            Chunk left = c2[0];
            Chunk rite = c2[1];
            HashSet A2 = this._leftLimit == null ? null : new HashSet();
            HashSet hashSet = B2 = this._riteLimit == null ? null : new HashSet();
            if (A2 != null) {
                Collections.addAll(A2, this._leftLimit);
            }
            if (B2 != null) {
                Collections.addAll(B2, this._riteLimit);
            }
            for (int i2 = 0; i2 < left._len; ++i2) {
                String k2;
                String r2;
                String l2;
                int rval;
                int lval;
                boolean riteIsNA;
                boolean leftIsNA = left.isNA(i2);
                if (!(leftIsNA | (riteIsNA = rite.isNA(i2)))) {
                    lval = (int)left.at8(i2);
                    rval = (int)rite.at8(i2);
                    if (!(this._useAllLvls || 0 != lval && 0 != rval)) {
                        this._perChkMapMissing.putIfAbsent(this._left[lval] + "_" + this._rite[rval], "");
                        continue;
                    }
                    l2 = this._left[lval];
                    r2 = this._rite[rval];
                    if (A2 != null && !A2.contains(l2) || B2 != null && !B2.contains(r2) || null == this._perChkMap.putIfAbsent(k2 = l2 + "_" + r2, new IcedLong(1L))) continue;
                    ++((IcedLong)this._perChkMap.get((Object)k2))._val;
                    continue;
                }
                if (this._skipMissing || leftIsNA && riteIsNA) continue;
                if (leftIsNA) {
                    rval = (int)rite.at8(i2);
                    r2 = this._rite[rval];
                    if (!this._useAllLvls && 0 == rval) {
                        this._perChkMapMissing.putIfAbsent("NA_" + this._rite[rval], "");
                        continue;
                    }
                    if (B2 != null && !B2.contains(r2) || null == this._perChkMap.putIfAbsent(k2 = "NA_" + r2, new IcedLong(1L))) continue;
                    ++((IcedLong)this._perChkMap.get((Object)k2))._val;
                    continue;
                }
                lval = (int)left.at8(i2);
                l2 = this._left[lval];
                if (!this._useAllLvls && 0 == lval) {
                    this._perChkMapMissing.putIfAbsent(this._left[lval] + "_NA", "");
                    continue;
                }
                if (null != A2 && !A2.contains(l2) || null == this._perChkMap.putIfAbsent(k2 = l2 + "_NA", new IcedLong(1L))) continue;
                ++((IcedLong)this._perChkMap.get((Object)k2))._val;
            }
        }

        @Override
        public void reduce(CombineDomainTask t2) {
            for (Map.Entry e2 : t2._perChkMap.entrySet()) {
                IcedLong i2 = (IcedLong)this._perChkMap.get(e2.getKey());
                if (i2 != null) {
                    i2._val += ((IcedLong)e2.getValue())._val;
                    continue;
                }
                this._perChkMap.put((String)e2.getKey(), (IcedLong)e2.getValue());
            }
            t2._perChkMap = null;
            if (this._perChkMapMissing == null && t2._perChkMapMissing != null) {
                this._perChkMapMissing = new IcedHashMap();
                this._perChkMapMissing.putAll(t2._perChkMapMissing);
            } else if (this._perChkMapMissing != null && t2._perChkMapMissing != null) {
                for (String s2 : t2._perChkMapMissing.keySet()) {
                    this._perChkMapMissing.putIfAbsent(s2, "");
                }
            }
            t2._perChkMapMissing = null;
        }

        @Override
        public void postGlobal() {
            this._dom = this._perChkMap.keySet().toArray(new String[this._perChkMap.size()]);
            Arrays.sort(this._dom);
            int idx = 0;
            this._bins = new long[this._perChkMap.size()];
            for (String s2 : this._dom) {
                this._bins[idx++] = ((IcedLong)this._perChkMap.get((Object)s2))._val;
            }
            if (this._missingDom != null) {
                this._missingDom = this._perChkMapMissing.keySet().toArray(new String[this._perChkMapMissing.size()]);
                Arrays.sort(this._missingDom);
            }
        }
    }

    private static class GetMeanTask
    extends MRTask<GetMeanTask> {
        private double[] _d;
        private double[] _sigma;
        private long _rows;
        private final int _len;

        GetMeanTask(int len) {
            this._len = len;
        }

        @Override
        public void map(Chunk c2) {
            this._d = new double[this._len];
            this._sigma = new double[this._len];
            InteractionWrappedChunk cc = (InteractionWrappedChunk)c2;
            Chunk lC = cc._c[0];
            Chunk rC = cc._c[1];
            if (cc._c2IsCat) {
                lC = rC;
                rC = cc._c[0];
            }
            long rows = 0L;
            for (int rid = 0; rid < c2._len; ++rid) {
                if (lC.isNA(rid) || rC.isNA(rid)) continue;
                int idx = (int)lC.at8(rid);
                ++rows;
                for (int i2 = 0; i2 < this._d.length; ++i2) {
                    double x2 = i2 == idx ? rC.atd(rid) : 0.0;
                    double delta = x2 - this._d[i2];
                    int n2 = i2;
                    this._d[n2] = this._d[n2] + delta / (double)rows;
                    int n3 = i2;
                    this._sigma[n3] = this._sigma[n3] + delta * (x2 - this._d[i2]);
                }
            }
            this._rows = rows;
        }

        @Override
        public void reduce(GetMeanTask t2) {
            if (this._rows == 0L) {
                this._d = t2._d;
                this._sigma = t2._sigma;
            } else if (t2._rows != 0L) {
                for (int i2 = 0; i2 < this._d.length; ++i2) {
                    double delta = this._d[i2] - t2._d[i2];
                    this._d[i2] = (this._d[i2] * (double)this._rows + t2._d[i2] * (double)t2._rows) / (double)(this._rows + t2._rows);
                    int n2 = i2;
                    this._sigma[n2] = this._sigma[n2] + (t2._sigma[i2] + delta * delta * (double)this._rows * (double)t2._rows / (double)(this._rows + t2._rows));
                }
            }
            this._rows += t2._rows;
        }

        @Override
        public void postGlobal() {
            for (int i2 = 0; i2 < this._sigma.length; ++i2) {
                this._sigma[i2] = Math.sqrt(this._sigma[i2] / (double)(this._rows - 1L));
            }
        }
    }
}

