/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import java.io.File;
import java.io.IOException;
import water.DKV;
import water.Futures;
import water.Key;
import water.fvec.FileVec;
import water.fvec.Vec;
import water.persist.PersistNFS;
import water.util.FileUtils;

public class NFSFileVec
extends FileVec {
    public static NFSFileVec make(File f2) {
        Futures fs = new Futures();
        NFSFileVec nfs = NFSFileVec.make(f2, fs);
        fs.blockForPending();
        return nfs;
    }

    public static NFSFileVec make(String fname) throws IOException {
        File f2 = FileUtils.getFile(fname);
        return NFSFileVec.make(f2);
    }

    public static NFSFileVec make(File f2, Futures fs) {
        if (!f2.exists()) {
            throw new IllegalArgumentException("File not found: " + f2.toString());
        }
        long size = f2.length();
        Key<Vec> k2 = Vec.newKey(PersistNFS.decodeFile(f2));
        NFSFileVec nfs = new NFSFileVec(k2, size);
        DKV.put(k2, nfs, fs);
        return nfs;
    }

    private NFSFileVec(Key key, long len) {
        super(key, len, (byte)4);
    }
}

