/*
 * Decompiled with CFR 0.152.
 */
package water.fvec.task;

import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Vec;
import water.util.IcedDouble;
import water.util.IcedHashSet;

public class UniqTask
extends MRTask<UniqTask> {
    private IcedHashSet<IcedDouble> _uniq;
    private boolean _na;

    @Override
    public void map(Chunk[] c2) {
        this._uniq = new IcedHashSet();
        double prev = Double.NaN;
        for (int i2 = 0; i2 < c2[0]._len; ++i2) {
            double val = c2[0].atd(i2);
            if (Double.isNaN(val)) {
                this._na = true;
                continue;
            }
            if (val == prev) continue;
            prev = val;
            this._uniq.addIfAbsent(new IcedDouble(val));
        }
    }

    @Override
    public void reduce(UniqTask t2) {
        IcedHashSet<IcedDouble> l2 = this._uniq;
        IcedHashSet<IcedDouble> r2 = t2._uniq;
        if (l2.size() < r2.size()) {
            l2 = r2;
            r2 = this._uniq;
        }
        for (IcedDouble rg : r2) {
            l2.addIfAbsent(rg);
        }
        this._uniq = l2;
        this._na = this._na || t2._na;
        t2._uniq = null;
    }

    public double[] toArray() {
        int size = this._uniq.size();
        double[] res = new double[size + (this._na ? 1 : 0)];
        int i2 = 0;
        if (this._na) {
            res[i2++] = Double.NaN;
        }
        for (IcedDouble d2 : this._uniq) {
            res[i2++] = d2._val;
        }
        assert (i2 == res.length);
        return res;
    }

    public Vec toVec() {
        final double[] uniq = this.toArray();
        Vec v2 = Vec.makeZero((long)uniq.length, this._fr.vec(0).get_type());
        new MRTask(){

            @Override
            public void map(Chunk c2) {
                int start = (int)c2.start();
                for (int i2 = 0; i2 < c2._len; ++i2) {
                    c2.set(i2, uniq[i2 + start]);
                }
            }
        }.doAll(v2);
        return v2;
    }
}

