/*
 * Decompiled with CFR 0.152.
 */
package water.hive;

import hex.genmodel.utils.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;
import water.AbstractH2OExtension;
import water.H2O;
import water.Key;
import water.api.SaveToHiveTableHandler;
import water.fvec.Frame;
import water.fvec.Vec;
import water.hive.FrameParquetWriter;
import water.hive.HiveTableImporterImpl;
import water.jdbc.SQLManager;
import water.persist.Persist;
import water.persist.PersistHdfs;

public class HiveFrameSaverImpl
extends AbstractH2OExtension
implements SaveToHiveTableHandler.HiveFrameSaver {
    private static final Logger LOG = Logger.getLogger(HiveTableImporterImpl.class);
    private static final String SQL_DESCRIBE_TABLE = "DESCRIBE %s";

    @Override
    public String getExtensionName() {
        return "HiveFrameSaver";
    }

    @Override
    public void saveFrameToHive(Key<Frame> frameKey, String jdbcUrl, String tableName, SaveToHiveTableHandler.HiveFrameSaver.Format format, String configuredTablePath, String configuredTmpPath) {
        String filePath = null;
        try {
            String tmpPath = this.determineTmpPath(configuredTmpPath);
            String storagePath = this.addHdfsPrefixToPath(configuredTablePath);
            filePath = new Path(tmpPath, this.getRandomFileName(format)).toString();
            LOG.info((Object)("Save frame " + frameKey + " to table " + tableName + " in " + jdbcUrl));
            Frame frame = frameKey.get();
            if (frame == null) {
                throw new IllegalArgumentException("Frame with key " + frameKey + " not found.");
            }
            this.writeFrameToHdfs(frame, filePath, format);
            this.loadDataIntoTable(jdbcUrl, tableName, storagePath, frame, filePath, format);
            if (filePath != null) {
                this.safelyRemoveDataFile(filePath);
            }
        }
        catch (IOException e2) {
            try {
                throw new RuntimeException("Writing to Hive failed: " + e2.getMessage(), e2);
            }
            catch (Throwable throwable) {
                if (filePath != null) {
                    this.safelyRemoveDataFile(filePath);
                }
                throw throwable;
            }
        }
    }

    private String determineTmpPath(String configuredTmpPath) throws IOException {
        if (configuredTmpPath == null) {
            FileSystem fs = FileSystem.get((Configuration)PersistHdfs.CONF);
            String res = fs.getUri().toString() + "/tmp";
            LOG.info((Object)("Using default temporary directory " + res));
            return res;
        }
        return this.addHdfsPrefixToPath(configuredTmpPath);
    }

    private String addHdfsPrefixToPath(String path) throws IOException {
        if (path == null) {
            return null;
        }
        if (!path.startsWith("hdfs://")) {
            FileSystem fs = FileSystem.get((Configuration)PersistHdfs.CONF);
            String res = fs.getUri().toString() + "/" + path;
            LOG.info((Object)("Adding file system prefix to relative tmp_path " + res));
            return res;
        }
        return path;
    }

    private String getRandomFileName(SaveToHiveTableHandler.HiveFrameSaver.Format format) {
        return "h2o_save_to_hive_" + UUID.randomUUID().toString() + "." + format.toString().toLowerCase();
    }

    private void safelyRemoveDataFile(String filePath) {
        try {
            Persist p2 = H2O.getPM().getPersistForURI(URI.create(filePath));
            if (p2.exists(filePath)) {
                p2.delete(filePath);
            } else {
                LOG.debug((Object)"Data file moved by Hive, doing nothing.");
            }
        }
        catch (Exception e2) {
            LOG.error((Object)"Failed cleaning up data file.", (Throwable)e2);
        }
    }

    private void writeFrameToHdfs(Frame frame, String filePath, SaveToHiveTableHandler.HiveFrameSaver.Format format) throws IOException {
        switch (format) {
            case CSV: {
                this.writeFrameAsCsv(frame, filePath);
                break;
            }
            case PARQUET: {
                this.writeFrameAsParquet(frame, filePath);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported table format " + (Object)((Object)format));
            }
        }
    }

    private void writeFrameAsParquet(Frame frame, String filePath) throws IOException {
        new FrameParquetWriter().write(frame, filePath);
    }

    private void writeFrameAsCsv(Frame f2, String filePath) throws IOException {
        Persist p2 = H2O.getPM().getPersistForURI(URI.create(filePath));
        try (OutputStream os2 = p2.create(filePath, false);){
            Frame.CSVStreamParams parms = new Frame.CSVStreamParams().setHeaders(false).setEscapeQuotes(true).setEscapeChar('\\');
            InputStream is = f2.toCSV(parms);
            IOUtils.copyStream(is, os2);
        }
    }

    private void loadDataIntoTable(String url, String table, String tablePath, Frame frame, String filePath, SaveToHiveTableHandler.HiveFrameSaver.Format format) throws IOException {
        try (Connection conn = SQLManager.getConnectionSafe(url, null, null);){
            if (this.doesTableExist(conn, table)) {
                throw new IllegalArgumentException("Table " + table + " already exists.");
            }
            this.createTable(conn, table, tablePath, frame, format);
            this.executeDataLoad(conn, table, filePath);
        }
        catch (SQLException e2) {
            throw new IOException("Failed to load data into Hive table: " + e2.getMessage(), e2);
        }
    }

    /*
     * Exception decompiling
     */
    private boolean doesTableExist(Connection conn, String table) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void createTable(Connection conn, String table, String tablePath, Frame frame, SaveToHiveTableHandler.HiveFrameSaver.Format format) throws SQLException {
        try (Statement stmt2 = conn.createStatement();){
            String createQuery = this.makeCreateTableStatement(table, tablePath, frame, format);
            LOG.info((Object)("Creating Hive table " + table + " with SQL: " + createQuery));
            stmt2.execute(createQuery);
        }
    }

    private String makeCreateTableStatement(String table, String tablePath, Frame frame, SaveToHiveTableHandler.HiveFrameSaver.Format format) {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE ");
        if (tablePath != null) {
            sb.append("EXTERNAL ");
        }
        sb.append("TABLE ").append(table).append(" (");
        switch (format) {
            case CSV: {
                this.makeCreateCSVTableStatement(sb, frame);
                break;
            }
            case PARQUET: {
                this.makeCreateParquetTableStatement(sb, frame);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported table format " + (Object)((Object)format));
            }
        }
        if (tablePath != null) {
            sb.append("\nLOCATION '").append(tablePath).append("'");
        }
        return sb.toString();
    }

    private void makeCreateCSVTableStatement(StringBuilder sb, Frame frame) {
        for (int i2 = 0; i2 < frame.numCols(); ++i2) {
            if (i2 > 0) {
                sb.append(",\n");
            }
            sb.append(frame.name(i2)).append(" string");
        }
        sb.append(") ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.OpenCSVSerde'\n").append("WITH SERDEPROPERTIES (\n").append("   \"separatorChar\" = \",\",\n").append("   \"quoteChar\"     = \"\\\"\",\n").append("   \"escapeChar\"    = \"\\\\\") STORED AS TEXTFILE");
    }

    private void makeCreateParquetTableStatement(StringBuilder sb, Frame frame) {
        for (int i2 = 0; i2 < frame.numCols(); ++i2) {
            if (i2 > 0) {
                sb.append(",\n");
            }
            sb.append(frame.name(i2)).append(" ").append(this.sqlDataType(frame.vec(i2)));
        }
        sb.append(") STORED AS parquet");
    }

    private String sqlDataType(Vec v2) {
        if (v2.isCategorical() || v2.isUUID() || v2.isString()) {
            return "STRING";
        }
        if (v2.isInt()) {
            return "BIGINT";
        }
        return "DOUBLE";
    }

    private void executeDataLoad(Connection conn, String table, String filePath) throws SQLException {
        try (Statement stmt2 = conn.createStatement();){
            LOG.info((Object)("Loading data file " + filePath + " into table " + table));
            stmt2.execute("LOAD DATA INPATH '" + filePath + "' OVERWRITE INTO TABLE " + table);
        }
    }
}

