/*
 * Decompiled with CFR 0.152.
 */
package water.hive;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import water.hive.HiveMetaData;
import water.jdbc.SQLManager;
import water.util.JSONUtils;

public class JdbcHiveMetadata
implements HiveMetaData {
    private static final Logger LOG = Logger.getLogger(JdbcHiveMetadata.class);
    private static final String SQL_SET_JSON_OUTPUT = "set hive.ddl.output.format=json";
    private static final String SQL_GET_VERSION = "select version()";
    private static final String SQL_DESCRIBE_TABLE = "DESCRIBE EXTENDED %s";
    private static final String SQL_DESCRIBE_PARTITION = "DESCRIBE EXTENDED %s PARTITION ";
    private static final String SQL_SHOW_PARTS = "SHOW PARTITIONS %s";
    private final String url;

    public JdbcHiveMetadata(String url) {
        this.url = url;
    }

    /*
     * Exception decompiling
     */
    private String executeQuery(Connection conn, String query) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Map<String, Object> executeAndParseJsonResultSet(Connection conn, String queryPattern, String tableName) throws SQLException {
        String query = String.format(queryPattern, tableName);
        LOG.info((Object)("Executing Hive metadata query " + query));
        String json = this.executeQuery(conn, query);
        return JSONUtils.parse(json);
    }

    @Override
    public HiveMetaData.Table getTable(String tableName) throws SQLException {
        try (Connection conn = SQLManager.getConnectionSafe(this.url, null, null);){
            try (Statement stmt2 = conn.createStatement();){
                stmt2.execute(SQL_SET_JSON_OUTPUT);
            }
            HiveMetaData.Table table = this.getTable(conn, tableName);
            return table;
        }
    }

    private HiveMetaData.Table getTable(Connection conn, String name) throws SQLException {
        Map<String, Object> tableData = this.executeAndParseJsonResultSet(conn, SQL_DESCRIBE_TABLE, name);
        List<HiveMetaData.Column> columns = this.readColumns((List)tableData.get("columns"));
        Map tableInfo = (Map)tableData.get("tableInfo");
        List<HiveMetaData.Column> partitionKeys = this.readPartitionKeys(tableInfo);
        columns = columns.subList(0, columns.size() - partitionKeys.size());
        List<HiveMetaData.Partition> partitions = this.readPartitions(conn, name, partitionKeys);
        StorableMetadata storableData = this.readStorableMetadata(tableInfo);
        return new JdbcTable(name, storableData, columns, partitions, partitionKeys);
    }

    private String getHiveVersionMajor(Connection conn) {
        try {
            String versionStr = this.executeQuery(conn, SQL_GET_VERSION);
            return versionStr.substring(0, 1);
        }
        catch (SQLException e2) {
            return "1";
        }
    }

    private StorableMetadata readStorableMetadata(Map<String, Object> tableInfo) {
        StorableMetadata res = new StorableMetadata();
        Map sd = (Map)tableInfo.get("sd");
        res.location = (String)sd.get("location");
        res.inputFormat = (String)sd.get("inputFormat");
        Map serDeInfo = (Map)sd.get("serdeInfo");
        res.serializationLib = (String)serDeInfo.get("serializationLib");
        res.serDeParams = (Map)serDeInfo.get("parameters");
        return res;
    }

    private List<HiveMetaData.Partition> readPartitions(Connection conn, String tableName, List<HiveMetaData.Column> partitionKeys) throws SQLException {
        if (partitionKeys.isEmpty()) {
            return Collections.emptyList();
        }
        Map<String, Object> partitionsResult = this.executeAndParseJsonResultSet(conn, SQL_SHOW_PARTS, tableName);
        String hiveVersion = this.getHiveVersionMajor(conn);
        ArrayList<HiveMetaData.Partition> partitions = new ArrayList<HiveMetaData.Partition>();
        List partitionsData = (List)partitionsResult.get("partitions");
        for (Map partition : partitionsData) {
            List<String> values = this.parsePartitionValues(partition, hiveVersion);
            StorableMetadata data = this.readPartitionMetadata(conn, tableName, partitionKeys, values);
            partitions.add(new JdbcPartition(data, values));
        }
        return partitions;
    }

    private StorableMetadata readPartitionMetadata(Connection conn, String tableName, List<HiveMetaData.Column> partitionKeys, List<String> values) throws SQLException {
        String query = this.getDescribePartitionQuery(partitionKeys, values);
        Map<String, Object> data = this.executeAndParseJsonResultSet(conn, query, tableName);
        Map info = (Map)data.get("partitionInfo");
        return this.readStorableMetadata(info);
    }

    private String getDescribePartitionQuery(List<HiveMetaData.Column> partitionKeys, List<String> values) {
        StringBuilder sb = new StringBuilder();
        sb.append(SQL_DESCRIBE_PARTITION).append("(");
        for (int i2 = 0; i2 < partitionKeys.size(); ++i2) {
            if (i2 > 0) {
                sb.append(", ");
            }
            String escapedValue = values.get(i2).replace("\"", "\\\"");
            sb.append(partitionKeys.get(i2).getName()).append("=\"").append(escapedValue).append("\"");
        }
        sb.append(")");
        return sb.toString();
    }

    private String unescapePartitionValue(String value, String hiveVersion) {
        if (!"1".equals(hiveVersion)) {
            return value;
        }
        return value.replace("\\\"", "\"");
    }

    private List<String> parsePartitionValues(Map<String, Object> partition, String hiveVersion) {
        ArrayList<String> values = new ArrayList<String>();
        List valuesData = (List)partition.get("values");
        for (Map valueRecord : valuesData) {
            String value = this.unescapePartitionValue((String)valueRecord.get("columnValue"), hiveVersion);
            values.add(value);
        }
        return values;
    }

    private List<HiveMetaData.Column> readPartitionKeys(Map<String, Object> tableInfo) {
        if (!tableInfo.containsKey("partitionKeys")) {
            return Collections.emptyList();
        }
        List partitionColumns = (List)tableInfo.get("partitionKeys");
        return this.readColumns(partitionColumns);
    }

    private List<HiveMetaData.Column> readColumns(List<Map<String, Object>> columnDataList) {
        ArrayList<HiveMetaData.Column> columns = new ArrayList<HiveMetaData.Column>();
        for (Map<String, Object> column : columnDataList) {
            columns.add(new JdbcColumn((String)column.get("name"), (String)column.get("type")));
        }
        return columns;
    }

    static class JdbcTable
    extends JdbcStorable
    implements HiveMetaData.Table {
        private final String name;
        private final List<HiveMetaData.Partition> partitions;
        private final List<HiveMetaData.Column> columns;
        private final List<HiveMetaData.Column> partitionKeys;

        public JdbcTable(String name, StorableMetadata meta, List<HiveMetaData.Column> columns, List<HiveMetaData.Partition> partitions, List<HiveMetaData.Column> partitionKeys) {
            super(meta);
            this.name = name;
            this.partitions = partitions;
            this.columns = columns;
            this.partitionKeys = partitionKeys;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean hasPartitions() {
            return !this.partitionKeys.isEmpty();
        }

        @Override
        public List<HiveMetaData.Partition> getPartitions() {
            return this.partitions;
        }

        @Override
        public List<HiveMetaData.Column> getColumns() {
            return this.columns;
        }

        @Override
        public List<HiveMetaData.Column> getPartitionKeys() {
            return this.partitionKeys;
        }
    }

    static class JdbcColumn
    implements HiveMetaData.Column {
        private final String name;
        private final String type;

        JdbcColumn(String name, String type) {
            this.name = name;
            this.type = type;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getType() {
            return this.type;
        }
    }

    static class JdbcPartition
    extends JdbcStorable
    implements HiveMetaData.Partition {
        private final List<String> values;

        JdbcPartition(StorableMetadata meta, List<String> values) {
            super(meta);
            this.values = values;
        }

        @Override
        public List<String> getValues() {
            return this.values;
        }
    }

    static class JdbcStorable
    implements HiveMetaData.Storable {
        private final String location;
        private final String serializationLib;
        private final String inputFormat;
        private final Map<String, String> serDeParams;

        JdbcStorable(StorableMetadata data) {
            this.location = data.location;
            this.serializationLib = data.serializationLib;
            this.inputFormat = data.inputFormat;
            this.serDeParams = data.serDeParams;
        }

        @Override
        public Map<String, String> getSerDeParams() {
            return this.serDeParams;
        }

        @Override
        public String getLocation() {
            return this.location;
        }

        @Override
        public String getSerializationLib() {
            return this.serializationLib;
        }

        @Override
        public String getInputFormat() {
            return this.inputFormat;
        }
    }

    static class StorableMetadata {
        String location;
        String serializationLib;
        String inputFormat;
        Map<String, String> serDeParams = Collections.emptyMap();

        StorableMetadata() {
        }
    }
}

