/*
 * Decompiled with CFR 0.152.
 */
package water.init;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import water.util.Log;

public abstract class JarHash {
    static final String JARPATH = JarHash.cl_init_jarpath();
    public static final byte[] JARHASH = JarHash.cl_init_md5(JARPATH);
    private static final ArrayList<File> RESOURCE_FILES = new ArrayList();

    private static String cl_init_jarpath() {
        try {
            String ownJar = JarHash.class.getProtectionDomain().getCodeSource().getLocation().getPath();
            if (ownJar.endsWith(".jar")) {
                return URLDecoder.decode(ownJar, "UTF-8");
            }
            if (!ownJar.endsWith(".jar/")) {
                return null;
            }
            String stem = "h2o.jar";
            File f2 = new File(ownJar + stem);
            if (!f2.exists()) {
                return null;
            }
            return URLDecoder.decode(ownJar + stem, "UTF-8");
        }
        catch (IOException ie) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] cl_init_md5(String jarpath) {
        byte[] ffHash = new byte[16];
        Arrays.fill(ffHash, (byte)-1);
        if (jarpath == null) {
            return ffHash;
        }
        FileInputStream is = null;
        try {
            int pos;
            is = new FileInputStream(jarpath);
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] buf = new byte[4096];
            while ((pos = ((InputStream)is).read(buf)) > 0) {
                md5.update(buf, 0, pos);
            }
            byte[] byArray = md5.digest();
            return byArray;
        }
        catch (IOException | NoSuchAlgorithmException e2) {
            Log.err(e2);
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException iOException) {}
        }
        return ffHash;
    }

    public static void registerResourceRoot(File f2) {
        if (f2.exists()) {
            RESOURCE_FILES.add(f2);
        }
    }

    public static InputStream getResource2(String uri) {
        try {
            for (File f2 : RESOURCE_FILES) {
                File f22 = new File(f2, uri);
                if (!f22.exists()) continue;
                return new FileInputStream(f22);
            }
            ClassLoader cl = ClassLoader.getSystemClassLoader();
            InputStream is = JarHash.loadResource(uri, cl);
            if (is == null && (cl = Thread.currentThread().getContextClassLoader()) != null) {
                is = JarHash.loadResource(uri, cl);
            }
            if (is == null && (cl = JarHash.class.getClassLoader()) != null) {
                is = JarHash.loadResource(uri, cl);
            }
            if (is != null) {
                return is;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        Log.warn("Resource not found: " + uri);
        return null;
    }

    private static InputStream loadResource(String uri, ClassLoader cl) {
        Log.trace("Trying to load resource " + uri + " via classloader " + cl);
        InputStream is = cl.getResourceAsStream("resources/www" + uri);
        if (is != null) {
            return is;
        }
        is = cl.getResourceAsStream("resources/main/www" + uri);
        if (is != null) {
            return is;
        }
        is = cl.getResourceAsStream("www" + uri);
        return is;
    }

    public static List<String> getResourcesList(String path) {
        HashSet<String> resList = new HashSet<String>();
        try {
            URL classUrl = JarHash.class.getResource("/water/H2O.class");
            if (classUrl != null && classUrl.getProtocol().equals("jar")) {
                String jarPath = classUrl.getPath().substring(5, classUrl.getPath().indexOf("!"));
                JarFile jar = new JarFile(URLDecoder.decode(jarPath, "UTF-8"));
                Enumeration<JarEntry> files = jar.entries();
                while (files.hasMoreElements()) {
                    String fName = files.nextElement().getName();
                    if (!fName.startsWith(path + "/")) continue;
                    String resourceName = fName.substring((path + "/").length());
                    int checkSubdir = resourceName.indexOf("/");
                    if (checkSubdir >= 0) {
                        resourceName = resourceName.substring(0, checkSubdir);
                    }
                    if (resourceName.length() <= 0) continue;
                    resList.add(resourceName);
                }
            } else {
                BufferedReader resources = new BufferedReader(new InputStreamReader(JarHash.class.getResourceAsStream("/gaid")));
                if (resources != null) {
                    String resourceName;
                    while ((resourceName = resources.readLine()) != null) {
                        if (resourceName.length() <= 0) continue;
                        resList.add(resourceName);
                    }
                }
            }
        }
        catch (Exception ignore) {
            Log.debug("Failed in reading gaid resources.");
        }
        return new ArrayList<String>(resList);
    }
}

