/*
 * Decompiled with CFR 0.152.
 */
package water.init;

import water.H2ORuntime;
import water.util.ArrayUtils;
import water.util.Log;
import water.util.Timer;

public class Linpack {
    double second_orig = -1.0;

    public static void main(String[] args) {
        int num_threads = H2ORuntime.availableProcessors();
        double sumgflops = Linpack.run(num_threads);
        Log.info("CPU speed (" + num_threads + " cores) : " + sumgflops + " Gflops.");
    }

    public static double run(int num_threads) {
        int t2;
        final double[] gflops = new double[num_threads];
        Thread[] threads = new Thread[num_threads];
        for (t2 = 0; t2 < num_threads; ++t2) {
            final int thread_num = t2;
            threads[t2] = new Thread(){

                @Override
                public void run() {
                    Linpack l2 = new Linpack();
                    gflops[thread_num] = l2.run_benchmark();
                }
            };
        }
        for (t2 = 0; t2 < num_threads; ++t2) {
            threads[t2].start();
        }
        for (t2 = 0; t2 < num_threads; ++t2) {
            try {
                threads[t2].join();
                continue;
            }
            catch (InterruptedException e2) {
                Thread.currentThread().interrupt();
            }
        }
        return ArrayUtils.sum(gflops);
    }

    final double abs(double d2) {
        return d2 >= 0.0 ? d2 : -d2;
    }

    double second() {
        if (this.second_orig == -1.0) {
            this.second_orig = System.currentTimeMillis();
        }
        return ((double)System.currentTimeMillis() - this.second_orig) / 1000.0;
    }

    public double run_benchmark() {
        int i2;
        int info;
        double gflops_result = 0.0;
        double residn_result = 0.0;
        double time_result = 0.0;
        double eps_result = 0.0;
        double[][] a2 = new double[200][201];
        double[] b2 = new double[200];
        double[] x2 = new double[200];
        int[] ipvt = new int[200];
        int lda = 201;
        int ldaa = 200;
        double cray = 0.056;
        int n2 = 200;
        double ops = 2.0 * (double)(n2 * n2 * n2) / 3.0 + 2.0 * (double)(n2 * n2);
        double norma = this.matgen(a2, lda, n2, b2);
        int repeats = 200;
        for (int r2 = 0; r2 < 10; ++r2) {
            info = this.dgefa(a2, lda, n2, ipvt);
            this.dgesl(a2, lda, n2, ipvt, b2, 0);
        }
        Timer timer = new Timer();
        for (int r3 = 0; r3 < repeats; ++r3) {
            info = this.dgefa(a2, lda, n2, ipvt);
            this.dgesl(a2, lda, n2, ipvt, b2, 0);
        }
        double total = (double)timer.time() / 1000.0;
        for (i2 = 0; i2 < n2; ++i2) {
            x2[i2] = b2[i2];
        }
        norma = this.matgen(a2, lda, n2, b2);
        for (i2 = 0; i2 < n2; ++i2) {
            b2[i2] = -b2[i2];
        }
        this.dmxpy(n2, b2, n2, lda, x2, a2);
        double resid = 0.0;
        double normx = 0.0;
        for (i2 = 0; i2 < n2; ++i2) {
            resid = resid > this.abs(b2[i2]) ? resid : this.abs(b2[i2]);
            normx = normx > this.abs(x2[i2]) ? normx : this.abs(x2[i2]);
        }
        eps_result = this.epslon(1.0);
        residn_result = resid / ((double)n2 * norma * normx * eps_result);
        residn_result += 0.005;
        residn_result = (int)(residn_result * 100.0);
        residn_result /= 100.0;
        time_result = total;
        time_result += 0.005;
        time_result = (int)(time_result * 100.0);
        time_result /= 100.0;
        gflops_result = ops / (1.0E9 * total) * (double)repeats;
        gflops_result += 5.0E-4;
        gflops_result = (int)(gflops_result * 1000.0);
        return gflops_result /= 1000.0;
    }

    final double matgen(double[][] a2, int lda, int n2, double[] b2) {
        int j2;
        int i2;
        int init = 1325;
        double norma = 0.0;
        for (i2 = 0; i2 < n2; ++i2) {
            for (j2 = 0; j2 < n2; ++j2) {
                init = 3125 * init % 65536;
                a2[j2][i2] = ((double)init - 32768.0) / 16384.0;
                norma = a2[j2][i2] > norma ? a2[j2][i2] : norma;
            }
        }
        for (i2 = 0; i2 < n2; ++i2) {
            b2[i2] = 0.0;
        }
        for (j2 = 0; j2 < n2; ++j2) {
            for (i2 = 0; i2 < n2; ++i2) {
                int n3 = i2;
                b2[n3] = b2[n3] + a2[j2][i2];
            }
        }
        return norma;
    }

    final int dgefa(double[][] a2, int lda, int n2, int[] ipvt) {
        int info = 0;
        int nm1 = n2 - 1;
        if (nm1 >= 0) {
            for (int k2 = 0; k2 < nm1; ++k2) {
                int l2;
                double[] col_k = a2[k2];
                int kp1 = k2 + 1;
                ipvt[k2] = l2 = this.idamax(n2 - k2, col_k, k2, 1) + k2;
                if (col_k[l2] != 0.0) {
                    double t2;
                    if (l2 != k2) {
                        t2 = col_k[l2];
                        col_k[l2] = col_k[k2];
                        col_k[k2] = t2;
                    }
                    t2 = -1.0 / col_k[k2];
                    this.dscal(n2 - kp1, t2, col_k, kp1, 1);
                    for (int j2 = kp1; j2 < n2; ++j2) {
                        double[] col_j = a2[j2];
                        t2 = col_j[l2];
                        if (l2 != k2) {
                            col_j[l2] = col_j[k2];
                            col_j[k2] = t2;
                        }
                        this.daxpy(n2 - kp1, t2, col_k, kp1, 1, col_j, kp1, 1);
                    }
                    continue;
                }
                info = k2;
            }
        }
        ipvt[n2 - 1] = n2 - 1;
        if (a2[n2 - 1][n2 - 1] == 0.0) {
            info = n2 - 1;
        }
        return info;
    }

    final void dgesl(double[][] a2, int lda, int n2, int[] ipvt, double[] b2, int job) {
        block7: {
            double t2;
            int k2;
            int nm1;
            block6: {
                double t3;
                int k3;
                nm1 = n2 - 1;
                if (job != 0) break block6;
                if (nm1 >= 1) {
                    for (k3 = 0; k3 < nm1; ++k3) {
                        int l2 = ipvt[k3];
                        t3 = b2[l2];
                        if (l2 != k3) {
                            b2[l2] = b2[k3];
                            b2[k3] = t3;
                        }
                        int kp1 = k3 + 1;
                        this.daxpy(n2 - kp1, t3, a2[k3], kp1, 1, b2, kp1, 1);
                    }
                }
                for (int kb = 0; kb < n2; ++kb) {
                    int n3 = k3 = n2 - (kb + 1);
                    b2[n3] = b2[n3] / a2[k3][k3];
                    t3 = -b2[k3];
                    this.daxpy(k3, t3, a2[k3], 0, 1, b2, 0, 1);
                }
                break block7;
            }
            for (k2 = 0; k2 < n2; ++k2) {
                t2 = this.ddot(k2, a2[k2], 0, 1, b2, 0, 1);
                b2[k2] = (b2[k2] - t2) / a2[k2][k2];
            }
            if (nm1 < 1) break block7;
            for (int kb = 1; kb < nm1; ++kb) {
                k2 = n2 - (kb + 1);
                int kp1 = k2 + 1;
                int n4 = k2;
                b2[n4] = b2[n4] + this.ddot(n2 - kp1, a2[k2], kp1, 1, b2, kp1, 1);
                int l3 = ipvt[k2];
                if (l3 == k2) continue;
                t2 = b2[l3];
                b2[l3] = b2[k2];
                b2[k2] = t2;
            }
        }
    }

    final void daxpy(int n2, double da, double[] dx, int dx_off, int incx, double[] dy, int dy_off, int incy) {
        if (n2 > 0 && da != 0.0) {
            if (incx != 1 || incy != 1) {
                int ix = 0;
                int iy = 0;
                if (incx < 0) {
                    ix = (-n2 + 1) * incx;
                }
                if (incy < 0) {
                    iy = (-n2 + 1) * incy;
                }
                for (int i2 = 0; i2 < n2; ++i2) {
                    int n3 = iy + dy_off;
                    dy[n3] = dy[n3] + da * dx[ix + dx_off];
                    ix += incx;
                    iy += incy;
                }
                return;
            }
            for (int i3 = 0; i3 < n2; ++i3) {
                int n4 = i3 + dy_off;
                dy[n4] = dy[n4] + da * dx[i3 + dx_off];
            }
        }
    }

    final double ddot(int n2, double[] dx, int dx_off, int incx, double[] dy, int dy_off, int incy) {
        double dtemp;
        block6: {
            dtemp = 0.0;
            if (n2 <= 0) break block6;
            if (incx != 1 || incy != 1) {
                int ix = 0;
                int iy = 0;
                if (incx < 0) {
                    ix = (-n2 + 1) * incx;
                }
                if (incy < 0) {
                    iy = (-n2 + 1) * incy;
                }
                for (int i2 = 0; i2 < n2; ++i2) {
                    dtemp += dx[ix + dx_off] * dy[iy + dy_off];
                    ix += incx;
                    iy += incy;
                }
            } else {
                for (int i3 = 0; i3 < n2; ++i3) {
                    dtemp += dx[i3 + dx_off] * dy[i3 + dy_off];
                }
            }
        }
        return dtemp;
    }

    final void dscal(int n2, double da, double[] dx, int dx_off, int incx) {
        block4: {
            if (n2 <= 0) break block4;
            if (incx != 1) {
                int nincx = n2 * incx;
                for (int i2 = 0; i2 < nincx; i2 += incx) {
                    int n3 = i2 + dx_off;
                    dx[n3] = dx[n3] * da;
                }
            } else {
                for (int i3 = 0; i3 < n2; ++i3) {
                    int n4 = i3 + dx_off;
                    dx[n4] = dx[n4] * da;
                }
            }
        }
    }

    final int idamax(int n2, double[] dx, int dx_off, int incx) {
        int itemp = 0;
        if (n2 < 1) {
            itemp = -1;
        } else if (n2 == 1) {
            itemp = 0;
        } else if (incx != 1) {
            double dmax = this.abs(dx[0 + dx_off]);
            int ix = 1 + incx;
            for (int i2 = 1; i2 < n2; ++i2) {
                double dtemp = this.abs(dx[ix + dx_off]);
                if (dtemp > dmax) {
                    itemp = i2;
                    dmax = dtemp;
                }
                ix += incx;
            }
        } else {
            itemp = 0;
            double dmax = this.abs(dx[0 + dx_off]);
            for (int i3 = 1; i3 < n2; ++i3) {
                double dtemp = this.abs(dx[i3 + dx_off]);
                if (!(dtemp > dmax)) continue;
                itemp = i3;
                dmax = dtemp;
            }
        }
        return itemp;
    }

    final double epslon(double x2) {
        double a2 = 1.3333333333333333;
        double eps = 0.0;
        while (eps == 0.0) {
            double b2 = a2 - 1.0;
            double c2 = b2 + b2 + b2;
            eps = this.abs(c2 - 1.0);
        }
        return eps * this.abs(x2);
    }

    final void dmxpy(int n1, double[] y2, int n2, int ldm, double[] x2, double[][] m4) {
        for (int j2 = 0; j2 < n2; ++j2) {
            for (int i2 = 0; i2 < n1; ++i2) {
                int n3 = i2;
                y2[n3] = y2[n3] + x2[j2] * m4[j2][i2];
            }
        }
    }
}

