/*
 * Decompiled with CFR 0.152.
 */
package water.init;

import java.util.Random;
import water.DTask;
import water.Futures;
import water.H2O;
import water.H2ONode;
import water.Iced;
import water.MRTask;
import water.RPC;
import water.fvec.Vec;
import water.util.ArrayUtils;
import water.util.Log;
import water.util.PrettyPrint;
import water.util.Timer;
import water.util.TwoDimTable;

public class NetworkTest
extends Iced {
    public int[] msg_sizes = new int[]{1, 1024, 0x100000};
    public int repeats = 10;
    public boolean collective = true;
    public boolean serial = true;
    public double[] microseconds_collective;
    public double[] bandwidths_collective;
    public double[][] microseconds;
    public double[][] bandwidths;
    public String[] nodes;
    public TwoDimTable table;

    public NetworkTest execImpl() {
        int i2;
        this.microseconds = new double[this.msg_sizes.length][];
        this.microseconds_collective = new double[this.msg_sizes.length];
        NetworkTester nt = new NetworkTester(this.msg_sizes, this.microseconds, this.microseconds_collective, this.repeats, this.serial, this.collective);
        H2O.submitTask(nt);
        nt.join();
        this.bandwidths = new double[this.msg_sizes.length][];
        for (i2 = 0; i2 < this.bandwidths.length; ++i2) {
            this.bandwidths[i2] = new double[this.microseconds[i2].length];
            for (int j2 = 0; j2 < this.microseconds[i2].length; ++j2) {
                this.bandwidths[i2][j2] = (double)(2 * this.msg_sizes[i2]) / (this.microseconds[i2][j2] / 1000000.0);
            }
        }
        this.bandwidths_collective = new double[this.msg_sizes.length];
        for (i2 = 0; i2 < this.bandwidths_collective.length; ++i2) {
            this.bandwidths_collective[i2] = (double)(2 * H2O.CLOUD.size() * this.msg_sizes[i2]) / (this.microseconds_collective[i2] / 1000000.0);
        }
        this.nodes = new String[H2O.CLOUD.size()];
        for (i2 = 0; i2 < this.nodes.length; ++i2) {
            this.nodes[i2] = H2O.CLOUD._memary[i2].toString();
        }
        this.fillTable();
        Log.info(this.table.toString());
        return this;
    }

    private static double[] send_recv_all(int msg_size, int repeats) {
        byte[] payload = new byte[msg_size];
        new Random().nextBytes(payload);
        int siz = H2O.CLOUD.size();
        double[] times = new double[siz];
        for (int i2 = 0; i2 < siz; ++i2) {
            H2ONode node = H2O.CLOUD._memary[i2];
            Timer t2 = new Timer();
            for (int l2 = 0; l2 < repeats; ++l2) {
                PingPongTask ppt = new PingPongTask(payload);
                new RPC<PingPongTask>(node, ppt).call().get();
            }
            times[i2] = (double)t2.nanos() / (double)repeats;
        }
        return times;
    }

    private static double send_recv_collective(int msg_size, int repeats) {
        byte[] payload = new byte[msg_size];
        new Random().nextBytes(payload);
        Vec v2 = Vec.makeZero(1L);
        Timer t2 = new Timer();
        for (int l2 = 0; l2 < repeats; ++l2) {
            new CollectiveTask(payload).doAll(v2);
        }
        v2.remove(new Futures()).blockForPending();
        return (double)t2.nanos() / (double)repeats;
    }

    public void fillTable() {
        String tableHeader = "Network Test";
        String tableDescription = "Launched from " + H2O.SELF._key;
        String[] rowHeaders = new String[H2O.CLOUD.size() + 1];
        rowHeaders[0] = "all - collective bcast/reduce";
        for (int i2 = 0; i2 < H2O.CLOUD.size(); ++i2) {
            rowHeaders[1 + i2] = (H2O.SELF.equals(H2O.CLOUD._memary[i2]) ? "self" : "remote") + " " + H2O.CLOUD._memary[i2].toString();
        }
        String[] colHeaders = new String[this.msg_sizes.length];
        for (int i3 = 0; i3 < colHeaders.length; ++i3) {
            colHeaders[i3] = this.msg_sizes[i3] + " bytes";
        }
        String[] colTypes = new String[this.msg_sizes.length];
        for (int i4 = 0; i4 < colTypes.length; ++i4) {
            colTypes[i4] = "string";
        }
        String[] colFormats = new String[this.msg_sizes.length];
        for (int i5 = 0; i5 < colTypes.length; ++i5) {
            colFormats[i5] = "%s";
        }
        String colHeaderForRowHeaders = "Destination";
        this.table = new TwoDimTable(tableHeader, tableDescription, rowHeaders, colHeaders, colTypes, colFormats, colHeaderForRowHeaders);
        for (int m4 = 0; m4 < this.msg_sizes.length; ++m4) {
            this.table.set(0, m4, PrettyPrint.usecs((long)this.microseconds_collective[m4]) + ", " + PrettyPrint.bytesPerSecond((long)this.bandwidths_collective[m4]));
        }
        for (int n2 = 0; n2 < H2O.CLOUD._memary.length; ++n2) {
            for (int m5 = 0; m5 < this.msg_sizes.length; ++m5) {
                this.table.set(1 + n2, m5, PrettyPrint.usecs((long)this.microseconds[m5][n2]) + ", " + PrettyPrint.bytesPerSecond((long)this.bandwidths[m5][n2]));
            }
        }
    }

    private static class CollectiveTask
    extends MRTask<CollectiveTask> {
        private final byte[] _payload;

        public CollectiveTask(byte[] payload) {
            this._payload = payload;
        }
    }

    private static class PingPongTask
    extends DTask<PingPongTask> {
        private final byte[] _payload;

        public PingPongTask(byte[] payload) {
            this._payload = payload;
        }

        @Override
        public void compute2() {
            this.tryComplete();
        }
    }

    public static class NetworkTester
    extends H2O.H2OCountedCompleter {
        double[][] microseconds;
        double[] microseconds_collective;
        int[] msg_sizes;
        public int repeats = 10;
        boolean serial;
        boolean collective;

        public NetworkTester(int[] msg, double[][] res, double[] res_collective, int rep, boolean serial, boolean collective) {
            super((byte)118);
            this.microseconds = res;
            this.microseconds_collective = res_collective;
            this.msg_sizes = msg;
            this.repeats = rep;
            this.serial = serial;
            this.collective = collective;
        }

        @Override
        public void compute2() {
            int i2;
            if (this.serial) {
                for (i2 = 0; i2 < this.microseconds.length; ++i2) {
                    this.microseconds[i2] = NetworkTest.send_recv_all(this.msg_sizes[i2], this.repeats);
                    ArrayUtils.div(this.microseconds[i2], 1000.0);
                }
            }
            if (this.collective) {
                for (i2 = 0; i2 < this.microseconds_collective.length; ++i2) {
                    this.microseconds_collective[i2] = NetworkTest.send_recv_collective(this.msg_sizes[i2], this.repeats);
                }
                ArrayUtils.div(this.microseconds_collective, 1000.0);
            }
            this.tryComplete();
        }
    }
}

