/*
 * Decompiled with CFR 0.152.
 */
package water.nbhm;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import sun.misc.Unsafe;
import water.nbhm.ConcurrentAutoTable;
import water.nbhm.UtilUnsafe;

public class NonBlockingSetInt
extends AbstractSet<Integer>
implements Serializable {
    private static final long serialVersionUID = 1234123412341234123L;
    private static final Unsafe _unsafe = UtilUnsafe.getUnsafe();
    private static final long _nbsi_offset;
    private transient NBSI _nbsi = new NBSI(63, new ConcurrentAutoTable(), this);

    private final boolean CAS_nbsi(NBSI old, NBSI nnn) {
        return _unsafe.compareAndSwapObject(this, _nbsi_offset, old, nnn);
    }

    @Override
    public boolean add(Integer i2) {
        return this.add((int)i2);
    }

    @Override
    public boolean contains(Object o2) {
        return o2 instanceof Integer && this.contains((Integer)o2);
    }

    @Override
    public boolean remove(Object o2) {
        return o2 instanceof Integer && this.remove((Integer)o2);
    }

    @Override
    public boolean add(int i2) {
        if (i2 < 0) {
            throw new IllegalArgumentException("" + i2);
        }
        return this._nbsi.add(i2);
    }

    public boolean contains(int i2) {
        return i2 >= 0 && this._nbsi.contains(i2);
    }

    public boolean remove(int i2) {
        return i2 >= 0 && this._nbsi.remove(i2);
    }

    @Override
    public int size() {
        return this._nbsi.size();
    }

    public int length() {
        return this._nbsi._bits.length << 6;
    }

    @Override
    public void clear() {
        NBSI cleared = new NBSI(63, new ConcurrentAutoTable(), this);
        while (!this.CAS_nbsi(this._nbsi, cleared)) {
        }
    }

    public void print() {
        this._nbsi.print(0);
    }

    @Override
    public Iterator<Integer> iterator() {
        return new iter();
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        NBSI nbsi = this._nbsi;
        int len = this._nbsi._bits.length << 6;
        s2.writeInt(len);
        for (int i2 = 0; i2 < len; ++i2) {
            s2.writeBoolean(this._nbsi.contains(i2));
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        int len = s2.readInt();
        this._nbsi = new NBSI(len, new ConcurrentAutoTable(), this);
        for (int i2 = 0; i2 < len; ++i2) {
            if (!s2.readBoolean()) continue;
            this._nbsi.add(i2);
        }
    }

    static {
        Field f2 = null;
        try {
            f2 = NonBlockingSetInt.class.getDeclaredField("_nbsi");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        _nbsi_offset = _unsafe.objectFieldOffset(f2);
    }

    private static final class NBSI {
        private final transient NonBlockingSetInt _non_blocking_set_int;
        private final transient ConcurrentAutoTable _size;
        private final long[] _bits;
        private static final int _Lbase = NonBlockingSetInt.access$500().arrayBaseOffset(long[].class);
        private static final int _Lscale = NonBlockingSetInt.access$500().arrayIndexScale(long[].class);
        private NBSI _new;
        private static final long _new_offset;
        private final transient AtomicInteger _copyIdx;
        private final transient AtomicInteger _copyDone;
        private final transient int _sum_bits_length;
        private final NBSI _nbsi64;

        private static long rawIndex(long[] ary, int idx) {
            assert (idx >= 0 && idx < ary.length);
            return _Lbase + idx * _Lscale;
        }

        private final boolean CAS(int idx, long old, long nnn) {
            return _unsafe.compareAndSwapLong(this._bits, NBSI.rawIndex(this._bits, idx), old, nnn);
        }

        private final boolean CAS_new(NBSI nnn) {
            return _unsafe.compareAndSwapObject(this, _new_offset, null, nnn);
        }

        private static final long mask(int i2) {
            return 1L << (i2 & 0x3F);
        }

        private NBSI(int max_elem, ConcurrentAutoTable ctr, NonBlockingSetInt nonb) {
            this._non_blocking_set_int = nonb;
            this._size = ctr;
            this._copyIdx = ctr == null ? null : new AtomicInteger();
            this._copyDone = ctr == null ? null : new AtomicInteger();
            this._bits = new long[(int)((long)max_elem + 63L >>> 6)];
            this._nbsi64 = max_elem + 1 >>> 6 == 0 ? null : new NBSI(max_elem + 1 >>> 6, null, null);
            this._sum_bits_length = this._bits.length + (this._nbsi64 == null ? 0 : this._nbsi64._sum_bits_length);
        }

        public boolean add(int i2) {
            long old;
            if (i2 >> 6 >= this._bits.length) {
                return this.install_larger_new_bits(i2).help_copy().add(i2);
            }
            NBSI nbsi = this;
            int j2 = i2;
            while ((j2 & 0x3F) == 63) {
                nbsi = nbsi._nbsi64;
                j2 >>= 6;
            }
            long mask = NBSI.mask(j2);
            do {
                if ((old = nbsi._bits[j2 >> 6]) < 0L) {
                    return this.help_copy_impl(i2).help_copy().add(i2);
                }
                if ((old & mask) == 0L) continue;
                return false;
            } while (!nbsi.CAS(j2 >> 6, old, old | mask));
            this._size.add(1L);
            return true;
        }

        public boolean remove(int i2) {
            long old;
            if (i2 >> 6 >= this._bits.length) {
                return this._new != null && this.help_copy().remove(i2);
            }
            NBSI nbsi = this;
            int j2 = i2;
            while ((j2 & 0x3F) == 63) {
                nbsi = nbsi._nbsi64;
                j2 >>= 6;
            }
            long mask = NBSI.mask(j2);
            do {
                if ((old = nbsi._bits[j2 >> 6]) < 0L) {
                    return this.help_copy_impl(i2).help_copy().remove(i2);
                }
                if ((old & mask) != 0L) continue;
                return false;
            } while (!nbsi.CAS(j2 >> 6, old, old & (mask ^ 0xFFFFFFFFFFFFFFFFL)));
            this._size.add(-1L);
            return true;
        }

        public boolean contains(int i2) {
            if (i2 >> 6 >= this._bits.length) {
                return this._new != null && this.help_copy().contains(i2);
            }
            NBSI nbsi = this;
            int j2 = i2;
            while ((j2 & 0x3F) == 63) {
                nbsi = nbsi._nbsi64;
                j2 >>= 6;
            }
            long mask = NBSI.mask(j2);
            long old = nbsi._bits[j2 >> 6];
            if (old < 0L) {
                return this.help_copy_impl(i2).help_copy().contains(i2);
            }
            return (old & mask) != 0L;
        }

        public int size() {
            return (int)this._size.get();
        }

        private NBSI install_larger_new_bits(int i2) {
            if (this._new == null) {
                int sz = this._bits.length << 6 << 1;
                this.CAS_new(new NBSI(sz, this._size, this._non_blocking_set_int));
            }
            return this;
        }

        private NBSI help_copy() {
            NBSI top_nbsi = this._non_blocking_set_int._nbsi;
            int HELP = 8;
            int idx = top_nbsi._copyIdx.getAndAdd(512);
            for (int i2 = 0; i2 < 8; ++i2) {
                int j2 = idx + i2 * 64;
                top_nbsi.help_copy_impl(j2 %= top_nbsi._bits.length << 6);
                top_nbsi.help_copy_impl(j2 + 63);
            }
            if (top_nbsi._copyDone.get() != top_nbsi._sum_bits_length || this._non_blocking_set_int.CAS_nbsi(top_nbsi, top_nbsi._new)) {
                // empty if block
            }
            return this._new;
        }

        private NBSI help_copy_impl(int i2) {
            NBSI old = this;
            NBSI nnn = this._new;
            if (nnn == null) {
                return this;
            }
            int j2 = i2;
            while ((j2 & 0x3F) == 63) {
                old = old._nbsi64;
                nnn = nnn._nbsi64;
                j2 >>= 6;
            }
            long bits = old._bits[j2 >> 6];
            while (bits >= 0L) {
                long oldbits = bits;
                if (old.CAS(j2 >> 6, oldbits, bits |= NBSI.mask(63))) {
                    if (oldbits != 0L) break;
                    this._copyDone.addAndGet(1);
                    break;
                }
                bits = old._bits[j2 >> 6];
            }
            if (bits != NBSI.mask(63)) {
                long new_bits = nnn._bits[j2 >> 6];
                if (new_bits == 0L) {
                    new_bits = bits & (NBSI.mask(63) ^ 0xFFFFFFFFFFFFFFFFL);
                    if (!nnn.CAS(j2 >> 6, 0L, new_bits)) {
                        new_bits = nnn._bits[j2 >> 6];
                    }
                    assert (new_bits != 0L);
                }
                if (old.CAS(j2 >> 6, bits, NBSI.mask(63))) {
                    this._copyDone.addAndGet(1);
                }
            }
            return this;
        }

        private void print(int d2, String msg) {
            for (int i2 = 0; i2 < d2; ++i2) {
                System.out.print("  ");
            }
            System.out.println(msg);
        }

        private void print(int d2) {
            StringBuilder buf = new StringBuilder();
            buf.append("NBSI - _bits.len=");
            NBSI x2 = this;
            while (x2 != null) {
                buf.append(" " + x2._bits.length);
                x2 = x2._nbsi64;
            }
            this.print(d2, buf.toString());
            x2 = this;
            while (x2 != null) {
                for (int i2 = 0; i2 < x2._bits.length; ++i2) {
                    System.out.print(Long.toHexString(x2._bits[i2]) + " ");
                }
                x2 = x2._nbsi64;
                System.out.println();
            }
            if (this._copyIdx.get() != 0 || this._copyDone.get() != 0) {
                this.print(d2, "_copyIdx=" + this._copyIdx.get() + " _copyDone=" + this._copyDone.get() + " _words_to_cpy=" + this._sum_bits_length);
            }
            if (this._new != null) {
                this.print(d2, "__has_new - ");
                this._new.print(d2 + 1);
            }
        }

        static {
            Field f2 = null;
            try {
                f2 = NBSI.class.getDeclaredField("_new");
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            _new_offset = _unsafe.objectFieldOffset(f2);
        }
    }

    private class iter
    implements Iterator<Integer> {
        NBSI _nbsi2;
        int _idx = -1;
        int _prev = -1;

        iter() {
            this._nbsi2 = NonBlockingSetInt.this._nbsi;
            this.advance();
        }

        @Override
        public boolean hasNext() {
            return this._idx != -2;
        }

        private void advance() {
            do {
                ++this._idx;
                while (this._idx >> 6 >= this._nbsi2._bits.length) {
                    if (this._nbsi2._new == null) {
                        this._idx = -2;
                        return;
                    }
                    this._nbsi2 = this._nbsi2._new;
                }
            } while (!this._nbsi2.contains(this._idx));
        }

        @Override
        public Integer next() {
            if (this._idx == -1) {
                throw new NoSuchElementException();
            }
            this._prev = this._idx;
            this.advance();
            return this._prev;
        }

        @Override
        public void remove() {
            if (this._prev == -1) {
                throw new IllegalStateException();
            }
            this._nbsi2.remove(this._prev);
            this._prev = -1;
        }
    }
}

