/*
 * Decompiled with CFR 0.152.
 */
package water.parser;

import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeSet;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import jsr166y.CountedCompleter;
import jsr166y.ForkJoinTask;
import jsr166y.RecursiveAction;
import water.DKV;
import water.DTask;
import water.Freezable;
import water.Futures;
import water.H2O;
import water.H2ONode;
import water.Iced;
import water.Job;
import water.Key;
import water.Keyed;
import water.Lockable;
import water.MRTask;
import water.MemoryManager;
import water.RPC;
import water.Value;
import water.exceptions.H2OIllegalArgumentException;
import water.exceptions.H2OIllegalValueException;
import water.fvec.AppendableVec;
import water.fvec.ByteVec;
import water.fvec.C0LChunk;
import water.fvec.CStrChunk;
import water.fvec.Chunk;
import water.fvec.FileVec;
import water.fvec.Frame;
import water.fvec.Vec;
import water.nbhm.NonBlockingHashMap;
import water.nbhm.NonBlockingSetInt;
import water.parser.BufferedString;
import water.parser.Categorical;
import water.parser.DecryptionTool;
import water.parser.DefaultParserProviders;
import water.parser.FVecParseReader;
import water.parser.FVecParseWriter;
import water.parser.PackedDomains;
import water.parser.ParseFinalizer;
import water.parser.ParseSetup;
import water.parser.ParseWriter;
import water.parser.Parser;
import water.parser.ParserInfo;
import water.parser.ParserService;
import water.parser.SVMLightFVecParseWriter;
import water.parser.ZipUtil;
import water.util.ArrayUtils;
import water.util.FrameUtils;
import water.util.Log;
import water.util.PrettyPrint;

public final class ParseDataset {
    public Job<Frame> _job;
    private MultiFileParseTask _mfpt;

    public static Frame parse(Key okey, Key ... keys) {
        return ParseDataset.parse(null, okey, keys);
    }

    public static Frame parse(int[] skippedColumns, Key okey, Key ... keys) {
        return ParseDataset.parse(okey, keys, true, false, 0, skippedColumns);
    }

    public static Frame parse(Key okey, Key[] keys, boolean deleteOnDone, boolean singleQuote, int checkHeader) {
        return ParseDataset.parse(okey, keys, deleteOnDone, singleQuote, checkHeader, null);
    }

    public static Frame parse(Key okey, Key[] keys, boolean deleteOnDone, boolean singleQuote, int checkHeader, int[] skippedColumns) {
        ParseSetup guessParseSetup = ParseSetup.guessSetup(keys, singleQuote, checkHeader);
        if (skippedColumns != null) {
            guessParseSetup.setSkippedColumns(skippedColumns);
            guessParseSetup.setParseColumnIndices(guessParseSetup.getNumberColumns(), skippedColumns);
        }
        return ParseDataset.parse(okey, keys, deleteOnDone, guessParseSetup);
    }

    public static Frame parse(Key okey, Key[] keys, boolean deleteOnDone, ParseSetup globalSetup) {
        return ParseDataset.parse((Key)okey, (Key[])keys, (boolean)deleteOnDone, (ParseSetup)globalSetup, (boolean)true)._job.get();
    }

    public static ParseDataset parse(Key okey, Key[] keys, boolean deleteOnDone, ParseSetup globalSetup, boolean blocking) {
        ParseDataset pds = ParseDataset.forkParseDataset(okey, keys, globalSetup, deleteOnDone);
        if (blocking) {
            pds._job.get();
        }
        return pds;
    }

    static ByteVec getByteVec(Key key) {
        Object ice = DKV.getGet(key);
        if (ice == null) {
            throw new H2OIllegalArgumentException("Missing data", "Did not find any data under key " + key);
        }
        return (ByteVec)(ice instanceof ByteVec ? ice : ((Frame)ice).vecs()[0]);
    }

    static String[] getColumnNames(int ncols, String[] colNames) {
        if (colNames == null) {
            colNames = new String[ncols];
            for (int i2 = 0; i2 < ncols; ++i2) {
                colNames[i2] = "C" + Integer.toString(i2 + 1);
            }
        } else {
            HashSet<String> nameSet = new HashSet<String>(Arrays.asList(colNames));
            colNames = Arrays.copyOf(colNames, ncols);
            for (int i3 = 0; i3 < ncols; ++i3) {
                if (colNames[i3] != null && !colNames[i3].equals("")) continue;
                String tmp = "C" + Integer.toString(i3 + 1);
                while (nameSet.contains(tmp)) {
                    tmp = tmp + tmp;
                }
                colNames[i3] = tmp;
            }
        }
        return colNames;
    }

    public static Job forkParseSVMLight(Key<Frame> dest, final Key[] keys, final ParseSetup setup) {
        int nchunks = 0;
        Vec v2 = null;
        for (int i2 = 0; i2 < keys.length; ++i2) {
            Object ice = DKV.getGet(keys[i2]);
            if (ice instanceof FileVec) {
                if (i2 == 0) {
                    v2 = (FileVec)ice;
                }
                ((FileVec)ice).setChunkSize(setup._chunk_size);
                nchunks += ((FileVec)ice).nChunks();
                Log.info("Parse chunk size " + setup._chunk_size);
                continue;
            }
            if (!(ice instanceof Frame) || !(((Frame)ice).vec(0) instanceof FileVec)) continue;
            if (i2 == 0) {
                v2 = ((Frame)ice).vec(0);
            }
            ((FileVec)((Frame)ice).vec(0)).setChunkSize((Frame)ice, setup._chunk_size);
            nchunks += ((Frame)ice).vec(0).nChunks();
            Log.info("Parse chunk size " + setup._chunk_size);
        }
        Vec.VectorGroup vg = v2.group();
        final ParseDataset pds = new ParseDataset(dest);
        new Frame(pds._job._result, new String[0], new Vec[0]).delete_and_lock(pds._job);
        return pds._job.start(new H2O.H2OCountedCompleter(){

            @Override
            public void compute2() {
                ParseDataset.parseAllKeys(pds, keys, setup, true);
                this.tryComplete();
            }
        }, nchunks);
    }

    public static ParseDataset forkParseDataset(Key<Frame> dest, Key[] keys, ParseSetup parseSetup, boolean deleteOnDone) {
        int i2;
        ParseSetup setup = parseSetup.getFinalSetup(keys, parseSetup);
        HashSet<String> conflictingNames = setup.checkDupColumnNames();
        for (String x2 : conflictingNames) {
            if (x2 == null || x2.equals("")) continue;
            throw new IllegalArgumentException("Found duplicate column name " + x2);
        }
        long totalParseSize = 0L;
        for (i2 = 0; i2 < keys.length; ++i2) {
            Key k2 = keys[i2];
            if (dest.equals(k2)) {
                throw new IllegalArgumentException("Destination key " + dest + " must be different from all sources");
            }
            if (deleteOnDone) {
                for (int j2 = i2 + 1; j2 < keys.length; ++j2) {
                    if (k2 != keys[j2]) continue;
                    throw new IllegalArgumentException("Source key " + k2 + " appears twice, deleteOnDone must be false");
                }
            }
            totalParseSize += ParseDataset.getByteVec(k2).length();
        }
        Log.info("Total file size: " + PrettyPrint.bytes(totalParseSize));
        if (!setup.getParseType().name().contains("ORC")) {
            for (i2 = 0; i2 < keys.length; ++i2) {
                Object ice = DKV.getGet(keys[i2]);
                if (ice instanceof FileVec) {
                    ((FileVec)ice).setChunkSize(setup._chunk_size);
                    Log.info("Parse chunk size " + setup._chunk_size);
                    continue;
                }
                if (!(ice instanceof Frame) || !(((Frame)ice).vec(0) instanceof FileVec)) continue;
                ((FileVec)((Frame)ice).vec(0)).setChunkSize((Frame)ice, setup._chunk_size);
                Log.info("Parse chunk size " + setup._chunk_size);
            }
        } else {
            Log.info("Orc Parse chunk sizes may be different across files");
        }
        long memsz = H2O.CLOUD.free_mem();
        if (totalParseSize > memsz * 4L) {
            throw new IllegalArgumentException("Total input file size of " + PrettyPrint.bytes(totalParseSize) + " is much larger than total cluster memory of " + PrettyPrint.bytes(memsz) + ", please use either a larger cluster or smaller data.");
        }
        ParseDataset pds = new ParseDataset(dest);
        new Frame(pds._job._result, new String[0], new Vec[0]).delete_and_lock(pds._job);
        for (Key k3 : keys) {
            Lockable.read_lock(k3, pds._job);
        }
        ParserFJTask fjt = new ParserFJTask(pds, keys, setup, deleteOnDone);
        pds._job.start(fjt, totalParseSize);
        return pds;
    }

    private ParseDataset(Key<Frame> dest) {
        this._job = new Job<Frame>(dest, Frame.class.getName(), "Parse");
    }

    private static ParseDataset parseAllKeys(ParseDataset pds, Key[] fkeys, ParseSetup setup, boolean deleteOnDone) {
        Frame fr;
        int i2;
        String[] parse_column_names;
        boolean namesSameparseColumns;
        int colNumbers;
        Job<Frame> job = pds._job;
        assert (setup._number_columns > 0);
        if (setup._column_names != null && (setup._column_names.length == 0 || setup._column_names.length == 1 && setup._column_names[0].isEmpty())) {
            setup._column_names = null;
        }
        if (setup._na_strings != null && setup._na_strings.length != setup._number_columns) {
            setup._na_strings = null;
        }
        if (fkeys.length == 0) {
            job.stop();
            return pds;
        }
        job.update(0L, "Ingesting files.");
        Vec.VectorGroup vg = ParseDataset.getByteVec(fkeys[0]).group();
        MultiFileParseTask mfpt = pds._mfpt = new MultiFileParseTask(vg, setup, job._key, fkeys, deleteOnDone);
        mfpt.doAll(fkeys);
        Log.trace("Done ingesting files.");
        if (job.stop_requested()) {
            return pds;
        }
        AppendableVec[] avs = mfpt.vecs();
        int n2 = 0;
        int parseCols = setup._parse_columns_indices.length;
        boolean sameParseColumns = setup._number_columns == parseCols;
        int n3 = colNumbers = setup._column_types == null ? setup._number_columns : setup._column_types.length;
        if (setup._column_names == null) {
            setup._column_names = ParseDataset.getColumnNames(colNumbers, null);
        }
        boolean typesSameParseColumns = colNumbers == parseCols;
        boolean bl = namesSameparseColumns = setup._column_names.length == parseCols;
        if (sameParseColumns) {
            parse_column_names = setup._column_names;
        } else {
            parse_column_names = new String[parseCols];
            byte[] parse_column_types = new byte[parseCols];
            for (int cindex = 0; cindex < parseCols; ++cindex) {
                parse_column_names[cindex] = namesSameparseColumns ? setup._column_names[cindex] : setup._column_names[setup._parse_columns_indices[cindex]];
                parse_column_types[cindex] = typesSameParseColumns ? setup._column_types[cindex] : setup._column_types[setup._parse_columns_indices[cindex]];
            }
            setup._column_types = parse_column_types;
        }
        setup._column_names = ParseDataset.getColumnNames(avs.length, parse_column_names);
        int[] ecols2 = new int[parseCols];
        for (int i3 = 0; i3 < parseCols; ++i3) {
            if (avs[i3].get_type() != 4) continue;
            ecols2[n2++] = i3;
        }
        int[] ecols = Arrays.copyOf(ecols2, n2);
        ParseFinalizer finalizer = ParseFinalizer.get(setup);
        if (n2 > 0) {
            if (!setup.getParseType().isDomainProvided) {
                job.update(0L, "Collecting categorical domains across nodes.");
                GatherCategoricalDomainsTask gcdt = (GatherCategoricalDomainsTask)new GatherCategoricalDomainsTask(mfpt._cKey, ecols, ((MultiFileParseTask)mfpt)._parseSetup._parse_columns_indices).doAllNodes();
                ArrayList<String> offendingColNames = new ArrayList<String>();
                for (i2 = 0; i2 < ecols.length; ++i2) {
                    if (gcdt.getDomainLength(i2) < 10000000) {
                        if (gcdt.getDomainLength(i2) == 0) {
                            avs[ecols[i2]].setBad();
                            continue;
                        }
                        avs[ecols[i2]].setDomain(gcdt.getDomain(i2));
                        continue;
                    }
                    offendingColNames.add(setup._column_names[ecols[i2]]);
                }
                if (offendingColNames.size() > 0) {
                    throw new H2OParseException("Exceeded categorical limit on columns " + offendingColNames + ".   Consider reparsing these columns as a string or skip parsing the offending columns by setting the skipped_columns list in Python/R/Java APIs.");
                }
                Log.trace("Done collecting categorical domains across nodes.");
            } else {
                for (int i4 = 0; i4 < ecols.length; ++i4) {
                    avs[ecols[i4]].setDomain(setup._domains[ecols[i4]]);
                }
            }
            job.update(0L, "Compressing data.");
            fr = finalizer.finalize(job, AppendableVec.closeAll(avs), setup, mfpt._fileChunkOffsets);
            fr.update(job);
            Log.trace("Done compressing data.");
            if (!setup.getParseType().isDomainProvided) {
                Vec[] evecs = new Vec[ecols.length];
                for (int i5 = 0; i5 < evecs.length; ++i5) {
                    evecs[i5] = fr.vecs()[ecols[i5]];
                }
                job.update(0L, "Unifying categorical domains across nodes.");
                CreateParse2GlobalCategoricalMaps[] fcdt = new CreateParse2GlobalCategoricalMaps[H2O.CLOUD.size()];
                RPC[] rpcs = new RPC[H2O.CLOUD.size()];
                for (int i6 = 0; i6 < fcdt.length; ++i6) {
                    H2ONode[] nodes = H2O.CLOUD.members();
                    fcdt[i6] = new CreateParse2GlobalCategoricalMaps(mfpt._cKey, fr._key, ecols, ((MultiFileParseTask)mfpt)._parseSetup._parse_columns_indices);
                    rpcs[i6] = new RPC<CreateParse2GlobalCategoricalMaps>(nodes[i6], fcdt[i6]).call();
                }
                for (RPC rpc : rpcs) {
                    rpc.get();
                }
                new UpdateCategoricalChunksTask(mfpt._cKey, mfpt._chunk2ParseNodeMap).doAll(evecs);
                MultiFileParseTask._categoricals.remove(mfpt._cKey);
                Log.trace("Done unifying categoricals across nodes.");
            }
        } else {
            job.update(0L, "Compressing data.");
            fr = finalizer.finalize(job, AppendableVec.closeAll(avs), setup, mfpt._fileChunkOffsets);
            Log.trace("Done closing all Vecs.");
        }
        if (job.stop_requested()) {
            return pds;
        }
        if (setup._parse_type.equals(DefaultParserProviders.SVMLight_INFO)) {
            new SVFTask(fr).doAllNodes();
        }
        if (job.stop_requested()) {
            return pds;
        }
        ParseWriter.ParseErr[] errs = ArrayUtils.append(setup.errs(), mfpt._errors);
        if (errs.length > 0) {
            HashMap<String, Integer> fileChunkOffsets = new HashMap<String, Integer>();
            for (i2 = 0; i2 < mfpt._fileChunkOffsets.length; ++i2) {
                fileChunkOffsets.put(fkeys[i2].toString(), mfpt._fileChunkOffsets[i2]);
            }
            long[] espc = fr.anyVec().espc();
            for (int i7 = 0; i7 < errs.length; ++i7) {
                if (!fileChunkOffsets.containsKey(errs[i7]._file)) continue;
                int espcOff = (Integer)fileChunkOffsets.get(errs[i7]._file);
                errs[i7]._gLineNum = espc[espcOff + errs[i7]._cidx] + errs[i7]._lineNum;
                errs[i7]._lineNum = errs[i7]._gLineNum - espc[espcOff];
            }
            TreeSet<ParseWriter.ParseErr> s2 = new TreeSet<ParseWriter.ParseErr>(new Comparator<ParseWriter.ParseErr>(){

                @Override
                public int compare(ParseWriter.ParseErr o1, ParseWriter.ParseErr o2) {
                    long res = o1._gLineNum - o2._gLineNum;
                    if (res == 0L) {
                        res = o1._byteOffset - o2._byteOffset;
                    }
                    if (res == 0L) {
                        return o1._err.compareTo(o2._err);
                    }
                    return (int)res < 0 ? -1 : 1;
                }
            });
            Collections.addAll(s2, errs);
            String[] warns = new String[s2.size()];
            int i8 = 0;
            for (ParseWriter.ParseErr err : s2) {
                Object[] objectArray = new Object[1];
                int n4 = i8++;
                String string = err.toString();
                warns[n4] = string;
                objectArray[0] = string;
                Log.warn(objectArray);
            }
            job.setWarnings(warns);
        }
        job.update(0L, "Calculating data summary.");
        ParseDataset.logParseResults(fr);
        fr.update(job);
        Frame fr2 = (Frame)DKV.getGet(fr._key);
        assert (fr2._names.length == fr2.numCols());
        fr.unlock(job);
        if (deleteOnDone) {
            for (Key k2 : fkeys) {
                DKV.remove(k2);
                assert (DKV.get(k2) == null) : "Input key " + k2 + " not deleted during parse";
            }
        }
        return pds;
    }

    public static void logParseResults(Frame fr) {
        Vec[] vecArr;
        long numRows = fr.anyVec().length();
        Log.info("Parse result for " + fr._key + " (" + Long.toString(numRows) + " rows, " + Integer.toString(fr.numCols()) + " columns):");
        Futures fs = new Futures();
        for (Vec v2 : vecArr = fr.vecs()) {
            v2.startRollupStats(fs);
        }
        fs.blockForPending();
        int namelen = 0;
        for (String s2 : fr.names()) {
            namelen = Math.max(namelen, s2.length());
        }
        String format = " %" + namelen + "s %7s %12.12s %12.12s %12.12s %12.12s %11s %8s %6s";
        Log.info(String.format(format, "ColV2", "type", "min", "max", "mean", "sigma", "NAs", "constant", "cardinality"));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (int i2 = 0; i2 < vecArr.length; ++i2) {
            boolean printColumnToStdout;
            String maxStr;
            String minStr;
            String typeStr;
            Vec v3 = vecArr[i2];
            boolean isCategorical = v3.isCategorical();
            boolean isConstant = v3.isConst();
            String CStr = String.format("%" + namelen + "s:", fr.names()[i2]);
            String meanStr = "";
            String sigmaStr = "";
            switch (v3.get_type()) {
                case 0: {
                    typeStr = "all_NA";
                    minStr = "";
                    maxStr = "";
                    break;
                }
                case 1: {
                    typeStr = "UUID";
                    minStr = "";
                    maxStr = "";
                    break;
                }
                case 2: {
                    typeStr = "string";
                    minStr = "";
                    maxStr = "";
                    break;
                }
                case 3: {
                    typeStr = "numeric";
                    minStr = String.format("%g", v3.min());
                    maxStr = String.format("%g", v3.max());
                    meanStr = String.format("%g", v3.mean());
                    sigmaStr = String.format("%g", v3.sigma());
                    break;
                }
                case 4: {
                    typeStr = "factor";
                    minStr = v3.factor(0L);
                    maxStr = v3.factor(v3.cardinality() - 1);
                    break;
                }
                case 5: {
                    typeStr = "time";
                    minStr = sdf.format(v3.min());
                    maxStr = sdf.format(v3.max());
                    break;
                }
                default: {
                    throw H2O.unimpl();
                }
            }
            long numNAs = v3.naCnt();
            String naStr = numNAs > 0L ? String.format("%d", numNAs) : "";
            String isConstantStr = isConstant ? "constant" : "";
            String numLevelsStr = isCategorical ? String.format("%d", v3.domain().length) : "";
            boolean launchedWithHadoopJar = H2O.ARGS.launchedWithHadoopJar();
            boolean printLogSeparatorToStdout = false;
            int MAX_HEAD_TO_PRINT_ON_STDOUT = 10;
            int MAX_TAIL_TO_PRINT_ON_STDOUT = 10;
            if (launchedWithHadoopJar) {
                printColumnToStdout = true;
            } else if (vecArr.length <= 20) {
                printColumnToStdout = true;
            } else if (i2 < 10) {
                printColumnToStdout = true;
            } else if (i2 == 10) {
                printLogSeparatorToStdout = true;
                printColumnToStdout = false;
            } else {
                printColumnToStdout = i2 + 10 >= vecArr.length;
            }
            if (printLogSeparatorToStdout) {
                Log.info("Additional column information only sent to log file...");
            }
            String s3 = String.format(format, CStr, typeStr, minStr, maxStr, meanStr, sigmaStr, naStr, isConstantStr, numLevelsStr);
            if (printColumnToStdout) {
                Log.info(s3);
                continue;
            }
            Log.trace(s3);
        }
        Log.info(FrameUtils.chunkSummary(fr).toString());
    }

    public static class H2OParseException
    extends RuntimeException {
        public H2OParseException(String msg) {
            super(msg);
        }

        public H2OParseException(String msg, Throwable cause) {
            super(msg, cause);
        }

        public H2OParseException(Throwable cause) {
            super(cause);
        }

        public H2OParseException resetMsg(String msg) {
            H2OParseException pe1 = new H2OParseException(msg, this.getCause());
            pe1.setStackTrace(this.getStackTrace());
            return pe1;
        }
    }

    private static class MultiFileParseTask
    extends MRTask<MultiFileParseTask> {
        private final ParseSetup _parseSetup;
        private final Vec.VectorGroup _vg;
        private final int _vecIdStart;
        private static NonBlockingHashMap<Key, Categorical[]> _categoricals = new NonBlockingHashMap();
        private final Key _cKey = Key.make();
        private final boolean _deleteOnDone;
        private int[] _chunk2ParseNodeMap;
        private final Key<Job> _jobKey;
        private final int[] _fileChunkOffsets;
        FVecParseWriter[] _dout;
        int _reservedKeys;
        private ParseWriter.ParseErr[] _errors = new ParseWriter.ParseErr[0];
        private AppendableVec[] _vecs;

        MultiFileParseTask(Vec.VectorGroup vg, ParseSetup setup, Key<Job> jobKey, Key[] fkeys, boolean deleteOnDone) {
            this._vg = vg;
            this._parseSetup = setup;
            this._reservedKeys = this._parseSetup._parse_type.equals(DefaultParserProviders.SVMLight_INFO) ? 100000000 : setup._number_columns;
            this._vecIdStart = this._vg.reserveKeys(this._reservedKeys);
            this._deleteOnDone = deleteOnDone;
            this._jobKey = jobKey;
            this._fileChunkOffsets = new int[fkeys.length];
            int len = 0;
            for (int i2 = 0; i2 < fkeys.length; ++i2) {
                this._fileChunkOffsets[i2] = len;
                len += ParseDataset.getByteVec(fkeys[i2]).nChunks();
            }
            this._chunk2ParseNodeMap = MemoryManager.malloc4(len);
            Arrays.fill(this._chunk2ParseNodeMap, -1);
        }

        @Override
        public void postGlobal() {
            Log.trace("Begin file parse cleanup.");
            int n2 = 0;
            for (int i2 = 0; i2 < this._dout.length; ++i2) {
                if (this._dout[i2] == null) continue;
                this._dout[n2++] = this._dout[i2];
            }
            if (n2 < this._dout.length) {
                this._dout = Arrays.copyOf(this._dout, n2);
            }
            if (this._dout.length == 1) {
                this._vecs = this._dout[0]._vecs;
                return;
            }
            int nchunks = 0;
            int nCols = 0;
            for (FVecParseWriter dout : this._dout) {
                nchunks += dout._vecs[0]._tmp_espc.length;
                nCols = Math.max(dout._vecs.length, nCols);
            }
            long[] espc = MemoryManager.malloc8(nchunks);
            if (nCols > this._reservedKeys) {
                throw H2O.unimpl();
            }
            AppendableVec[] res = new AppendableVec[nCols];
            if (this._parseSetup._parse_type.equals(DefaultParserProviders.SVMLight_INFO)) {
                this._parseSetup._number_columns = res.length;
                this._parseSetup._column_types = new byte[res.length];
                Arrays.fill(this._parseSetup._column_types, (byte)3);
            }
            boolean columnsSkipped = nCols < this._parseSetup._number_columns;
            for (int i3 = 0; i3 < res.length; ++i3) {
                byte columnTypes = columnsSkipped ? this._parseSetup._column_types[this._parseSetup._parse_columns_indices[i3]] : this._parseSetup._column_types[i3];
                int vecIDStartPI = columnsSkipped ? this._vecIdStart + this._parseSetup._parse_columns_indices[i3] : this._vecIdStart + i3;
                res[i3] = new AppendableVec(this._vg.vecKey(vecIDStartPI), espc, columnTypes, 0);
            }
            for (FVecParseWriter fvpw : this._dout) {
                AppendableVec[] avs = fvpw._vecs;
                long[] file_local_espc = avs[0]._tmp_espc;
                for (int j2 = 0; j2 < avs.length; ++j2) {
                    assert (res[j2]._key.equals(avs[j2]._key));
                    assert (avs[0]._chunkOff == avs[j2]._chunkOff);
                    assert (file_local_espc == avs[j2]._tmp_espc || Arrays.equals(file_local_espc, avs[j2]._tmp_espc));
                }
                System.arraycopy(file_local_espc, 0, espc, avs[0]._chunkOff, file_local_espc.length);
            }
            this._vecs = res;
            Log.trace("Finished file parse cleanup.");
        }

        private AppendableVec[] vecs() {
            return this._vecs;
        }

        @Override
        public void setupLocal() {
            this._dout = new FVecParseWriter[this._keys.length];
        }

        private static Categorical[] categoricals(Key cKey, int ncols) {
            Categorical[] categoricals = _categoricals.get(cKey);
            if (categoricals != null) {
                return categoricals;
            }
            categoricals = new Categorical[ncols];
            for (int i2 = 0; i2 < categoricals.length; ++i2) {
                categoricals[i2] = new Categorical();
            }
            _categoricals.putIfAbsent(cKey, categoricals);
            return _categoricals.get(cKey);
        }

        private void chunksAreLocal(Vec vec, int chunkStartIdx, Key key) {
            for (int i2 = 0; i2 < vec.nChunks(); ++i2) {
                this._chunk2ParseNodeMap[chunkStartIdx + i2] = H2O.SELF.index();
            }
            Object ice = DKV.get(key).get();
            if (ice == vec) {
                if (this._deleteOnDone) {
                    vec.remove();
                }
            } else {
                Frame fr = (Frame)ice;
                if (this._deleteOnDone) {
                    fr.delete(this._jobKey, new Futures(), true).blockForPending();
                } else if (fr._key != null) {
                    fr.unlock(this._jobKey);
                }
            }
        }

        private FVecParseWriter makeDout(ParseSetup localSetup, int chunkOff, int nchunks) {
            AppendableVec[] avs = new AppendableVec[localSetup._number_columns];
            long[] espc = MemoryManager.malloc8(nchunks);
            byte[] ctypes = localSetup._column_types;
            for (int i2 = 0; i2 < avs.length; ++i2) {
                avs[i2] = new AppendableVec(this._vg.vecKey(i2 + this._vecIdStart), espc, ctypes == null ? (byte)3 : ctypes[i2], chunkOff);
            }
            return localSetup._parse_type.equals(DefaultParserProviders.SVMLight_INFO) ? new SVMLightFVecParseWriter(this._vg, this._vecIdStart, chunkOff, this._parseSetup._chunk_size, avs, this._parseSetup._parse_columns_indices, this._jobKey) : new FVecParseWriter(this._vg, chunkOff, MultiFileParseTask.categoricals(this._cKey, localSetup._number_columns), localSetup._column_types, this._parseSetup._chunk_size, avs, this._parseSetup._parse_columns_indices, this._jobKey);
        }

        @Override
        public void map(Key key) {
            if (this._jobKey.get().stop_requested()) {
                return;
            }
            ParseSetup localSetup = (ParseSetup)this._parseSetup.clone();
            ByteVec vec = ParseDataset.getByteVec(key);
            int chunkStartIdx = this._fileChunkOffsets[this._lo];
            Log.trace("Begin a map stage of a file parse with start index " + chunkStartIdx + ".");
            DecryptionTool decryptionTool = this._parseSetup.getDecryptionTool();
            byte[] zips = decryptionTool.decryptFirstBytes(vec.getFirstBytes());
            ZipUtil.Compression cpr = ZipUtil.guessCompressionMethod(zips);
            if (localSetup._check_header == 1) {
                byte[] bits = ZipUtil.unzipBytes(zips, cpr, localSetup._chunk_size);
                localSetup._check_header = localSetup.parser(this._jobKey).fileHasHeader(bits, localSetup);
            }
            try {
                switch (cpr) {
                    case NONE: {
                        ParserInfo.ParseMethod pm = this._parseSetup.parseMethod(this._keys.length, vec);
                        Log.info("Key " + key + " will be parsed using method " + (Object)((Object)pm) + ".");
                        if (pm == ParserInfo.ParseMethod.DistributedParse) {
                            ((DistributedParse)new DistributedParse(this._vg, localSetup, this._vecIdStart, chunkStartIdx, this, key, vec.nChunks()).dfork(vec)).getResult(false);
                            for (int i2 = 0; i2 < vec.nChunks(); ++i2) {
                                this._chunk2ParseNodeMap[chunkStartIdx + i2] = vec.chunkKey(i2).home_node().index();
                            }
                            break;
                        }
                        if (pm == ParserInfo.ParseMethod.StreamParse || pm == ParserInfo.ParseMethod.SequentialParse) {
                            ParseWriter dout;
                            localSetup = ParserService.INSTANCE.getByInfo(localSetup._parse_type).setupLocal(vec, localSetup);
                            Parser p2 = localSetup.parser(this._jobKey);
                            FVecParseWriter writer = this.makeDout(localSetup, chunkStartIdx, vec.nChunks());
                            if (pm == ParserInfo.ParseMethod.StreamParse) {
                                try (InputStream bvs = vec.openStream(this._jobKey);){
                                    dout = p2.streamParse(decryptionTool.decryptInputStream(bvs), writer);
                                }
                            } else {
                                dout = p2.sequentialParse(vec, writer);
                            }
                            this._dout[this._lo] = ((FVecParseWriter)dout).close(this._fs);
                            this._errors = this._dout[this._lo].removeErrors();
                            this.chunksAreLocal(vec, chunkStartIdx, key);
                            break;
                        }
                        throw H2O.unimpl();
                    }
                    case ZIP: {
                        localSetup = ParserService.INSTANCE.getByInfo(localSetup._parse_type).setupLocal(vec, localSetup);
                        try (InputStream bvs = vec.openStream(this._jobKey);
                             InputStream dec = decryptionTool.decryptInputStream(bvs);
                             ZipInputStream zis = new ZipInputStream(dec);){
                            ZipEntry ze;
                            if (ZipUtil.isZipDirectory(key)) {
                                zis.getNextEntry();
                            }
                            if ((ze = zis.getNextEntry()) != null && !ze.isDirectory()) {
                                this._dout[this._lo] = this.streamParse(zis, localSetup, this.makeDout(localSetup, chunkStartIdx, vec.nChunks()), bvs);
                            }
                        }
                        this._errors = this._dout[this._lo].removeErrors();
                        this.chunksAreLocal(vec, chunkStartIdx, key);
                        break;
                    }
                    case GZIP: {
                        localSetup = ParserService.INSTANCE.getByInfo(localSetup._parse_type).setupLocal(vec, localSetup);
                        try (InputStream bvs = vec.openStream(this._jobKey);
                             InputStream dec = decryptionTool.decryptInputStream(bvs);
                             GZIPInputStream gzis = new GZIPInputStream(dec);){
                            this._dout[this._lo] = this.streamParse(gzis, localSetup, this.makeDout(localSetup, chunkStartIdx, vec.nChunks()), bvs);
                        }
                        this._errors = this._dout[this._lo].removeErrors();
                        this.chunksAreLocal(vec, chunkStartIdx, key);
                    }
                }
                Log.trace("Finished a map stage of a file parse with start index " + chunkStartIdx + ".");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            catch (H2OParseException pe0) {
                throw pe0.resetMsg(pe0.getMessage() + " for " + key);
            }
        }

        @Override
        public void reduce(MultiFileParseTask mfpt) {
            assert (this != mfpt);
            Log.trace("Begin a reduce stage of a file parse.");
            if (this._dout == null) {
                this._dout = mfpt._dout;
            } else if (this._dout != mfpt._dout) {
                this._dout = ArrayUtils.append(this._dout, mfpt._dout);
            }
            if (this._chunk2ParseNodeMap == null) {
                this._chunk2ParseNodeMap = mfpt._chunk2ParseNodeMap;
            } else if (this._chunk2ParseNodeMap != mfpt._chunk2ParseNodeMap) {
                for (int i2 = 0; i2 < this._chunk2ParseNodeMap.length; ++i2) {
                    if (this._chunk2ParseNodeMap[i2] == -1) {
                        this._chunk2ParseNodeMap[i2] = mfpt._chunk2ParseNodeMap[i2];
                        continue;
                    }
                    assert (mfpt._chunk2ParseNodeMap[i2] == -1) : Arrays.toString(this._chunk2ParseNodeMap) + " :: " + Arrays.toString(mfpt._chunk2ParseNodeMap);
                }
            }
            if (this._errors == null) {
                this._errors = mfpt._errors;
            } else if (this._errors.length < 20) {
                this._errors = ArrayUtils.append(this._errors, mfpt._errors);
                if (this._errors.length > 20) {
                    this._errors = Arrays.copyOf(this._errors, 20);
                }
            }
            Log.trace("Finished a reduce stage of a file parse.");
        }

        private FVecParseWriter streamParse(InputStream is, ParseSetup localSetup, FVecParseWriter dout, InputStream bvs) throws IOException {
            Parser p2 = localSetup.parser(this._jobKey);
            if (localSetup._parse_type.isParallelParseSupported()) {
                p2.streamParseZip(is, dout, bvs);
            } else {
                p2.streamParse(is, dout);
            }
            dout.close(this._fs);
            return dout;
        }

        Futures onExceptionCleanup(Futures fs) {
            int nchunks = this._chunk2ParseNodeMap.length;
            int ncols = this._parseSetup._number_columns;
            for (int i2 = 0; i2 < ncols; ++i2) {
                Key<Vec> vkey = this._vg.vecKey(this._vecIdStart + i2);
                Keyed.remove(vkey, fs, true);
                for (int c2 = 0; c2 < nchunks; ++c2) {
                    DKV.remove(Vec.chunkKey(vkey, c2), fs);
                }
            }
            this.cancel(true);
            return fs;
        }

        static /* synthetic */ ParseWriter.ParseErr[] access$1202(MultiFileParseTask x0, ParseWriter.ParseErr[] x1) {
            x0._errors = x1;
            return x1;
        }

        private static class DistributedParse
        extends MRTask<DistributedParse> {
            private ParseSetup _setup;
            private final int _vecIdStart;
            private final int _startChunkIdx;
            private final Vec.VectorGroup _vg;
            private FVecParseWriter _dout;
            private final Key _cKey;
            private final Key<Job> _jobKey;
            private final transient MultiFileParseTask _outerMFPT;
            private final transient Key _srckey;
            private transient NonBlockingSetInt _visited;
            private transient long[] _espc;
            final int _nchunks;

            DistributedParse(Vec.VectorGroup vg, ParseSetup setup, int vecIdstart, int startChunkIdx, MultiFileParseTask mfpt, Key srckey, int nchunks) {
                super(null);
                this._vg = vg;
                this._setup = setup;
                this._vecIdStart = vecIdstart;
                this._startChunkIdx = startChunkIdx;
                this._outerMFPT = mfpt;
                this._cKey = mfpt._cKey;
                this._jobKey = mfpt._jobKey;
                this._srckey = srckey;
                this._nchunks = nchunks;
            }

            @Override
            public void setupLocal() {
                super.setupLocal();
                this._visited = new NonBlockingSetInt();
                this._espc = MemoryManager.malloc8(this._nchunks);
                this._setup = ParserService.INSTANCE.getByInfo(this._setup._parse_type).setupLocal(this._fr.anyVec(), this._setup);
            }

            @Override
            public void map(Chunk in) {
                FVecParseWriter dout;
                if (this._jobKey.get().stop_requested()) {
                    throw new Job.JobCancelledException();
                }
                AppendableVec[] avs = new AppendableVec[this._setup._parse_columns_indices.length];
                boolean notShrunkColumns = this._setup._parse_columns_indices.length == this._setup._number_columns;
                for (int i2 = 0; i2 < avs.length; ++i2) {
                    avs[i2] = this._setup._column_types == null ? new AppendableVec(this._vg.vecKey(this._vecIdStart + i2), this._espc, 3, this._startChunkIdx) : (notShrunkColumns ? new AppendableVec(this._vg.vecKey(this._vecIdStart + i2), this._espc, this._setup._column_types[i2], this._startChunkIdx) : new AppendableVec(this._vg.vecKey(this._vecIdStart + this._setup._parse_columns_indices[i2]), this._espc, this._setup._column_types[this._setup._parse_columns_indices[i2]], this._startChunkIdx));
                }
                FVecParseReader din = new FVecParseReader(in);
                Parser p2 = this._setup.parser(this._jobKey);
                switch (this._setup._parse_type.name()) {
                    case "ARFF": 
                    case "CSV": 
                    case "PARQUET": {
                        Categorical[] categoricals = MultiFileParseTask.categoricals(this._cKey, this._setup._number_columns);
                        dout = new FVecParseWriter(this._vg, this._startChunkIdx + in.cidx(), categoricals, this._setup._column_types, this._setup._chunk_size, avs, this._setup._parse_columns_indices, this._jobKey);
                        break;
                    }
                    case "SVMLight": {
                        dout = new SVMLightFVecParseWriter(this._vg, this._vecIdStart, in.cidx() + this._startChunkIdx, this._setup._chunk_size, avs, this._setup._parse_columns_indices, this._jobKey);
                        break;
                    }
                    case "ORC": {
                        Categorical[] orc_categoricals = MultiFileParseTask.categoricals(this._cKey, this._setup._number_columns);
                        dout = new FVecParseWriter(this._vg, in.cidx() + this._startChunkIdx, orc_categoricals, this._setup._column_types, this._setup._chunk_size, avs, this._setup._parse_columns_indices, this._jobKey);
                        break;
                    }
                    default: {
                        dout = new FVecParseWriter(this._vg, in.cidx() + this._startChunkIdx, null, this._setup._column_types, this._setup._chunk_size, avs, this._setup._parse_columns_indices, this._jobKey);
                    }
                }
                if ((this._setup.getParseType().name().toLowerCase().equals("svmlight") || this._setup.getParseType().name().toLowerCase().equals("avro")) && this._setup.getSkippedColumns() != null && this._setup.getSkippedColumns().length > 0) {
                    throw new H2OIllegalArgumentException("Parser: skipped_columns are not supported for SVMlight or Avro parsers.");
                }
                if (this._setup.getSkippedColumns() != null && (this._setup.get_parse_columns_indices() == null || this._setup.get_parse_columns_indices().length == 0)) {
                    throw new H2OIllegalArgumentException("Parser:  all columns in the file are skipped and no H2OFrame can be returned.");
                }
                p2.parseChunk(in.cidx(), din, dout);
                this._dout = dout;
                this._dout.close(this._fs);
                Job.update(in._len, this._jobKey);
                this.freeMem(in);
            }

            private void freeMem(Chunk in) {
                int cidx = in.cidx();
                for (int i2 = 0; i2 < 2; ++i2) {
                    if (this._visited.add(cidx += i2)) continue;
                    Value v2 = Value.STORE_get(in.vec().chunkKey(cidx));
                    if (v2 == null || !v2.isPersisted()) {
                        return;
                    }
                    v2.freePOJO();
                    v2.freeMem();
                }
            }

            @Override
            public void reduce(DistributedParse dp) {
                this._dout.reduce(dp._dout);
            }

            @Override
            public void postGlobal() {
                this._outerMFPT._dout[((MultiFileParseTask)this._outerMFPT)._lo] = this._dout;
                if (this._dout.hasErrors()) {
                    ParseWriter.ParseErr[] errs;
                    for (ParseWriter.ParseErr err : errs = this._dout.removeErrors()) {
                        err._file = FileVec.getPathForKey(this._srckey).toString();
                    }
                    Arrays.sort(errs, new Comparator<ParseWriter.ParseErr>(){

                        @Override
                        public int compare(ParseWriter.ParseErr o1, ParseWriter.ParseErr o2) {
                            return (int)(o1._byteOffset - o2._byteOffset);
                        }
                    });
                    MultiFileParseTask.access$1202(this._outerMFPT, errs);
                }
                this._dout = null;
                Value val = DKV.get(this._srckey);
                if (val == null) {
                    return;
                }
                Object ice = val.get();
                if (ice instanceof ByteVec) {
                    if (this._outerMFPT._deleteOnDone) {
                        ((ByteVec)ice).remove();
                    }
                } else {
                    Frame fr = (Frame)ice;
                    if (this._outerMFPT._deleteOnDone) {
                        fr.delete(this._outerMFPT._jobKey, new Futures(), true).blockForPending();
                    } else if (fr._key != null) {
                        fr.unlock(this._outerMFPT._jobKey);
                    }
                }
            }
        }
    }

    private static class SVFTask
    extends MRTask<SVFTask> {
        private final Frame _f;

        private SVFTask(Frame f2) {
            this._f = f2;
        }

        @Override
        public void setupLocal() {
            if (this._f.numCols() == 0) {
                return;
            }
            Vec v0 = this._f.anyVec();
            ArrayList<1> rs = new ArrayList<1>();
            for (int i2 = 0; i2 < v0.nChunks(); ++i2) {
                if (!v0.chunkKey(i2).home()) continue;
                final int fi = i2;
                rs.add(new RecursiveAction(){

                    @Override
                    protected void compute() {
                        Value val;
                        int nlines = 0;
                        for (Vec vec : _f.vecs()) {
                            val = Value.STORE_get(vec.chunkKey(fi));
                            if (val == null) continue;
                            nlines = ((Chunk)val.get())._len;
                            break;
                        }
                        int fnlines = nlines;
                        for (int j2 = 0; j2 < _f.numCols(); ++j2) {
                            Vec vec = _f.vec(j2);
                            Key k2 = vec.chunkKey(fi);
                            val = Value.STORE_get(k2);
                            if (val != null) continue;
                            H2O.putIfMatch(k2, new Value(k2, (Freezable)new C0LChunk(0L, fnlines)), null);
                        }
                    }
                });
            }
            ForkJoinTask.invokeAll(rs);
        }

        @Override
        public void reduce(SVFTask drt) {
        }
    }

    private static class GatherCategoricalDomainsTask
    extends MRTask<GatherCategoricalDomainsTask> {
        private final Key _k;
        private final int[] _catColIdxs;
        private byte[][] _packedDomains;
        private final int[] _parseColumns;

        private GatherCategoricalDomainsTask(Key k2, int[] ccols, int[] parseColumns) {
            this._k = k2;
            this._catColIdxs = ccols;
            this._parseColumns = parseColumns;
        }

        @Override
        public void setupLocal() {
            if (!MultiFileParseTask._categoricals.containsKey(this._k)) {
                return;
            }
            this._packedDomains = new byte[this._catColIdxs.length][];
            BufferedString[][] _perColDomains = new BufferedString[this._catColIdxs.length][];
            Categorical[] _colCats = (Categorical[])MultiFileParseTask._categoricals.get(this._k);
            int i2 = 0;
            for (int col : this._catColIdxs) {
                _colCats[this._parseColumns[col]].convertToUTF8(this._parseColumns[col] + 1);
                _perColDomains[i2] = _colCats[this._parseColumns[col]].getColumnDomain();
                Arrays.sort(_perColDomains[i2]);
                this._packedDomains[i2] = PackedDomains.pack(_perColDomains[i2]);
                ++i2;
            }
            Log.trace("Done locally collecting domains on each node.");
        }

        @Override
        public void reduce(final GatherCategoricalDomainsTask other) {
            if (this._packedDomains == null) {
                this._packedDomains = other._packedDomains;
            } else if (other._packedDomains != null) {
                H2O.H2OCountedCompleter[] domtasks = new H2O.H2OCountedCompleter[this._catColIdxs.length];
                for (int i2 = 0; i2 < this._catColIdxs.length; ++i2) {
                    final int fi = i2;
                    domtasks[i2] = new H2O.H2OCountedCompleter(GatherCategoricalDomainsTask.currThrPriority()){

                        @Override
                        public void compute2() {
                            ((GatherCategoricalDomainsTask)this)._packedDomains[fi] = PackedDomains.merge(_packedDomains[fi], other._packedDomains[fi]);
                            this.tryComplete();
                        }
                    };
                }
                ForkJoinTask.invokeAll(domtasks);
            }
            Log.trace("Done merging domains.");
        }

        public int getDomainLength(int colIdx) {
            return this._packedDomains == null ? 0 : PackedDomains.sizeOf(this._packedDomains[colIdx]);
        }

        public String[] getDomain(int colIdx) {
            return this._packedDomains == null ? null : PackedDomains.unpackToStrings(this._packedDomains[colIdx]);
        }
    }

    private static class UpdateCategoricalChunksTask
    extends MRTask<UpdateCategoricalChunksTask> {
        private final Key _parseCatMapsKey;
        private final int[] _chunk2ParseNodeMap;

        private UpdateCategoricalChunksTask(Key parseCatMapsKey, int[] chunk2ParseNodeMap) {
            this._parseCatMapsKey = parseCatMapsKey;
            this._chunk2ParseNodeMap = chunk2ParseNodeMap;
        }

        @Override
        public void map(Chunk[] chks) {
            CategoricalUpdateMap temp = (CategoricalUpdateMap)DKV.getGet(Key.make(this._parseCatMapsKey.toString() + "parseCatMapNode" + this._chunk2ParseNodeMap[chks[0].cidx()]));
            if (temp == null || temp.map == null) {
                throw new H2OIllegalValueException("Missing categorical update map", this);
            }
            int[][] _parse2GlobalCatMaps = temp.map;
            int cidx = chks[0].cidx();
            for (int i2 = 0; i2 < chks.length; ++i2) {
                Chunk chk = chks[i2];
                if (!(chk instanceof CStrChunk)) {
                    for (int j2 = 0; j2 < chk._len; ++j2) {
                        if (chk.isNA(j2)) continue;
                        int old = (int)chk.at8(j2);
                        if (old < 0 || _parse2GlobalCatMaps[i2] != null && old >= _parse2GlobalCatMaps[i2].length) {
                            chk.reportBrokenCategorical(i2, j2, old, _parse2GlobalCatMaps[i2], this._fr.vec(i2).domain().length);
                        }
                        if (_parse2GlobalCatMaps[i2] != null && _parse2GlobalCatMaps[i2][old] < 0) {
                            throw new H2OParseException("Error in unifying categorical values. This is typically caused by unrecognized characters in the data.\n The problem categorical value occurred in the " + PrettyPrint.withOrdinalIndicator(i2 + 1) + " categorical col, " + PrettyPrint.withOrdinalIndicator(chk.start() + (long)j2) + " row.");
                        }
                        if (_parse2GlobalCatMaps[i2] == null) continue;
                        chk.set(j2, _parse2GlobalCatMaps[i2][old]);
                    }
                    Log.trace("Updated domains for " + PrettyPrint.withOrdinalIndicator(i2 + 1) + " categorical column.");
                }
                chk.close(cidx, this._fs);
            }
        }

        @Override
        public void postGlobal() {
            for (int i2 = 0; i2 < H2O.CLOUD.size(); ++i2) {
                DKV.remove(Key.make(this._parseCatMapsKey.toString() + "parseCatMapNode" + i2));
            }
        }
    }

    private static class CreateParse2GlobalCategoricalMaps
    extends DTask<CreateParse2GlobalCategoricalMaps> {
        private final Key _parseCatMapsKey;
        private final Key _frKey;
        private final int[] _ecol;
        private final int[] _parseColumns;

        private CreateParse2GlobalCategoricalMaps(Key parseCatMapsKey, Key key, int[] ecol, int[] parseColumns) {
            this._parseCatMapsKey = parseCatMapsKey;
            this._frKey = key;
            this._ecol = ecol;
            this._parseColumns = parseColumns;
        }

        @Override
        public void compute2() {
            Frame _fr = (Frame)DKV.getGet(this._frKey);
            if (!MultiFileParseTask._categoricals.containsKey(this._parseCatMapsKey)) {
                this.tryComplete();
                return;
            }
            Categorical[] parseCatMaps = (Categorical[])MultiFileParseTask._categoricals.get(this._parseCatMapsKey);
            int[][] _nodeOrdMaps = new int[this._ecol.length][];
            for (int eColIdx = 0; eColIdx < this._ecol.length; ++eColIdx) {
                int colIdx = this._parseColumns[this._ecol[eColIdx]];
                if (parseCatMaps[colIdx].size() != 0) {
                    _nodeOrdMaps[eColIdx] = MemoryManager.malloc4(parseCatMaps[colIdx].maxId() + 1);
                    Arrays.fill(_nodeOrdMaps[eColIdx], -1);
                    BufferedString[] unifiedDomain = _fr.vec(this._ecol[eColIdx]).isCategorical() ? BufferedString.toBufferedString(_fr.vec(this._ecol[eColIdx]).domain()) : new BufferedString[]{};
                    for (int i2 = 0; i2 < unifiedDomain.length; ++i2) {
                        if (!parseCatMaps[colIdx].containsKey(unifiedDomain[i2])) continue;
                        _nodeOrdMaps[eColIdx][parseCatMaps[colIdx].getTokenId((BufferedString)unifiedDomain[i2])] = i2;
                    }
                    continue;
                }
                Log.debug("Column " + colIdx + " was marked as categorical but categorical map is empty!");
            }
            DKV.put(Key.make(this._parseCatMapsKey.toString() + "parseCatMapNode" + H2O.SELF.index()), new CategoricalUpdateMap(_nodeOrdMaps));
            this.tryComplete();
        }
    }

    private static class CategoricalUpdateMap
    extends Iced {
        final int[][] map;

        public CategoricalUpdateMap(int[][] map) {
            this.map = map;
        }
    }

    public static class ParserFJTask
    extends H2O.H2OCountedCompleter {
        final ParseDataset _pds;
        final Key[] _keys;
        final ParseSetup _setup;
        final boolean _deleteOnDone;

        public ParserFJTask(ParseDataset pds, Key[] keys, ParseSetup setup, boolean deleteOnDone) {
            this._pds = pds;
            this._keys = keys;
            this._setup = setup;
            this._deleteOnDone = deleteOnDone;
        }

        @Override
        public void compute2() {
            ParseDataset.parseAllKeys(this._pds, this._keys, this._setup, this._deleteOnDone);
            this.tryComplete();
        }

        @Override
        public boolean onExceptionalCompletion(Throwable ex, CountedCompleter caller) {
            this.parseCleanup();
            return true;
        }

        @Override
        public void onCompletion(CountedCompleter caller) {
            if (this._pds._job.stop_requested()) {
                this.parseCleanup();
            }
            this._pds._mfpt = null;
        }

        private void parseCleanup() {
            assert (!this._pds._job.isStopped());
            Futures fs = new Futures();
            MultiFileParseTask mfpt = this._pds._mfpt;
            this._pds._mfpt = null;
            if (mfpt != null) {
                mfpt.onExceptionCleanup(fs);
            }
            for (Key k2 : this._keys) {
                Keyed.remove(k2, fs, true);
            }
            Keyed.remove(this._pds._job._result, fs, true);
            fs.blockForPending();
        }
    }
}

